/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.text;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.TrieMap;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.gloss.AbstractGlossVectorGloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.parser.MWUParsingStream;
import com.ibm.dltj.util.CharacterMapper;
import com.ibm.dltj.util.StringBufferCharacterIterator;
import com.ibm.dltj.util.Utils;
import java.text.CharacterIterator;
import java.util.Collections;
import java.util.LinkedList;

public class TextModel
implements MWUParsingStream {
    static float WEIGHT_DEFAULT = 1.0f;
    static float WEIGHT_FOR_MW = 5.0f;
    static float WEIGHT_FOR_FIRST_IN_PARAGRAPH = 2.0f;
    static float WEIGHT_FOR_EMPHASIS = 1.0f;
    private CharacterIterator text;
    private boolean firstInSentence;
    private boolean firstInParagraph;
    private int sentenceBegin;
    private boolean doEmphasizeWord;
    SentenceAnnotation currentSentence;
    TrieMap wordIndex = new TrieMap();
    protected LinkedList<WordAnnotation> words = new LinkedList();
    protected LinkedList<SentenceAnnotation> sentences = new LinkedList();
    StringBuilder token = new StringBuilder();
    StringBufferCharacterIterator tokenItr = new StringBufferCharacterIterator(this.token);

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    private float positionWeight() {
        float f = 0.0f;
        if (this.doEmphasizeWord) {
            f += WEIGHT_FOR_EMPHASIS;
        }
        if (this.firstInParagraph) {
            f += WEIGHT_FOR_FIRST_IN_PARAGRAPH;
        }
        return f;
    }

    protected void processToken(CharSequence charSequence, Gloss gloss, float f) {
        this.dumpln(">" + ((Object)charSequence).toString() + " +" + f);
        this.tokenItr.setText(charSequence);
        WordAnnotation wordAnnotation = null;
        GlossCollection glossCollection = this.wordIndex.get(this.tokenItr, charSequence.length());
        if (glossCollection == null) {
            wordAnnotation = new WordAnnotation(((Object)charSequence).toString(), gloss);
            try {
                this.tokenItr.setIndex(0);
                this.wordIndex.add(this.tokenItr, charSequence.length(), wordAnnotation);
                this.words.add(wordAnnotation);
            }
            catch (DLTException dLTException) {
                dLTException.printStackTrace();
            }
        } else {
            wordAnnotation = (WordAnnotation)((Object)glossCollection);
            if (gloss != null) {
                wordAnnotation.gloss = gloss;
            }
        }
        ++wordAnnotation.numRef;
        wordAnnotation.weight += f;
        this.currentSentence.words.add(wordAnnotation);
    }

    @Override
    public void createMWU(int n, int n2, int n3, Gloss gloss) {
        block6: {
            block5: {
                this.token.setLength(0);
                if (!(gloss instanceof AbstractGlossVectorGloss)) break block5;
                AbstractGlossVectorGloss abstractGlossVectorGloss = (AbstractGlossVectorGloss)gloss;
                int n4 = abstractGlossVectorGloss.numChildren();
                for (int i = 0; i < n4; ++i) {
                    Gloss gloss2 = abstractGlossVectorGloss.getChild(i);
                    if (!(gloss2 instanceof LemmaGenerator)) continue;
                    LemmaGenerator lemmaGenerator = (LemmaGenerator)((Object)gloss2);
                    try {
                        lemmaGenerator.getLemma(this.text, n2, n3, this.token);
                        this.processToken(this.token, gloss, WEIGHT_FOR_MW + this.positionWeight());
                        continue;
                    }
                    catch (DLTException dLTException) {
                        // empty catch block
                    }
                }
                break block6;
            }
            if (!(gloss instanceof LemmaGenerator)) break block6;
            LemmaGenerator lemmaGenerator = (LemmaGenerator)((Object)gloss);
            try {
                lemmaGenerator.getLemma(this.text, n2, n3, this.token);
                this.processToken(this.token, gloss, WEIGHT_FOR_MW + this.positionWeight());
            }
            catch (DLTException dLTException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        Collections.sort(this.words);
        for (SentenceAnnotation sentenceAnnotation : this.sentences) {
            sentenceAnnotation.weight();
        }
        Collections.sort(this.sentences);
    }

    @Override
    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        if (this.firstInSentence) {
            this.sentenceBegin = n2;
            this.firstInSentence = false;
        }
        LemmaGenerator lemmaGenerator = null;
        this.token.setLength(0);
        for (Gloss gloss : glossCollection) {
            MidGloss midGloss;
            FeatureSetGloss featureSetGloss;
            if (!(gloss instanceof MidGloss) || (featureSetGloss = (midGloss = (MidGloss)gloss).getFeatureGloss()) == null) continue;
            if (featureSetGloss.is(201)) {
                this.doEmphasizeWord = true;
                Utils.makeString(this.token, this.text, n2, n3);
                this.dumpln(">>!" + this.token.toString());
                return;
            }
            if (featureSetGloss.is(200)) {
                Utils.makeString(this.token, this.text, n2, n3);
                this.dumpln(">>>" + this.token.toString());
                return;
            }
            LemmaGenerator lemmaGenerator2 = midGloss.getLemmaGloss();
            if (lemmaGenerator2 == null || lemmaGenerator2 == lemmaGenerator) continue;
            try {
                lemmaGenerator2.getLemma(this.text, n2, n3, this.token);
                this.processToken(this.token, gloss, this.positionWeight());
            }
            catch (DLTException dLTException) {
                // empty catch block
            }
            lemmaGenerator = lemmaGenerator2;
        }
        this.doEmphasizeWord = false;
        this.firstInSentence = false;
    }

    private void dumpln(String string) {
    }

    @Override
    public void createUnknown(int n, int n2, int n3, int n4) {
        if (this.firstInSentence) {
            this.sentenceBegin = n2;
        }
        this.doEmphasizeWord = false;
        this.firstInSentence = false;
        this.token.setLength(0);
        Utils.makeString(this.token, this.text, n2, n3);
        int n5 = this.token.length();
        for (int i = 0; i < n5; ++i) {
            this.token.setCharAt(i, CharacterMapper.toLowerCase(this.token.charAt(i)));
        }
        this.processToken(this.token, null, this.positionWeight());
    }

    @Override
    public void createBreakpoint(int n, int n2, int n3) {
        if (n3 == 2) {
            this.firstInSentence = true;
            this.firstInParagraph = false;
            this.currentSentence.begin = this.sentenceBegin;
            this.currentSentence.end = n2;
            this.sentenceBegin = n2;
            this.sentences.add(this.currentSentence);
            this.currentSentence = new SentenceAnnotation();
        }
        if (n3 == 1) {
            this.firstInParagraph = true;
        }
        this.doEmphasizeWord = false;
    }

    @Override
    public void createPunctuation(int n, int n2, int n3, int n4) {
    }

    @Override
    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.firstInSentence = true;
        this.doEmphasizeWord = false;
        this.text = uniLexAnalyzer.getSourceText();
        this.sentenceBegin = this.text.getIndex();
        this.words.clear();
        this.sentences.clear();
        this.wordIndex = new TrieMap();
        this.currentSentence = new SentenceAnnotation();
    }

    @Override
    public int startGroup(int n, int n2, int n3) {
        return 0;
    }

    @Override
    public void closeGroup(int n) {
    }

    @Override
    public void fork() {
    }

    @Override
    public void addToFork() {
    }

    @Override
    public void mergeRoutes(int n) {
    }

    private static class SentenceAnnotation
    implements Comparable<SentenceAnnotation> {
        int begin;
        int end;
        float weight = 0.0f;
        LinkedList<WordAnnotation> words = new LinkedList();

        private SentenceAnnotation() {
        }

        public void weight() {
            for (WordAnnotation wordAnnotation : this.words) {
                this.weight += wordAnnotation.getWeight();
            }
        }

        @Override
        public int compareTo(SentenceAnnotation sentenceAnnotation) {
            return this.weight < sentenceAnnotation.weight ? 1 : (this.weight > sentenceAnnotation.weight ? -1 : 0);
        }

        public synchronized int getBegin() {
            return this.begin;
        }

        public synchronized int getEnd() {
            return this.end;
        }

        public synchronized float getWeight() {
            return this.weight;
        }
    }

    private static class WordAnnotation
    implements Comparable<WordAnnotation> {
        private final String lemma;
        protected Gloss gloss;
        protected int numRef = 0;
        protected float weight = 0.0f;

        public WordAnnotation(String string, Gloss gloss) {
            this.lemma = string;
            this.gloss = gloss;
        }

        @Override
        public int compareTo(WordAnnotation wordAnnotation) {
            return this.weight < wordAnnotation.weight ? 1 : (this.weight > wordAnnotation.weight ? -1 : 0);
        }

        public synchronized String getLemma() {
            return this.lemma;
        }

        public synchronized float getWeight() {
            return this.weight;
        }

        public synchronized int getNumRef() {
            return this.numRef;
        }

        public synchronized Gloss getGloss() {
            return this.gloss;
        }
    }
}

