/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.token;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;

public enum TokenType {
    Token(0, 0, "com.ibm.langware.uimatypes.TokenAnnotation"),
    WordLikeToken(10, 0, "com.ibm.langware.uimatypes.WordLikeToken"),
    Alphabetic(20, 10, "com.ibm.langware.uimatypes.Alphabetic"),
    LowercaseAlphabetic(32, 20, "com.ibm.langware.uimatypes.LowercaseAlphabetic"),
    UppercaseAlphabetic(31, 20, "com.ibm.langware.uimatypes.UppercaseAlphabetic"),
    TitlecaseAlphabetic(30, 20, "com.ibm.langware.uimatypes.TitlecaseAlphabetic"),
    Arabic(37, 20, "com.ibm.langware.uimatypes.Arabic"),
    Hebrew(38, 20, "com.ibm.langware.uimatypes.Hebrew"),
    Syllabic(21, 10, "com.ibm.langware.uimatypes.Syllabic"),
    Hiragana(33, 21, "com.ibm.langware.uimatypes.Hiragana"),
    Katakana(34, 21, "com.ibm.langware.uimatypes.Katakana"),
    Hangul(35, 21, "com.ibm.langware.uimatypes.Hangul"),
    Ideographic(22, 10, "com.ibm.langware.uimatypes.Ideographic"),
    Han(36, 22, "com.ibm.langware.uimatypes.Han"),
    Numeric(23, 10, "com.ibm.langware.uimatypes.Numeric"),
    ChineseNumeral(42, 23, "com.ibm.langware.uimatypes.ChineseNumeral"),
    Punctuation(11, 0, "com.ibm.langware.uimatypes.Punctuation"),
    ClauseEndingPunctuation(24, 11, "com.ibm.langware.uimatypes.ClauseEndingPunctuation");

    private final int regexCode;
    private final int parentRegexCode;
    private final String tokenTypeName;
    private static final TokenType[] index;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    private TokenType(int n2, int n3, String string2) {
        this.regexCode = n2;
        this.parentRegexCode = n3;
        this.tokenTypeName = string2;
    }

    public int getRegexCode() {
        return this.regexCode;
    }

    public int getParentRegexCode() {
        return this.parentRegexCode;
    }

    public String getTokenTypeName() {
        return this.tokenTypeName;
    }

    public boolean isSubType(TokenType tokenType) {
        TokenType tokenType2 = this;
        while (tokenType2 != tokenType) {
            if (tokenType2.regexCode == tokenType2.parentRegexCode) {
                return false;
            }
            tokenType2 = index[tokenType2.parentRegexCode];
        }
        return true;
    }

    public static TokenType valueOf(char[] cArray, int n, int n2) {
        return TokenType.valueOf(TokenSubTypeExtractor.getCode(cArray, n, n2));
    }

    public static TokenType valueOf(CharSequence charSequence, int n, int n2) {
        return TokenType.valueOf(TokenSubTypeExtractor.getCode(charSequence, n, n2));
    }

    public static TokenType valueOf(int n) {
        if (n < 0 || n >= index.length) {
            return index[0];
        }
        return index[n];
    }

    static {
        int n = 0;
        for (TokenType tokenType : TokenType.values()) {
            n = Math.max(n, tokenType.getRegexCode());
        }
        index = new TokenType[n + 1];
        Arrays.fill((Object[])index, (Object)Token);
        TokenType[] tokenTypeArray = TokenType.values();
        int n2 = tokenTypeArray.length;
        for (int i = 0; i < n2; ++i) {
            TokenType tokenType;
            TokenType.index[tokenType.getRegexCode()] = tokenType = tokenTypeArray[i];
        }
    }

    private static final class TokenSubTypeExtractor {
        private static final char[] FSA;
        private static final byte[] char_map;
        private static final int FIRST_NODE = 1;
        private static final int CHAR_SIZE = 65536;

        private TokenSubTypeExtractor() {
        }

        private static int takeStep(int n, char c) {
            return FSA[n + char_map[c]];
        }

        static int getCode(char[] cArray, int n, int n2) {
            int n3 = 1;
            for (int i = n; i < n2; ++i) {
                n3 = TokenSubTypeExtractor.takeStep(n3, cArray[i]);
            }
            return FSA[n3 - 1];
        }

        static int getCode(CharSequence charSequence, int n, int n2) {
            int n3 = 1;
            for (int i = n; i < n2; ++i) {
                n3 = TokenSubTypeExtractor.takeStep(n3, charSequence.charAt(i));
            }
            return FSA[n3 - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            try {
                DataInputStream dataInputStream = null;
                try {
                    dataInputStream = new DataInputStream(TokenSubTypeExtractor.class.getResourceAsStream("classifier.rule.dat"));
                    int n = dataInputStream.readInt();
                    assert (n == 8);
                    char_map = new byte[65536];
                    dataInputStream.readFully(char_map);
                    n = dataInputStream.readInt();
                    assert (n == 16);
                    n = dataInputStream.readInt();
                    FSA = new char[n];
                    for (int i = 0; i < FSA.length; ++i) {
                        TokenSubTypeExtractor.FSA[i] = dataInputStream.readChar();
                    }
                }
                finally {
                    if (null != dataInputStream) {
                        dataInputStream.close();
                    }
                }
            }
            catch (IOException iOException) {
                throw new Error("TokenSubTypeExtractor static initialization", iOException);
            }
        }
    }
}

