/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.trellis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.trellis.DefaultGlossFilter;
import com.ibm.dltj.trellis.EdgeListElement;
import com.ibm.dltj.trellis.GlossFilter;
import com.ibm.dltj.trellis.SingleLinkedList;
import com.ibm.dltj.trellis.StateTrellis;
import com.ibm.dltj.trellis.Trellis;
import com.ibm.dltj.util.ArrayResize;

abstract class AbstractTrellis
implements Trellis {
    protected int startIndex;
    protected int endIndex;
    protected final GlossFilter filter;
    protected static final GlossCollection[] EMPTY_GLOSS_COLLECTION_ARRAY = new GlossCollection[0];
    protected static final boolean DEBUG = "1".equals(System.getProperty("com.ibm.dltj.trellis.debug"));
    protected final ElementList elementList = new ElementList();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    protected AbstractTrellis() {
        this(new DefaultGlossFilter());
    }

    protected AbstractTrellis(GlossFilter glossFilter) {
        this.filter = glossFilter;
    }

    @Override
    public void init(int n) {
        this.startIndex = this.endIndex = n;
    }

    @Override
    public void clear() {
        this.elementList.clear(this.endIndex - this.startIndex + 1);
        this.endIndex = 0;
        this.startIndex = 0;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public boolean isAmbiguous(int n) {
        if (this.isEmpty()) {
            return false;
        }
        return this.endIndex != n;
    }

    @Override
    public boolean isEmpty() {
        return this.startIndex == this.endIndex;
    }

    @Override
    public void addElement(int n, int n2, GlossCollection glossCollection) {
        if (this.endIndex < n2) {
            this.endIndex = n2;
        }
        this.elementList.chainUp(n - this.startIndex, this.elementList.addElement(n, n2, glossCollection));
    }

    @Override
    public GlossCollection[] getElement(int n, int n2) {
        int n3 = n - this.startIndex;
        int n4 = 0;
        GlossCollection glossCollection = null;
        int n5 = this.elementList.head(n3);
        while (n5 != 0) {
            if (n2 == this.elementList.endIndex[n5] && glossCollection != this.elementList.gloss[n5]) {
                glossCollection = this.elementList.gloss[n5];
                ++n4;
            }
            n5 = this.elementList.next(n5);
        }
        if (n4 == 0) {
            return EMPTY_GLOSS_COLLECTION_ARRAY;
        }
        GlossCollection[] glossCollectionArray = new GlossCollection[n4];
        n4 = 0;
        glossCollection = null;
        int n6 = this.elementList.head(n3);
        while (n6 != 0) {
            if (n2 == this.elementList.endIndex[n6] && glossCollection != this.elementList.gloss[n6]) {
                glossCollection = this.elementList.gloss[n6];
                glossCollectionArray[n4++] = this.elementList.gloss[n6];
            }
            n6 = this.elementList.next(n6);
        }
        return glossCollectionArray;
    }

    @Override
    public void append(Trellis trellis, int n, int n2, boolean bl) {
        StateTrellis stateTrellis = (StateTrellis)trellis;
        if (this.endIndex < n2) {
            this.endIndex = n2;
        }
        for (int i = n; i < n2; ++i) {
            int n3 = stateTrellis.elementList.head(i - stateTrellis.startIndex);
            while (n3 != 0) {
                int n4 = stateTrellis.elementList.startIndex[n3];
                int n5 = stateTrellis.elementList.endIndex[n3];
                if (n2 >= n5) {
                    GlossCollection glossCollection = stateTrellis.elementList.gloss[n3];
                    if (!bl || n != n4 || n2 != n5 || glossCollection.size() == 1 || glossCollection.get(0) instanceof TokenClassGloss) {
                        int n6 = this.elementList.addElement(n4, n5, glossCollection);
                        this.elementList.chainUp(i - this.startIndex, n6);
                    }
                }
                n3 = stateTrellis.elementList.next(n3);
            }
        }
    }

    @Override
    public abstract EdgeListElement process() throws DLTException;

    protected abstract void extract() throws DLTException;

    protected void terminate() {
    }

    protected static final class ElementList
    extends SingleLinkedList {
        int[] startIndex = EMPTY_INT_ARRAY;
        int[] endIndex = EMPTY_INT_ARRAY;
        GlossCollection[] gloss = EMPTY_GLOSS_COLLECTION_ARRAY;

        protected ElementList() {
        }

        public int addElement(int n, int n2, GlossCollection glossCollection) {
            int n3 = this.size++;
            this.ensureCapacity(n3);
            this.startIndex[n3] = n;
            this.endIndex[n3] = n2;
            this.gloss[n3] = glossCollection;
            return n3;
        }

        @Override
        protected void grow(int n) {
            super.grow(n);
            this.startIndex = (int[])ArrayResize.resize(this.startIndex, n);
            this.endIndex = (int[])ArrayResize.resize(this.endIndex, n);
            this.gloss = (GlossCollection[])ArrayResize.resize(this.gloss, n);
        }

        @Override
        protected void shrink() {
            super.shrink();
            this.startIndex = EMPTY_INT_ARRAY;
            this.endIndex = EMPTY_INT_ARRAY;
            this.gloss = EMPTY_GLOSS_COLLECTION_ARRAY;
        }

        public int startIndex(int n) {
            return this.startIndex[n];
        }

        public int endIndex(int n) {
            return this.endIndex[n];
        }

        public GlossCollection gloss(int n) {
            return this.gloss[n];
        }

        public int length(int n) {
            return this.endIndex[n] - this.startIndex[n];
        }
    }
}

