/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.trellis;

import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.util.ArrayResize;
import java.util.Arrays;

class SingleLinkedList {
    protected static final int[] EMPTY_INT_ARRAY = new int[0];
    protected static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected static final GlossCollection[] EMPTY_GLOSS_COLLECTION_ARRAY = new GlossCollection[0];
    private static final int SEGMENT_SIZE = 128;
    private static final int CEIL_SIZE = 1024;
    private int[] head = EMPTY_INT_ARRAY;
    private int[] tail = EMPTY_INT_ARRAY;
    private int[] next = EMPTY_INT_ARRAY;
    protected int size = 1;

    SingleLinkedList() {
    }

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public final int head() {
        return 1;
    }

    public final int tail() {
        return this.size;
    }

    public final int head(int n) {
        return n < this.head.length ? this.head[n] : 0;
    }

    public final int tail(int n) {
        return n < this.tail.length ? this.tail[n] : 0;
    }

    public final int next(int n) {
        return n < this.size ? this.next[n] : 0;
    }

    public final int size() {
        return this.size;
    }

    public void clear(int n) {
        assert (this.head.length == this.tail.length);
        if (this.head.length < 1024) {
            Arrays.fill(this.head, 0, Math.min(this.head.length, n), 0);
            Arrays.fill(this.tail, 0, Math.min(this.tail.length, n), 0);
        } else {
            this.head = EMPTY_INT_ARRAY;
            this.tail = EMPTY_INT_ARRAY;
        }
        if (this.next.length < 1024) {
            Arrays.fill(this.next, 0, Math.min(this.next.length, this.size), 0);
        } else {
            this.shrink();
        }
        this.size = 1;
    }

    final void ensureIndex(int n) {
        if (n >= this.head.length) {
            int n2 = (n / 128 + 1) * 128;
            this.head = (int[])ArrayResize.resize(this.head, n2);
            this.tail = (int[])ArrayResize.resize(this.tail, n2);
        }
    }

    final void ensureCapacity(int n) {
        if (n >= this.next.length) {
            this.grow((n / 128 + 1) * 128);
        }
    }

    protected void grow(int n) {
        this.next = (int[])ArrayResize.resize(this.next, n);
    }

    protected void shrink() {
        this.next = EMPTY_INT_ARRAY;
    }

    public final void chainUp(int n, int n2) {
        assert (n >= 0);
        assert (n2 != 0);
        this.ensureIndex(n);
        if (this.head[n] == 0) {
            this.head[n] = n2;
        } else {
            this.next[this.tail[n]] = n2;
        }
        this.tail[n] = n2;
    }
}

