/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.trellis;

import java.util.Arrays;

public class StateMatrix {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] bit = EMPTY_INT_ARRAY;
    private int[] bitsum = EMPTY_INT_ARRAY;
    private int[] head = EMPTY_INT_ARRAY;
    int[] endStates = EMPTY_INT_ARRAY;
    int[] weights = EMPTY_INT_ARRAY;
    private int hash = 1;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public StateMatrix() {
        this(EMPTY_INT_ARRAY, EMPTY_INT_ARRAY, EMPTY_INT_ARRAY);
    }

    public StateMatrix(int[] nArray, int[] nArray2, int[] nArray3) {
        this.add(nArray, nArray2, nArray3);
    }

    public void add(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int[] nArray4;
        assert (nArray.length == nArray2.length);
        assert (nArray.length == nArray3.length);
        if (nArray.length == 0) {
            return;
        }
        int n2 = this.size();
        if (n2 == 0) {
            nArray4 = StateMatrix.clone(nArray);
            this.endStates = StateMatrix.clone(nArray2);
            this.weights = StateMatrix.clone(nArray3);
        } else {
            nArray4 = StateMatrix.clone(nArray, nArray.length + n2);
            this.endStates = StateMatrix.clone(nArray2, nArray2.length + n2);
            this.weights = StateMatrix.clone(nArray3, nArray3.length + n2);
            n = nArray.length;
            for (int i = 0; i <= this.last(); ++i) {
                int n3 = this.index(i);
                if (n3 < 0) continue;
                for (int j = this.head(n3); j != this.tail(n3); ++j) {
                    nArray4[n] = i;
                    this.endStates[n] = this.endStates(j);
                    this.weights[n] = this.weights(j);
                    ++n;
                }
            }
        }
        StateMatrix.sort(nArray4, this.endStates, this.weights);
        this.index_build(nArray4);
        this.head = new int[this.index_length()];
        for (n = nArray4.length - 1; n >= 0; --n) {
            this.head[this.index((int)nArray4[n])] = n;
        }
        this.hash();
    }

    private static void sort(int[] nArray, int[] nArray2, int[] nArray3) {
        assert (nArray.length == nArray2.length);
        assert (nArray.length == nArray3.length);
        int n = nArray.length;
        for (int i = 0; i < n - 1; ++i) {
            int n2 = i;
            for (int j = i + 1; j < n; ++j) {
                int n3 = nArray[j] - nArray[n2];
                if (n3 == 0) {
                    n3 = nArray2[j] - nArray2[n2];
                }
                if (n3 == 0) {
                    n3 = nArray3[j] - nArray3[n2];
                }
                if (n3 >= 0) continue;
                n2 = j;
            }
            if (n2 == i) continue;
            StateMatrix.swap(nArray, i, n2);
            StateMatrix.swap(nArray2, i, n2);
            StateMatrix.swap(nArray3, i, n2);
        }
    }

    public int head(int n) {
        return n < this.head.length ? this.head[n] : this.endStates.length;
    }

    public int tail(int n) {
        return n < this.head.length - 1 ? this.head[n + 1] : this.endStates.length;
    }

    public int last() {
        return this.bit.length == 0 ? 0 : (this.bit.length - 1 << 5) + (31 - Integer.numberOfLeadingZeros(this.bit[this.bit.length - 1]));
    }

    public int size() {
        assert (this.endStates.length == this.weights.length);
        return this.endStates.length;
    }

    public int endStates(int n) {
        return n < 0 || this.endStates.length <= n ? 0 : this.endStates[n];
    }

    public int weights(int n) {
        return n < 0 || this.weights.length <= n ? 0 : this.weights[n];
    }

    public int index(int n) {
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        int n4 = 1 << n3;
        if (n2 >= this.bit.length || (this.bit[n2] & n4) == 0) {
            return -1;
        }
        return this.bitsum[n2] + Integer.bitCount(this.bit[n2] & --n4);
    }

    private void index_build(int[] nArray) {
        int n;
        if (nArray.length == 0) {
            return;
        }
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (n2 >= nArray[n]) continue;
            n2 = nArray[n];
        }
        n2 = (n2 >>> 5) + 1;
        this.bit = new int[n2];
        this.bitsum = new int[n2];
        for (n = 0; n < nArray.length; ++n) {
            int n3 = nArray[n];
            int n4 = n3 >>> 5;
            int n5 = n3 & 0x1F;
            int n6 = n4;
            this.bit[n6] = this.bit[n6] | 1 << n5;
        }
        for (n = 1; n < this.bitsum.length; ++n) {
            this.bitsum[n] = this.bitsum[n - 1] + Integer.bitCount(this.bit[n - 1]);
        }
    }

    private int index_length() {
        return this.bitsum.length == 0 ? 0 : this.bitsum[this.bitsum.length - 1] + Integer.bitCount(this.bit[this.bit.length - 1]);
    }

    private static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private static int[] clone(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        return nArray2;
    }

    private static int[] clone(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        return nArray2;
    }

    private void hash() {
        int n = 1;
        n = 31 * n + StateMatrix.hashCode(this.bit);
        n = 31 * n + StateMatrix.hashCode(this.head);
        n = 31 * n + StateMatrix.hashCode(this.endStates);
        this.hash = n = 31 * n + StateMatrix.hashCode(this.weights);
    }

    private static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            n = 31 * n + nArray[i];
        }
        return n;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StateMatrix stateMatrix = (StateMatrix)object;
        if (!Arrays.equals(this.bit, stateMatrix.bit)) {
            return false;
        }
        if (!Arrays.equals(this.head, stateMatrix.head)) {
            return false;
        }
        if (!Arrays.equals(this.endStates, stateMatrix.endStates)) {
            return false;
        }
        return Arrays.equals(this.weights, stateMatrix.weights);
    }
}

