/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.trellis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.trellis.AbstractTrellis;
import com.ibm.dltj.trellis.EdgeListElement;
import com.ibm.dltj.trellis.GlossFilter;
import com.ibm.dltj.trellis.SingleLinkedList;
import com.ibm.dltj.trellis.StateMatrix;
import com.ibm.dltj.trellis.StateNameHandler;
import com.ibm.dltj.util.ArrayResize;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class StateTrellis
extends AbstractTrellis {
    private static final int STATE_ID_START = 0;
    private static final int STATE_ID_FINAL = 1;
    protected final MatrixList matrixList = new MatrixList();
    private final EdgeList edgeList = new EdgeList();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    protected StateTrellis() {
    }

    protected StateTrellis(GlossFilter glossFilter) {
        super(glossFilter);
    }

    @Override
    public void clear() {
        this.matrixList.clear(this.elementList.size() + 1);
        this.edgeList.clear(this.endIndex - this.startIndex + 1);
        super.clear();
    }

    @Override
    public EdgeListElement process() throws DLTException {
        int n;
        int n2;
        int n3;
        this.terminate();
        this.extract();
        int n4 = this.endIndex - this.startIndex;
        this.edgeList.ensureIndex(n4 + 1);
        this.edgeList.chainUp(0, this.edgeList.addElement(this.startIndex, this.startIndex, 0, 0, 0, null, null, 0));
        for (n3 = 0; n3 <= n4; ++n3) {
            n2 = this.edgeList.head(n3);
            while (n2 != 0) {
                n = this.edgeList.endState[n2];
                int n5 = this.edgeList.weight[n2];
                int n6 = this.elementList.head(n3);
                while (n6 != 0) {
                    int n7 = this.elementList.startIndex[n6];
                    int n8 = this.elementList.endIndex[n6];
                    int n9 = this.matrixList.head(n6);
                    while (n9 != 0) {
                        StateMatrix stateMatrix;
                        int n10;
                        Object object = this.matrixList.gloss[n9];
                        if (this.filter.accept(object) && (n10 = (stateMatrix = this.matrixList.matrix[n9]).index(n)) != -1) {
                            Object object2 = this.matrixList.payload[n9];
                            int n11 = this.matrixList.ext[n9];
                            int n12 = stateMatrix.head(n10);
                            int n13 = stateMatrix.tail(n10);
                            for (int i = n12; i != n13; ++i) {
                                int n14 = stateMatrix.endStates[i];
                                int n15 = stateMatrix.weights[i] + n11 + n5;
                                int n16 = this.edgeList.head(n8 - this.startIndex);
                                while (n16 != 0) {
                                    if (n14 == this.edgeList.endState[n16]) {
                                        if (n15 >= this.edgeList.weight[n16]) break;
                                        this.edgeList.startIndex[n16] = n7;
                                        this.edgeList.startState[n16] = n;
                                        this.edgeList.weight[n16] = n15;
                                        this.edgeList.gloss[n16] = object;
                                        this.edgeList.payload[n16] = object2;
                                        this.edgeList.prev[n16] = n2;
                                        break;
                                    }
                                    n16 = this.edgeList.next(n16);
                                }
                                if (n16 != 0) continue;
                                n16 = this.edgeList.addElement(n7, n8, n, n14, n15, object, object2, n2);
                                this.edgeList.chainUp(n8 - this.startIndex, n16);
                            }
                        }
                        n9 = this.matrixList.next(n9);
                    }
                    n6 = this.elementList.next(n6);
                }
                n2 = this.edgeList.next(n2);
            }
        }
        n3 = 0;
        n2 = Integer.MAX_VALUE;
        n = this.edgeList.head(n4);
        while (n != 0) {
            if (this.edgeList.endState[n] == 1 && this.edgeList.weight[n] < n2) {
                n3 = n;
                n2 = this.edgeList.weight[n];
            }
            n = this.edgeList.next(n);
        }
        if (DEBUG) {
            this.toGraph();
        }
        return this.edgeList.impl(this.edgeList.reverse(n3));
    }

    private void toGraph() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmssSSS", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String string = simpleDateFormat.format(new Date());
        File file = new File(String.format("trellis-%s.txt", string));
        this.toText(file, "utf-8");
        File file2 = new File(String.format("trellis-%s.dot", string));
        this.toDot(file2, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toText(File file, String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), string));
            int n = this.endIndex - this.startIndex;
            for (int i = 0; i <= n; ++i) {
                int n2 = this.edgeList.head(i);
                while (n2 != 0) {
                    int n3 = this.edgeList.startIndex[n2];
                    int n4 = this.edgeList.endIndex[n2];
                    int n5 = this.edgeList.startState[n2];
                    int n6 = this.edgeList.endState[n2];
                    int n7 = this.edgeList.weight[n2];
                    Object object = this.edgeList.gloss[n2];
                    printWriter.printf("(@%d, #%d) -> (@%d, #%d) = %d\t%s", n3, n5, n4, n6, n7, object);
                    printWriter.println();
                    n2 = this.edgeList.next(n2);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toDot(File file, String string) {
        StateNameHandler stateNameHandler = StateNameHandler.getInstance();
        PrintWriter printWriter = null;
        try {
            int n;
            int n2;
            int n3;
            int n4;
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), string));
            printWriter.println("digraph \"G\" {");
            printWriter.println("rankdir=LR;");
            printWriter.println("node [shape=plaintext];");
            printWriter.println("\"0\" [label=\"Text Index:0\"];");
            int n5 = this.endIndex - this.startIndex;
            for (n4 = 0; n4 < n5; ++n4) {
                printWriter.printf("\"%d\" -> \"%d\";", n4, n4 + 1);
                printWriter.println();
            }
            printWriter.printf("node [fontsize=%d, fontname=%s, width=%f, height=%f, shape=ellipse];", 8, "\"MS Gothic,Arial Unicode MS,sans-serif\"", 0.25, 0.25);
            printWriter.println();
            for (n4 = 0; n4 <= n5; ++n4) {
                printWriter.printf("{ rank=same; \"%d\" ", n4);
                n3 = this.edgeList.head(n4);
                while (n3 != 0) {
                    n2 = this.edgeList.endIndex[n3];
                    n = this.edgeList.endState[n3];
                    if (n != 1) {
                        printWriter.printf("\"%d_%d\" ", n2, n);
                    }
                    n3 = this.edgeList.next(n3);
                }
                printWriter.println("; }");
                n3 = this.edgeList.head(n4);
                while (n3 != 0) {
                    n2 = this.edgeList.endIndex[n3];
                    n = this.edgeList.endState[n3];
                    printWriter.printf("\"%d_%d\" [label=\"#%d\\n%s\"];", n2, n, n, stateNameHandler.get(n));
                    printWriter.println();
                    n3 = this.edgeList.next(n3);
                }
            }
            printWriter.printf("edge [fontsize=%d, fontname=%s];", 8, "\"MS Gothic,Arial Unicode MS,sans-serif\"");
            printWriter.println();
            for (n4 = 0; n4 <= n5; ++n4) {
                n3 = this.edgeList.head(n4);
                while (n3 != 0) {
                    n2 = this.edgeList.startIndex[n3];
                    n = this.edgeList.endIndex[n3];
                    int n6 = this.edgeList.startState[n3];
                    int n7 = this.edgeList.endState[n3];
                    int n8 = this.edgeList.weight[n3];
                    printWriter.printf("\"%d_%d\"->\"%d_%d\" [label=\"%d\"];", n2, n6, n, n7, n8);
                    n3 = this.edgeList.next(n3);
                }
            }
            printWriter.println("}");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    protected static final class EdgeList
    extends SingleLinkedList {
        int[] startIndex = EMPTY_INT_ARRAY;
        int[] endIndex = EMPTY_INT_ARRAY;
        int[] startState = EMPTY_INT_ARRAY;
        int[] endState = EMPTY_INT_ARRAY;
        int[] weight = EMPTY_INT_ARRAY;
        Object[] gloss = EMPTY_OBJECT_ARRAY;
        Object[] payload = EMPTY_OBJECT_ARRAY;
        int[] prev = EMPTY_INT_ARRAY;

        protected EdgeList() {
        }

        public int addElement(int n, int n2, int n3, int n4, int n5, Object object, Object object2, int n6) {
            int n7 = this.size++;
            this.ensureCapacity(n7);
            this.startIndex[n7] = n;
            this.endIndex[n7] = n2;
            this.startState[n7] = n3;
            this.endState[n7] = n4;
            this.weight[n7] = n5;
            this.gloss[n7] = object;
            this.payload[n7] = object2;
            this.prev[n7] = n6;
            return n7;
        }

        @Override
        protected void grow(int n) {
            super.grow(n);
            this.startIndex = (int[])ArrayResize.resize(this.startIndex, n);
            this.endIndex = (int[])ArrayResize.resize(this.endIndex, n);
            this.startState = (int[])ArrayResize.resize(this.startState, n);
            this.endState = (int[])ArrayResize.resize(this.endState, n);
            this.weight = (int[])ArrayResize.resize(this.weight, n);
            this.gloss = (Object[])ArrayResize.resize(this.gloss, n);
            this.payload = (Object[])ArrayResize.resize(this.payload, n);
            this.prev = (int[])ArrayResize.resize(this.prev, n);
        }

        @Override
        protected void shrink() {
            super.shrink();
            this.startIndex = EMPTY_INT_ARRAY;
            this.endIndex = EMPTY_INT_ARRAY;
            this.startState = EMPTY_INT_ARRAY;
            this.endState = EMPTY_INT_ARRAY;
            this.weight = EMPTY_INT_ARRAY;
            this.gloss = EMPTY_OBJECT_ARRAY;
            this.payload = EMPTY_OBJECT_ARRAY;
            this.prev = EMPTY_INT_ARRAY;
        }

        public int reverse(int n) {
            if (n == 0) {
                return 0;
            }
            int n2 = this.prev[n];
            this.prev[n] = 0;
            while (n2 != 0) {
                int n3 = this.prev[n2];
                this.prev[n2] = n;
                n = n2;
                n2 = n3;
            }
            return n;
        }

        public EdgeListElement impl(final int n) {
            if (n == 0) {
                return null;
            }
            return new EdgeListElement(){

                @Override
                public int getStartIndex() {
                    return EdgeList.this.startIndex[n];
                }

                @Override
                public int getEndIndex() {
                    return EdgeList.this.endIndex[n];
                }

                @Override
                public Object getGloss() {
                    return EdgeList.this.gloss[n];
                }

                @Override
                public Object getPayload() {
                    return EdgeList.this.payload[n];
                }

                @Override
                public EdgeListElement getNext() {
                    return EdgeList.this.impl(EdgeList.this.prev[n]);
                }
            };
        }
    }

    protected static final class MatrixList
    extends SingleLinkedList {
        private static final StateMatrix[] EMPTY_STATE_MATRIX_ARRAY = new StateMatrix[0];
        StateMatrix[] matrix = EMPTY_STATE_MATRIX_ARRAY;
        Object[] gloss = EMPTY_OBJECT_ARRAY;
        int[] ext = EMPTY_INT_ARRAY;
        Object[] payload = EMPTY_OBJECT_ARRAY;

        protected MatrixList() {
        }

        public int addElement(StateMatrix stateMatrix, Object object, int n, Object object2) {
            int n2 = this.size++;
            this.ensureCapacity(n2);
            this.matrix[n2] = stateMatrix;
            this.gloss[n2] = object;
            this.ext[n2] = n;
            this.payload[n2] = object2;
            return n2;
        }

        @Override
        protected void grow(int n) {
            super.grow(n);
            this.matrix = (StateMatrix[])ArrayResize.resize(this.matrix, n);
            this.gloss = (Object[])ArrayResize.resize(this.gloss, n);
            this.ext = (int[])ArrayResize.resize(this.ext, n);
            this.payload = (Object[])ArrayResize.resize(this.payload, n);
        }

        @Override
        protected void shrink() {
            super.shrink();
            this.matrix = EMPTY_STATE_MATRIX_ARRAY;
            this.gloss = EMPTY_OBJECT_ARRAY;
            this.ext = EMPTY_INT_ARRAY;
            this.payload = EMPTY_OBJECT_ARRAY;
        }
    }
}

