/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.trellis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.gloss.JaGramSetGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.trellis.PaddingMatrix;
import com.ibm.dltj.util.HanNormalizer;
import java.text.CharacterIterator;

public enum TrellisPayload {
    UNKNOWN{

        @Override
        public String toReservedWord() {
            return "__IBM_LANGUAGEWARE_5_JAPANESE_MICHIGO__";
        }
    }
    ,
    NUMBER{

        @Override
        public String toReservedWord() {
            return "__IBM_LANGUAGEWARE_5_JAPANESE_NUMERAL__";
        }

        @Override
        public String normalizeWithPrefix(HanNormalizer hanNormalizer, CharacterIterator characterIterator, int n, int n2) {
            return hanNormalizer.normalize(characterIterator, n, n2, 1);
        }
    }
    ,
    ALNUM_DATE{

        @Override
        public String toReservedWord() {
            return "__IBM_LANGUAGEWARE_5_JAPANESE_NUMERAL__";
        }

        @Override
        public String normalizeWithPrefix(HanNormalizer hanNormalizer, CharacterIterator characterIterator, int n, int n2) {
            return hanNormalizer.normalizeWithPrefix(characterIterator, n, n2, 2);
        }
    }
    ,
    HAN_DATE{

        @Override
        public String toReservedWord() {
            return "__IBM_LANGUAGEWARE_5_JAPANESE_NUMERAL__";
        }

        @Override
        public String normalizeWithPrefix(HanNormalizer hanNormalizer, CharacterIterator characterIterator, int n, int n2) {
            return hanNormalizer.normalizeWithPrefix(characterIterator, n, n2, 3);
        }
    }
    ,
    NUMBER_NON_NORM{

        @Override
        public String toReservedWord() {
            return "__IBM_LANGUAGEWARE_5_JAPANESE_NUMERAL__";
        }
    }
    ,
    UNKNOWN_PROPER_NOUN{

        @Override
        public String toReservedWord() {
            return "__IBM_LANGUAGEWARE_5_JAPANESE_MICHI_KOYUU_MEISHI__";
        }
    }
    ,
    PROPER_NOUN{

        @Override
        public String toReservedWord() {
            return "__IBM_LANGUAGEWARE_5_JAPANESE_MICHIGO__";
        }

        @Override
        public String toAlternative() {
            return "__IBM_LANGUAGEWARE_5_JAPANESE_MICHI_KOYUU_MEISHI__";
        }
    }
    ,
    PADDING{

        @Override
        public String toReservedWord() {
            return "__IBM_LANGUAGEWARE_7_JAPANESE_PADDING__";
        }
    }
    ,
    LAST_EPSILON{

        @Override
        public boolean isOptional() {
            return false;
        }

        @Override
        public String toReservedWord() {
            return "__IBM_LANGUAGEWARE_5_JAPANESE_LAST_EPSILON__";
        }
    }
    ,
    DECOMP_KATAKANA{

        @Override
        public GlossCollection getFallbackGloss() {
            return null;
        }

        @Override
        public String toReservedWord() {
            return "__IBM_LANGUAGEWARE_7_JAPANESE_DECOMP_KATAKANA__";
        }
    }
    ,
    LETTER{

        @Override
        public String toReservedWord() {
            return "__IBM_LANGUAGEWARE_8_JAPANESE_LETTER__";
        }

        @Override
        public String toAlternative() {
            return "__IBM_LANGUAGEWARE_5_JAPANESE_MICHIGO__";
        }
    };


    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public boolean isOptional() {
        return true;
    }

    public GlossCollection getFallbackGloss() throws DLTException {
        return new GlossCollection(new MidGloss(new Gloss[]{new JaGramSetGloss(PaddingMatrix.newInstance())}));
    }

    public abstract String toReservedWord();

    public String toAlternative() {
        return this.toReservedWord();
    }

    public String normalizeWithPrefix(HanNormalizer hanNormalizer, CharacterIterator characterIterator, int n, int n2) {
        return null;
    }
}

