/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.trellis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.trellis.AbstractTrellis;
import com.ibm.dltj.trellis.EdgeListElement;
import com.ibm.dltj.trellis.GlossFilter;
import com.ibm.dltj.trellis.SingleLinkedList;
import com.ibm.dltj.util.ArrayResize;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class WeightTrellis
extends AbstractTrellis {
    protected final WeightList weightList = new WeightList();
    private final EdgeList edgeList = new EdgeList();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    protected WeightTrellis() {
    }

    protected WeightTrellis(GlossFilter glossFilter) {
        super(glossFilter);
    }

    @Override
    public void clear() {
        this.weightList.clear(this.elementList.size() + 1);
        this.edgeList.clear(this.endIndex - this.startIndex + 1);
        super.clear();
    }

    @Override
    public EdgeListElement process() throws DLTException {
        int n;
        int n2;
        int n3;
        this.terminate();
        this.extract();
        int n4 = this.endIndex - this.startIndex;
        this.edgeList.ensureIndex(n4 + 1);
        this.edgeList.chainUp(0, this.edgeList.addElement(this.startIndex, this.startIndex, 0, null, 0));
        for (n3 = 0; n3 <= n4; ++n3) {
            n2 = this.edgeList.head(n3);
            while (n2 != 0) {
                n = this.edgeList.weight[n2];
                int n5 = this.elementList.head(n3);
                while (n5 != 0) {
                    int n6 = this.elementList.startIndex[n5];
                    int n7 = this.elementList.endIndex[n5];
                    int n8 = this.weightList.head(n5);
                    while (n8 != 0) {
                        Object object = this.weightList.gloss[n8];
                        if (this.filter.accept(object)) {
                            int n9 = this.weightList.weight[n8] + n;
                            int n10 = this.edgeList.head(n7 - this.startIndex);
                            if (n10 != 0 && n9 < this.edgeList.weight[n10]) {
                                this.edgeList.startIndex[n10] = n6;
                                this.edgeList.weight[n10] = n9;
                                this.edgeList.gloss[n10] = object;
                                this.edgeList.prev[n10] = n2;
                            }
                            if (n10 == 0) {
                                n10 = this.edgeList.addElement(n6, n7, n9, object, n2);
                                this.edgeList.chainUp(n7 - this.startIndex, n10);
                            }
                        }
                        n8 = this.weightList.next(n8);
                    }
                    n5 = this.elementList.next(n5);
                }
                n2 = this.edgeList.next(n2);
            }
        }
        n3 = 0;
        n2 = Integer.MAX_VALUE;
        n = this.edgeList.head(n4);
        while (n != 0) {
            if (this.edgeList.weight[n] < n2) {
                n3 = n;
                n2 = this.edgeList.weight[n];
            }
            n = this.edgeList.next(n);
        }
        if (DEBUG) {
            this.toGraph();
        }
        return this.edgeList.impl(this.edgeList.reverse(n3));
    }

    private void toGraph() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmssSSS", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String string = simpleDateFormat.format(new Date());
        File file = new File(String.format("trellis-%s.txt", string));
        this.toText(file, "utf-8");
        File file2 = new File(String.format("trellis-%s.dot", string));
        this.toDot(file2, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toText(File file, String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), string));
            int n = this.endIndex - this.startIndex;
            for (int i = 0; i <= n; ++i) {
                int n2 = this.edgeList.head(i);
                while (n2 != 0) {
                    int n3 = this.edgeList.startIndex[n2];
                    int n4 = this.edgeList.endIndex[n2];
                    int n5 = this.edgeList.weight[n2];
                    Object object = this.edgeList.gloss[n2];
                    printWriter.printf("(%d -> %d) = %d\t%s", n3, n4, n5, object);
                    printWriter.println();
                    n2 = this.edgeList.next(n2);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toDot(File file, String string) {
        PrintWriter printWriter = null;
        try {
            int n;
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), string));
            printWriter.println("digraph \"G\" {");
            printWriter.println("rankdir=LR;");
            printWriter.println("node [shape=plaintext];");
            printWriter.println("\"0\" [label=\"Text Index:0\"];");
            int n2 = this.endIndex - this.startIndex;
            for (n = 0; n < n2; ++n) {
                printWriter.printf("\"%d\" -> \"%d\";", n, n + 1);
                printWriter.println();
            }
            printWriter.printf("node [fontsize=%d, fontname=%s, width=%f, height=%f, shape=ellipse];", 8, "\"MS Gothic,Arial Unicode MS,sans-serif\"", 0.25, 0.25);
            printWriter.println();
            for (n = 0; n <= n2; ++n) {
                printWriter.printf("{ rank=same; \"%d\" ", n);
                printWriter.printf("\"index%d\" ; }", n);
                printWriter.println();
                printWriter.printf("\"index%d\" [label=\"%d\"];", n, n);
                printWriter.println();
            }
            printWriter.printf("edge [fontsize=%d];", 8);
            printWriter.println();
            for (n = 0; n <= n2; ++n) {
                int n3 = this.edgeList.head(n);
                while (n3 != 0) {
                    int n4 = this.edgeList.startIndex[n3];
                    int n5 = this.edgeList.endIndex[n3];
                    int n6 = this.edgeList.weight[n3];
                    printWriter.printf("\"index%d\"->\"index%d\" [label=\"%d\"];", n4, n5, n6);
                    printWriter.println();
                    n3 = this.edgeList.next(n3);
                }
            }
            printWriter.println("}");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    protected static final class EdgeList
    extends SingleLinkedList {
        int[] startIndex = EMPTY_INT_ARRAY;
        int[] endIndex = EMPTY_INT_ARRAY;
        int[] weight = EMPTY_INT_ARRAY;
        Object[] gloss = EMPTY_OBJECT_ARRAY;
        int[] prev = EMPTY_INT_ARRAY;

        protected EdgeList() {
        }

        public int addElement(int n, int n2, int n3, Object object, int n4) {
            int n5 = this.size++;
            this.ensureCapacity(n5);
            this.startIndex[n5] = n;
            this.endIndex[n5] = n2;
            this.weight[n5] = n3;
            this.gloss[n5] = object;
            this.prev[n5] = n4;
            return n5;
        }

        @Override
        protected void grow(int n) {
            super.grow(n);
            this.startIndex = (int[])ArrayResize.resize(this.startIndex, n);
            this.endIndex = (int[])ArrayResize.resize(this.endIndex, n);
            this.weight = (int[])ArrayResize.resize(this.weight, n);
            this.gloss = (Object[])ArrayResize.resize(this.gloss, n);
            this.prev = (int[])ArrayResize.resize(this.prev, n);
        }

        @Override
        protected void shrink() {
            super.shrink();
            this.startIndex = EMPTY_INT_ARRAY;
            this.endIndex = EMPTY_INT_ARRAY;
            this.weight = EMPTY_INT_ARRAY;
            this.gloss = EMPTY_OBJECT_ARRAY;
            this.prev = EMPTY_INT_ARRAY;
        }

        public int reverse(int n) {
            if (n == 0) {
                return 0;
            }
            int n2 = this.prev[n];
            this.prev[n] = 0;
            while (n2 != 0) {
                int n3 = this.prev[n2];
                this.prev[n2] = n;
                n = n2;
                n2 = n3;
            }
            return n;
        }

        public EdgeListElement impl(final int n) {
            if (n == 0) {
                return null;
            }
            return new EdgeListElement(){

                @Override
                public int getStartIndex() {
                    return EdgeList.this.startIndex[n];
                }

                @Override
                public int getEndIndex() {
                    return EdgeList.this.endIndex[n];
                }

                @Override
                public Object getGloss() {
                    return EdgeList.this.gloss[n];
                }

                @Override
                public Object getPayload() {
                    return null;
                }

                @Override
                public EdgeListElement getNext() {
                    return EdgeList.this.impl(EdgeList.this.prev[n]);
                }
            };
        }
    }

    protected static final class WeightList
    extends SingleLinkedList {
        int[] weight = EMPTY_INT_ARRAY;
        Object[] gloss = EMPTY_OBJECT_ARRAY;

        protected WeightList() {
        }

        public int addElement(int n, Object object) {
            int n2 = this.size++;
            this.ensureCapacity(n2);
            this.weight[n2] = n;
            this.gloss[n2] = object;
            return n2;
        }

        @Override
        protected void grow(int n) {
            super.grow(n);
            this.weight = (int[])ArrayResize.resize(this.weight, n);
            this.gloss = (Object[])ArrayResize.resize(this.gloss, n);
        }

        @Override
        protected void shrink() {
            super.shrink();
            this.weight = EMPTY_INT_ARRAY;
            this.gloss = EMPTY_OBJECT_ARRAY;
        }
    }
}

