/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.um;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.Messages;
import com.ibm.dltj.UniLexAnalyzerConstants;
import com.ibm.dltj.data.BreakIteratorManager;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.KoMorphGloss;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.um.KMorph;
import java.text.StringCharacterIterator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum KPOS {
    UNK(0, 0),
    NNG(10010, 3),
    NNM(10040, 3, new String[]{"numsfx"}),
    NNP0(10300, 3, new String[]{"proper", "fname"}),
    NNP1(10310, 3, new String[]{"proper", "gname"}),
    NNP2(10320, 3, new String[]{"proper", "org"}),
    NNP3(10330, 3, new String[]{"proper", "cntry"}),
    NNP4(10340, 3, new String[]{"proper", "place"}),
    NNP5(10350, 3, new String[]{"proper"}),
    NNP6(10360, 3, new String[]{"proper", "fullname"}),
    NNB(10070, 3, new String[]{"formal_n"}),
    NP(10060, 1, new String[]{"pron"}),
    NP_JKS(66, 1, new String[]{"pron.jo_jg"}),
    NR(10080, 3, new String[]{"num"}),
    VV(10200, 2),
    VVJ(10230, 2, new String[]{"pred"}),
    VA(10235, 4),
    VXV(10400, 2, new String[]{"aux_v"}),
    VXJ(10430, 2, new String[]{"aux_j"}),
    VXA(10435, 4, new String[]{"aux_a"}),
    VVX(10290, 2),
    VAX(10298, 4),
    VCP(234, 4, new String[]{"copula"}),
    VCN(235, 4, new String[]{"copula_n"}),
    MM(530, 4, new String[]{"adn"}),
    MMN(532, 4, new String[]{"adn", "num"}),
    MAG(10550, 5),
    MAJ(10560, 8),
    IC(580, 7),
    JKS(701, 6, new String[]{"jo_jg"}),
    JKC(702, 6, new String[]{"jo_bg"}),
    JKG(703, 6, new String[]{"jo_gg"}),
    JKO(704, 6, new String[]{"jo_mg"}),
    JKB(705, 6, new String[]{"jo_bs"}),
    JKV(706, 6, new String[]{"jo_hg"}),
    JKQ(707, 6, new String[]{"jo_ig"}),
    JX(710, 6, new String[]{"jo_bo"}),
    JC(720, 6, new String[]{"jo_js"}),
    EP1(801, 0, new String[]{"aux"}),
    EP2(802, 0, new String[]{"aux"}),
    EP3(803, 0, new String[]{"aux"}),
    EP4(804, 0, new String[]{"aux"}),
    EP5(805, 0, new String[]{"aux"}),
    EF(820, 6, new String[]{"eomi_j"}),
    EC(830, 6, new String[]{"eomi_y"}),
    ETN(10850, 0),
    ETM(860, 0),
    XPN(610, 9),
    XSN(10620, 3, new String[]{"suffix"}),
    XSV(10640, 2),
    XSA(10660, 4),
    XR(680, 0),
    SF(990, 0, new String[]{"symbol"}),
    SP(991, 0, new String[]{"symbol"}),
    SS(992, 0, new String[]{"symbol"}),
    SE(993, 0, new String[]{"symbol"}),
    SO(994, 0, new String[]{"symbol"}),
    SW(995, 0, new String[]{"symbol"}),
    SL(950, 3, new String[]{"foreign"}),
    SH(960, 3, new String[]{"hanja"}),
    SN(103, 3, new String[]{"digit"}),
    NF(0, 0),
    NV(0, 0),
    NA(0, 0);

    private static final Logger _logger;
    private final int code;
    private final int frostPos;
    private final String[] takmiFtrs;
    private final String[] EMPTY_STRING_ARRAY = new String[0];
    private static Dictionary rbbi;

    private KPOS(int n2, int n3) {
        this.code = n2;
        this.frostPos = n3;
        this.takmiFtrs = this.EMPTY_STRING_ARRAY;
    }

    private KPOS(int n2, int n3, String[] stringArray) {
        this.code = n2;
        this.frostPos = n3;
        this.takmiFtrs = stringArray;
    }

    public int getIntegerCode() {
        return this.code;
    }

    public int getPOS() {
        return this.frostPos;
    }

    public String getTakmiPOS() {
        if (this.frostPos == 0 || this.frostPos == 10) {
            return "residual";
        }
        return FeatureSetGloss.getPOSName(this.frostPos).toLowerCase();
    }

    public String[] getTakmiFtrs() {
        return this.takmiFtrs;
    }

    public static KPOS createFromIntegerCode(int n) {
        for (KPOS kPOS : KPOS.values()) {
            if (kPOS.getIntegerCode() != n) continue;
            return kPOS;
        }
        if (1000 > n && n > 9999 && _logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, Messages.format("invalid.arg", n));
        }
        return UNK;
    }

    public static final KMorph selectKMorph(String string, int n) {
        KMorph kMorph;
        if (n > 10000 && (kMorph = KPOS.selectNounKMorph(string, KPOS.createFromIntegerCode(n))) != null) {
            return kMorph;
        }
        return KMorph.createFromIntegerCode(n);
    }

    public static final KMorph selectNounKMorph(String string, KPOS kPOS) {
        if (string == null || string.isEmpty() || kPOS == null) {
            return null;
        }
        switch (kPOS) {
            case NNG: 
            case NNP0: 
            case NNP1: 
            case NNP2: 
            case NNP3: 
            case NNP4: 
            case NNP5: 
            case NNP6: {
                int n;
                int n2;
                String string2 = string.substring(string.length() - 1);
                char c = string2.charAt(0);
                int n3 = kPOS.code - 10000;
                n3 = KPOS.isHangulSyllable(c) ? ((n2 = (n = c - 44032) % 28) == 0 ? ++n3 : (n2 == 8 ? (n3 += 3) : (n3 += 2))) : (KPOS.isAlnum(string2) ? (n3 += 4) : (n3 += 5));
                return KMorph.createFromIntegerCode(n3);
            }
        }
        return null;
    }

    private static final boolean isHangulSyllable(char c) {
        return '\uac00' <= c && c <= '\ud7af';
    }

    private static final boolean isAlnum(String string) {
        if (rbbi != null) {
            try {
                GlossCollection glossCollection = rbbi.lookupWord(new StringCharacterIterator(string), 1);
                if (glossCollection != null) {
                    int n = ((TokenClassGloss)glossCollection.first()).getBestClass();
                    switch (n) {
                        case 201: 
                        case 202: 
                        case 203: 
                        case 206: {
                            return true;
                        }
                        case 103: {
                            return KPOS.isLatinAlnum(string.charAt(0));
                        }
                    }
                    return false;
                }
            }
            catch (DLTException dLTException) {
                return KPOS.isLatinAlnum(string.charAt(0));
            }
        }
        return KPOS.isLatinAlnum(string.charAt(0));
    }

    private static final boolean isLatinAlnum(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    private static final void printTagMap() {
        for (KPOS kPOS : KPOS.values()) {
            System.out.println(kPOS.getIntegerCode() + "=" + kPOS.name());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void printExtraMap(boolean bl, boolean bl2) {
        void var8_15;
        int n;
        KPOS[] kPOSArray = new KPOS[]{VV, VVJ, VA, VXV, VXJ, VXA, VVX, VAX, VCP, VCN};
        KPOS[] kPOSArray2 = new KPOS[]{EP1, EP2, EP3, EP4, EP5};
        KPOS[] kPOSArray3 = new KPOS[]{EC, EF, ETM, ETN};
        HashSet<EnumSet<KPOS>> hashSet = new HashSet<EnumSet<KPOS>>();
        for (n = 0; n < kPOSArray2.length; ++n) {
            hashSet.add(EnumSet.of(kPOSArray2[n]));
        }
        for (n = 1; n < kPOSArray2.length; ++n) {
            HashSet hashSet2 = new HashSet();
            for (int i = n; i < kPOSArray2.length; ++i) {
                for (EnumSet enumSet : hashSet) {
                    EnumSet<KPOS> string2 = EnumSet.copyOf(enumSet);
                    string2.add(kPOSArray2[i]);
                    hashSet2.add(string2);
                }
            }
            hashSet.addAll(hashSet2);
        }
        HashSet<EnumSet<KPOS>> hashSet3 = new HashSet<EnumSet<KPOS>>();
        for (EnumSet enumSet : hashSet) {
            for (int i = 0; i < kPOSArray3.length; ++i) {
                EnumSet<KPOS> string = EnumSet.copyOf(enumSet);
                string.add(kPOSArray3[i]);
                hashSet3.add(string);
            }
        }
        hashSet.addAll(hashSet3);
        for (int i = 0; i < kPOSArray3.length; ++i) {
            hashSet.add(EnumSet.of(kPOSArray3[i]));
        }
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        boolean i = false;
        while (var8_15 < kPOSArray.length) {
            for (EnumSet enumSet : hashSet) {
                for (Object object : KMorph.values()) {
                    if (object.getKpos() != kPOSArray[var8_15]) continue;
                    KoMorphGloss koMorphGloss = new KoMorphGloss(0, kPOSArray[var8_15].getIntegerCode(), false, false);
                    koMorphGloss.setInflectionFlags(enumSet);
                    if (koMorphGloss.encodeShortMorphCode(object.getCode()) == 0) continue;
                    StringBuilder stringBuilder = new StringBuilder(kPOSArray[var8_15].name());
                    stringBuilder.append(koMorphGloss.getEncodedTags());
                    treeMap.put(koMorphGloss.getPOS(), stringBuilder.toString());
                }
            }
            for (KMorph kMorph : KMorph.values()) {
                KoMorphGloss koMorphGloss;
                Object object;
                if (kMorph.getKpos() != kPOSArray[var8_15] || (koMorphGloss = new KoMorphGloss(0, kPOSArray[var8_15].getIntegerCode(), false, false)).encodeShortMorphCode(kMorph.getCode()) == 0) continue;
                object = new StringBuilder(kPOSArray[var8_15].name());
                ((StringBuilder)object).append(koMorphGloss.getEncodedTags());
                treeMap.put(koMorphGloss.getPOS(), ((StringBuilder)object).toString());
            }
            ++var8_15;
        }
        for (Integer n2 : treeMap.keySet()) {
            String string = (String)treeMap.get(n2);
            if (bl2) {
                System.out.print(string);
                String string2 = string.substring(0, string.indexOf(95));
                System.out.print("\t" + Enum.valueOf(KPOS.class, string2).getTakmiPOS());
                if (string.contains("_EF")) {
                    System.out.print("\teomi_j");
                }
                if (string.contains("_EC")) {
                    System.out.print("\teomi_y");
                }
                System.out.println();
                continue;
            }
            if (bl) {
                System.out.println(n2.toString() + "=" + string);
                continue;
            }
            System.out.println(n2.toString() + "=" + (string.indexOf(95) > 0 ? string.substring(0, string.indexOf(95)) : string));
        }
    }

    private static final void printTAKMIMap() {
        for (KPOS kPOS : KPOS.values()) {
            System.out.print(kPOS.name() + "\t" + kPOS.getTakmiPOS());
            for (String string : kPOS.getTakmiFtrs()) {
                System.out.print("\t" + string);
            }
            System.out.println();
        }
    }

    static {
        _logger = Logger.getLogger(KMorph.class.getName());
        try {
            rbbi = BreakIteratorManager.constructBreakIterator(UniLexAnalyzerConstants.KOREAN);
        }
        catch (DLTException dLTException) {
            rbbi = null;
        }
    }
}

