/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import java.lang.reflect.Array;

public class ArrayUtils {
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final double[][] EMPTY_DOUBLE_DARRAY = new double[0][];
    public static final double[][][] EMPTY_DOUBLE_TARRAY = new double[0][][];
    public static final float[][] EMPTY_FLOAT_DARRAY = new float[0][];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public static double[] insertAt(double[] dArray, int n, double d) {
        double[] dArray2 = new double[Math.max(dArray.length, n) + 1];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        System.arraycopy(dArray, n, dArray2, n + 1, dArray.length - n);
        dArray2[n] = d;
        return dArray2;
    }

    public static final float max(float[] fArray) {
        int n = fArray.length - 1;
        float f = fArray[n];
        while (--n >= 0) {
            f = Math.max(f, fArray[n]);
        }
        return f;
    }

    public static final float min(float[] fArray) {
        int n = fArray.length - 1;
        float f = fArray[n];
        while (--n >= 0) {
            f = Math.min(f, fArray[n]);
        }
        return f;
    }

    public static int maxAt(double[] dArray) {
        assert (dArray.length > 0);
        int n = 0;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[n] < dArray[i])) continue;
            n = i;
        }
        return n;
    }

    public static int[] resize(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        return nArray2;
    }

    public static float[] resize(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, Math.min(fArray.length, n));
        return fArray2;
    }

    public static double[] resize(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, Math.min(dArray.length, n));
        return dArray2;
    }

    public static double[][] resize(double[][] dArray, int n) {
        double[][] dArrayArray = new double[n][];
        System.arraycopy(dArray, 0, dArrayArray, 0, Math.min(dArray.length, n));
        return dArrayArray;
    }

    public static <T> T[] resize(T[] TArray, int n) {
        Class<?> clazz = TArray.getClass().getComponentType();
        Object object = Array.newInstance(clazz, n);
        System.arraycopy(TArray, 0, object, 0, Math.min(Array.getLength(TArray), n));
        return (Object[])object;
    }

    public static int[] ensureCapacity(int[] nArray, int n) {
        if (nArray.length >= n) {
            return nArray;
        }
        return ArrayUtils.resize(nArray, Math.max(nArray.length * 2, n));
    }

    public static double[] ensureCapacity(double[] dArray, int n) {
        if (dArray.length >= n) {
            return dArray;
        }
        return ArrayUtils.resize(dArray, Math.max(dArray.length * 2, n));
    }

    public static double[][] ensureCapacity(double[][] dArray, int n) {
        if (dArray.length >= n) {
            return dArray;
        }
        return ArrayUtils.resize(dArray, Math.max(dArray.length * 2, n));
    }

    public static <T> T[] ensureCapacity(T[] TArray, int n) {
        if (TArray.length >= n) {
            return TArray;
        }
        return ArrayUtils.resize(TArray, Math.max(TArray.length * 2, n));
    }

    public static void rotateRight(double[] dArray, int n, int n2) {
        double d = dArray[n2 - 1];
        System.arraycopy(dArray, n, dArray, n + 1, n2 - n - 1);
        dArray[n] = d;
    }

    public static double sum(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d;
    }

    public static boolean isEmpty(int[] nArray) {
        for (int n : nArray) {
            if (n == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(double[] dArray) {
        for (double d : dArray) {
            if (d == 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(float[] fArray) {
        for (float f : fArray) {
            if ((double)f == 0.0) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (string != stringArray[i] && !string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }
}

