/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import java.text.CharacterIterator;

public final class BoundedCharacterIterator
implements CharacterIterator {
    private final CharacterIterator itr;
    private int beginIndex;
    private int endIndex;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public BoundedCharacterIterator(CharacterIterator characterIterator, int n, int n2) {
        this.itr = characterIterator;
        this.endIndex = n2;
        this.beginIndex = n;
        this.itr.setIndex(n);
    }

    public void setBoundaries(int n, int n2) {
        this.beginIndex = n;
        this.endIndex = n2;
        this.itr.setIndex(n);
    }

    @Override
    public char current() {
        if (this.itr.getIndex() >= this.beginIndex && this.itr.getIndex() < this.endIndex) {
            return this.itr.current();
        }
        return '\uffff';
    }

    @Override
    public char first() {
        this.itr.setIndex(this.beginIndex);
        return this.itr.current();
    }

    @Override
    public int getBeginIndex() {
        return this.beginIndex;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public int getIndex() {
        return this.itr.getIndex();
    }

    @Override
    public char last() {
        if (this.endIndex != this.beginIndex) {
            this.itr.setIndex(this.endIndex - 1);
        } else {
            this.itr.setIndex(this.endIndex);
        }
        return this.itr.current();
    }

    @Override
    public char next() {
        if (this.itr.getIndex() < this.endIndex - 1) {
            return this.itr.next();
        }
        this.itr.setIndex(this.endIndex);
        return '\uffff';
    }

    @Override
    public char previous() {
        if (this.itr.getIndex() > this.beginIndex) {
            return this.itr.previous();
        }
        return '\uffff';
    }

    @Override
    public char setIndex(int n) {
        if (n < this.beginIndex || n > this.endIndex) {
            throw new IllegalArgumentException("Invalid index");
        }
        return this.itr.setIndex(n);
    }

    @Override
    public Object clone() {
        try {
            BoundedCharacterIterator boundedCharacterIterator = (BoundedCharacterIterator)super.clone();
            return boundedCharacterIterator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

