/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

public class BoundedIntHeap {
    private final int[] data;
    private final int CELL_COUNT;
    private final int CELL_SIZE;
    private int freepos;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public BoundedIntHeap(int n, int n2) {
        this.CELL_COUNT = n;
        this.CELL_SIZE = n2;
        this.data = new int[this.CELL_COUNT * this.CELL_SIZE];
        this.clear();
    }

    public void clear() {
        this.data[0] = Integer.MAX_VALUE;
        this.freepos = 0;
    }

    public int getCount() {
        return this.freepos;
    }

    public boolean isFull() {
        return this.freepos == this.CELL_COUNT;
    }

    public boolean isEmpty() {
        return this.freepos == 0;
    }

    public int allocateCell(int n) {
        assert (this.freepos < this.CELL_COUNT);
        int n2 = this.freepos++;
        this.data[n2 * this.CELL_SIZE] = n;
        return this.moveUp(n2);
    }

    public void removeTop() {
        assert (this.freepos > 0);
        --this.freepos;
        if (this.freepos == 0) {
            this.data[0] = Integer.MAX_VALUE;
        } else {
            this.move(this.freepos, 0);
            this.moveDown(0);
        }
    }

    public int allocateReplaceLast(int n) {
        if (this.freepos == this.CELL_COUNT) {
            int n2 = this.CELL_COUNT - 1;
            if (this.data[n2 * this.CELL_SIZE] > n) {
                this.data[n2 * this.CELL_SIZE] = n;
                return n2;
            }
            return -1;
        }
        int n3 = this.freepos++;
        if (this.freepos > 1 && this.data[(n3 - 1) * this.CELL_SIZE] > n) {
            this.move(n3 - 1, n3);
            this.data[(n3 - 1) * this.CELL_SIZE] = n;
            return this.moveUp(n3 - 1);
        }
        this.data[n3 * this.CELL_SIZE] = n;
        return n3;
    }

    public void removeTopKeepLast() {
        assert (this.freepos > 0);
        --this.freepos;
        if (this.freepos == 0) {
            this.data[0] = Integer.MAX_VALUE;
        } else if (this.freepos == 1) {
            this.move(this.freepos, 0);
        } else if (this.freepos > 1) {
            this.move(this.freepos - 1, 0);
            this.move(this.freepos, this.freepos - 1);
            this.moveDown(0);
        }
    }

    public void setValue(int n, int n2, int n3) {
        assert (n2 > 0 && n2 < this.CELL_SIZE);
        assert (n < this.CELL_COUNT);
        this.data[n * this.CELL_SIZE + n2] = n3;
    }

    public int getTopKey() {
        return this.data[0];
    }

    public int getTopValue(int n) {
        assert (n > 0 && n < this.CELL_SIZE);
        return this.data[n];
    }

    public int getValue(int n, int n2) {
        assert (n2 > 0 && n2 < this.CELL_SIZE);
        assert (n < this.CELL_COUNT);
        return this.data[n * this.CELL_SIZE + n2];
    }

    public int find(int n, int n2) {
        for (int i = n2; i < this.freepos; ++i) {
            if (this.data[i * this.CELL_SIZE] != n) continue;
            return i;
        }
        return -1;
    }

    public int countInstances(int n) {
        int n2 = 0;
        for (int i = 0; i < this.freepos; ++i) {
            if (this.data[i * this.CELL_SIZE] != n) continue;
            ++n2;
        }
        return n2;
    }

    private void swap(int n, int n2) {
        n *= this.CELL_SIZE;
        n2 *= this.CELL_SIZE;
        for (int i = 0; i < this.CELL_SIZE; ++i) {
            int n3 = this.data[n + i];
            this.data[n + i] = this.data[n2 + i];
            this.data[n2 + i] = n3;
        }
    }

    private void move(int n, int n2) {
        n *= this.CELL_SIZE;
        n2 *= this.CELL_SIZE;
        for (int i = 0; i < this.CELL_SIZE; ++i) {
            this.data[n2 + i] = this.data[n + i];
        }
    }

    private int moveUp(int n) {
        if (n == 0) {
            return n;
        }
        int n2 = (n + 1) / 2 - 1;
        if (this.data[n2 * this.CELL_SIZE] > this.data[n * this.CELL_SIZE]) {
            this.swap(n, n2);
            return this.moveUp(n2);
        }
        return n;
    }

    private int moveDown(int n) {
        int n2 = (n + 1) * 2 - 1;
        if (n2 >= this.freepos) {
            return n;
        }
        if (n2 + 1 < this.freepos && this.data[n2 * this.CELL_SIZE] > this.data[(n2 + 1) * this.CELL_SIZE]) {
            ++n2;
        }
        if (this.data[n * this.CELL_SIZE] > this.data[n2 * this.CELL_SIZE]) {
            this.swap(n, n2);
            return this.moveDown(n2);
        }
        return n;
    }

    public boolean verifyState() {
        int n = 0;
        while (2 * (n + 1) - 1 < this.freepos) {
            if (this.data[n * this.CELL_SIZE] > this.data[((n + 1) * 2 - 1) * this.CELL_SIZE]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean verifyStateKeepLast() {
        if (!this.verifyState()) {
            return false;
        }
        if (this.freepos == 0) {
            return true;
        }
        int n = -1;
        for (int i = 0; i < this.freepos; ++i) {
            n = Math.max(n, this.data[i * this.CELL_SIZE]);
        }
        return n <= this.data[(this.freepos - 1) * this.CELL_SIZE];
    }

    public String toString() {
        String string = "[";
        for (int i = 0; i < this.freepos; ++i) {
            string = string + "(" + this.data[i * this.CELL_SIZE];
            for (int j = 1; j < this.CELL_SIZE; ++j) {
                string = string + " " + this.data[i * this.CELL_SIZE + j];
            }
            string = string + ")";
        }
        return string + "]";
    }
}

