/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.util.CharacterFilterSpecification;
import com.ibm.dltj.util.CharacterMapper;
import java.text.CharacterIterator;

public class CharacterFilteringIterator
implements CharacterIterator {
    CharacterIterator it;
    CharacterFilterSpecification spec;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public CharacterFilteringIterator(CharacterFilterSpecification characterFilterSpecification, CharacterIterator characterIterator) {
        this.it = characterIterator;
        this.spec = characterFilterSpecification;
    }

    public void setIterator(CharacterIterator characterIterator) {
        this.it = characterIterator;
    }

    private char getFiltered(char c) {
        return CharacterFilteringIterator.getFiltered(this.spec, c);
    }

    public static char getFiltered(CharacterFilterSpecification characterFilterSpecification, char c) {
        String string;
        int n = 0;
        while ((string = characterFilterSpecification.getEquivalentCharacters(n++)) != null) {
            if (string.indexOf(c) < 0) continue;
            return string.charAt(0);
        }
        return c;
    }

    @Override
    public char current() {
        return this.getFiltered(this.it.current());
    }

    @Override
    public char first() {
        return this.getFiltered(this.it.first());
    }

    @Override
    public char last() {
        return this.getFiltered(this.it.last());
    }

    @Override
    public char next() {
        return this.getFiltered(this.it.next());
    }

    @Override
    public char previous() {
        return this.getFiltered(this.it.previous());
    }

    @Override
    public int getBeginIndex() {
        return this.it.getBeginIndex();
    }

    @Override
    public int getEndIndex() {
        return this.it.getEndIndex();
    }

    @Override
    public int getIndex() {
        return this.it.getIndex();
    }

    @Override
    public char setIndex(int n) {
        return this.getFiltered(this.it.setIndex(n));
    }

    @Override
    public Object clone() {
        return new CharacterFilteringIterator(this.spec, (CharacterIterator)this.it.clone());
    }

    public static String filter(CharacterFilterSpecification characterFilterSpecification, String string) {
        char c;
        int n;
        if (characterFilterSpecification == null) {
            return string;
        }
        char c2 = '\u0000';
        for (n = 0; n < string.length() && (c2 = CharacterFilteringIterator.getFiltered(characterFilterSpecification, c = string.charAt(n))) == c; ++n) {
        }
        if (n == string.length()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.setLength(n);
        stringBuilder.append(c2);
        ++n;
        while (n < string.length()) {
            stringBuilder.append(CharacterFilteringIterator.getFiltered(characterFilterSpecification, string.charAt(n)));
            ++n;
        }
        return stringBuilder.toString();
    }

    public static boolean equalFiltered(CharacterFilterSpecification characterFilterSpecification, String string, String string2) {
        if (string.length() != string2.length()) {
            return false;
        }
        if (characterFilterSpecification == null) {
            return string2.equals(string);
        }
        for (int i = 0; i < string2.length(); ++i) {
            if (CharacterFilteringIterator.getFiltered(characterFilterSpecification, string.charAt(i)) == string2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalFilteredLowercased(CharacterFilterSpecification characterFilterSpecification, String string, String string2) {
        if (string.length() != string2.length()) {
            return false;
        }
        if (characterFilterSpecification == null) {
            return string2.equalsIgnoreCase(string);
        }
        for (int i = 0; i < string2.length(); ++i) {
            if (CharacterMapper.toLowerCase(CharacterFilteringIterator.getFiltered(characterFilterSpecification, string.charAt(i))) == string2.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

