/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChecksumInputStream
extends FilterInputStream {
    private long _checkSum;
    private long _markCheckSum;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public ChecksumInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n == -1) {
            return -1;
        }
        this._checkSum += (long)(n & 0xFF);
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n == -1) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            this._checkSum += (long)(byArray[i] & 0xFF);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 == -1) {
            return -1;
        }
        for (int i = n; i < n + n3; ++i) {
            this._checkSum += (long)(byArray[i] & 0xFF);
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l > 0L && this.read() != -1) {
            ++l2;
            --l;
        }
        return l2;
    }

    @Override
    public synchronized void mark(int n) {
        this._markCheckSum = this._checkSum;
        super.mark(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this._checkSum = this._markCheckSum;
    }

    public long getCheckSum() {
        return this._checkSum;
    }
}

