/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.Messages;
import com.ibm.dltj.util.StringBufferCharacterIterator;
import com.ibm.icu.text.Normalizer2;
import java.io.InputStream;
import java.text.CharacterIterator;
import java.util.Arrays;

public class DecomposingCharacterIterator
implements CharacterIterator {
    private final int origBeginIndex;
    private CharacterIterator decompItr;
    private final int[] map;

    public DecomposingCharacterIterator(CharacterIterator characterIterator, InputStream inputStream, String string) {
        this.origBeginIndex = characterIterator.getBeginIndex();
        this.map = new int[characterIterator.getEndIndex() - this.origBeginIndex + 1];
        Normalizer2 normalizer2 = Normalizer2.getInstance((InputStream)inputStream, (String)string, (Normalizer2.Mode)Normalizer2.Mode.DECOMPOSE);
        int n = characterIterator.getIndex();
        int n2 = 0;
        this.map[0] = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < this.map.length; ++i) {
            char c = characterIterator.setIndex(i + this.origBeginIndex - 1);
            String string2 = normalizer2.getDecomposition((int)c);
            if (string2 == null) {
                stringBuilder.append(c);
            } else {
                stringBuilder.append(string2);
                n2 += string2.length();
            }
            this.map[i] = ++n2;
        }
        this.decompItr = new StringBufferCharacterIterator(stringBuilder);
        characterIterator.setIndex(n);
        this.decompItr.setIndex(this.map[n - this.origBeginIndex]);
    }

    public DecomposingCharacterIterator(CharacterIterator characterIterator, Form form) {
        this(characterIterator, null, form.getInternalName());
    }

    public int getDecomposedPosition(int n) {
        int n2 = n - this.origBeginIndex;
        if (n2 < 0 || n2 >= this.map.length) {
            throw new IllegalArgumentException(Messages.getString("invalid.position"));
        }
        return this.map[n2];
    }

    public int calculateOriginalPosition(int n) {
        if (n > this.map[this.map.length - 1]) {
            throw new IllegalArgumentException(Messages.getString("invalid.position"));
        }
        while (n >= 0) {
            int n2 = Arrays.binarySearch(this.map, n);
            if (n2 >= 0) {
                return n2 + this.origBeginIndex;
            }
            --n;
        }
        throw new IllegalArgumentException(Messages.getString("invalid.position"));
    }

    @Override
    public char first() {
        return this.decompItr.first();
    }

    @Override
    public char last() {
        return this.decompItr.last();
    }

    @Override
    public char current() {
        return this.decompItr.current();
    }

    @Override
    public char next() {
        return this.decompItr.next();
    }

    @Override
    public char previous() {
        return this.decompItr.previous();
    }

    @Override
    public char setIndex(int n) {
        return this.decompItr.setIndex(n);
    }

    @Override
    public int getBeginIndex() {
        return this.decompItr.getBeginIndex();
    }

    @Override
    public int getEndIndex() {
        return this.decompItr.getEndIndex();
    }

    @Override
    public int getIndex() {
        return this.decompItr.getIndex();
    }

    @Override
    public Object clone() {
        try {
            DecomposingCharacterIterator decomposingCharacterIterator = (DecomposingCharacterIterator)super.clone();
            decomposingCharacterIterator.decompItr = (CharacterIterator)this.decompItr.clone();
            return decomposingCharacterIterator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static enum Form {
        NFD("nfc"),
        NFKD("nfkc");

        private final String internalName;

        private Form(String string2) {
            this.internalName = string2;
        }

        String getInternalName() {
            return this.internalName;
        }
    }
}

