/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.util.DateUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FileUtils {
    public static final String LINE_SEPARATOR = "\r\n";
    private static final byte[] ZIP_SIGNATURE = new byte[]{80, 75, 3, 4};
    private static final String EMPTY_STRING = "";
    private static final File[] EMPTY_FILE_ARRAY = new File[0];
    public static final String SUFFIX_XML = ".xml";
    public static final String SUFFIX_XMI = ".xmi";
    public static final String SUFFIX_XCAS = ".xcas";
    public static final String SUFFIX_JSON = ".json";
    public static final String SUFFIX_TXT = ".txt";
    public static final String SUFFIX_GZ = ".gz";
    public static final String SUFFIX_DIC = ".dic";
    public static final String SUFFIX_TMP = ".tmp";
    public static final String SUFFIX_RAW = ".raw";
    public static final String SUFFIX_BAK = ".bak";
    public static final String SUFFIX_DIFF = ".diff";
    public static final String SUFFIX_CSV = ".csv";
    public static final String SUFFIX_TSV = ".tsv";
    public static final String SUFFIX_IN = ".in";
    public static final String SUFFIX_OUT = ".out";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public static void assertExists(File file) throws FileNotFoundException {
        if (file == null) {
            throw new FileNotFoundException("Not found file");
        }
        if (!file.exists()) {
            String string;
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = file.getAbsolutePath();
            }
            throw new FileNotFoundException("Not found file: " + string);
        }
    }

    public static File[] listDirs(File file) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return EMPTY_FILE_ARRAY;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isDirectory()) {
                    return false;
                }
                String string = file.getName();
                if (string.startsWith(".svn") || file.getName().equals("CVS")) {
                    return false;
                }
                return file.list().length != 0;
            }
        });
        if (fileArray == null) {
            return EMPTY_FILE_ARRAY;
        }
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return file.getName().compareTo(file2.getName());
            }
        });
        return fileArray;
    }

    public static File[] listFiles(File file, final String string) {
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile()) {
                    String string2 = file.getName();
                    return string2.endsWith(string);
                }
                return false;
            }
        });
        if (fileArray == null || fileArray.length == 0) {
            return EMPTY_FILE_ARRAY;
        }
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return file.getName().compareTo(file2.getName());
            }
        });
        return fileArray;
    }

    public static File getFile(File file, String string) throws IOException {
        if (file == null || string == null || string.length() == 0) {
            return null;
        }
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            URI uRI = file.toURI().resolve(string);
            file2 = new File(uRI);
        }
        return file2.getCanonicalFile();
    }

    public static File[] getFiles(File file, String[] stringArray) throws IOException {
        if (stringArray == null || stringArray.length == 0) {
            return EMPTY_FILE_ARRAY;
        }
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        for (String string : stringArray) {
            File file2 = FileUtils.getFile(file, string);
            if (file2 == null) continue;
            arrayList.add(file2);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<String> getLines(File file, Charset charset) throws IOException {
        if (file == null || !file.exists()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        if (arrayList.isEmpty()) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    public static boolean backup(File file) {
        long l = file.lastModified();
        String string = file.getParent();
        String string2 = DateUtils.createPluginDateFormat().format(l);
        String string3 = file.getName() + "." + string2 + SUFFIX_BAK;
        File file2 = new File(string, string3);
        return file.renameTo(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZip(URL uRL) {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            byte[] byArray = new byte[4];
            inputStream.read(byArray, 0, byArray.length);
            boolean bl = Arrays.equals(byArray, ZIP_SIGNATURE);
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static String toString(File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return EMPTY_STRING;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (file == null) continue;
            stringBuilder.append(file.getPath());
            if (i == fileArray.length - 1) continue;
            stringBuilder.append(File.pathSeparator);
        }
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }
}

