/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.util.BoundedCharacterIterator;
import com.ibm.icu.impl.CharacterIteratorWrapper;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public class FilteringCharacterIterator
implements CharacterIterator {
    protected CharacterIterator iterator;
    protected char[] charsToFilter = EMPTY;
    private static final char[] EMPTY = new char[0];

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public FilteringCharacterIterator(String string) {
        this.iterator = new StringCharacterIterator(string);
        this.trimFirstAndEnd();
    }

    public FilteringCharacterIterator(String string, int n) {
        this.iterator = new StringCharacterIterator(string, n);
        this.trimFirstAndEnd();
    }

    public FilteringCharacterIterator(String string, int n, int n2, int n3) {
        this.iterator = new StringCharacterIterator(string, n, n2, n3);
        this.trimFirstAndEnd();
    }

    FilteringCharacterIterator(CharacterIterator characterIterator) {
        this.iterator = characterIterator instanceof StringCharacterIterator || characterIterator instanceof BoundedCharacterIterator ? characterIterator : new StringCharacterIterator(new CharacterIteratorWrapper(characterIterator).getText());
        this.trimFirstAndEnd();
    }

    @Override
    public char current() {
        int n;
        char c = this.iterator.current();
        for (n = 0; n < this.charsToFilter.length && c != this.charsToFilter[n]; ++n) {
        }
        if (n == this.charsToFilter.length) {
            return c;
        }
        c = this.next();
        if (this.iterator.getIndex() >= this.iterator.getEndIndex() || c == ' ') {
            c = this.previous();
        }
        return c;
    }

    @Override
    public char first() {
        int n;
        char c = this.iterator.first();
        for (n = 0; n < this.charsToFilter.length && c != this.charsToFilter[n]; ++n) {
        }
        if (n == this.charsToFilter.length) {
            return c;
        }
        c = this.next();
        return c;
    }

    @Override
    public char last() {
        int n;
        char c = this.iterator.last();
        for (n = 0; n < this.charsToFilter.length && c != this.charsToFilter[n]; ++n) {
        }
        if (n == this.charsToFilter.length) {
            return c;
        }
        c = this.previous();
        return c;
    }

    @Override
    public char next() {
        char c;
        int n;
        do {
            c = this.iterator.next();
            for (n = 0; n < this.charsToFilter.length && c != this.charsToFilter[n]; ++n) {
            }
        } while (n != this.charsToFilter.length);
        return c;
    }

    @Override
    public char previous() {
        char c;
        int n;
        do {
            c = this.iterator.previous();
            for (n = 0; n < this.charsToFilter.length && c != this.charsToFilter[n]; ++n) {
            }
        } while (n != this.charsToFilter.length);
        return c;
    }

    @Override
    public int getBeginIndex() {
        return this.iterator.getBeginIndex();
    }

    @Override
    public int getEndIndex() {
        return this.iterator.getEndIndex();
    }

    @Override
    public int getIndex() {
        return this.iterator.getIndex();
    }

    @Override
    public char setIndex(int n) {
        return this.iterator.setIndex(n);
    }

    public void setCharsToFilter(char[] cArray) {
        this.charsToFilter = cArray;
    }

    @Override
    public Object clone() {
        try {
            FilteringCharacterIterator filteringCharacterIterator = (FilteringCharacterIterator)super.clone();
            filteringCharacterIterator.iterator = (StringCharacterIterator)this.iterator.clone();
            filteringCharacterIterator.charsToFilter = (char[])this.charsToFilter.clone();
            return filteringCharacterIterator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void trimFirstAndEnd() {
        int n = this.iterator.getIndex();
        this.iterator.first();
        this.iterator.last();
        this.iterator.setIndex(n);
    }
}

