/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.Messages;
import com.ibm.dltj.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class GlossUtils {
    private static final String[] TYPE_NAME = new String[255];
    private static final Map<String, Integer> NAME_TYPE;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public static int compareGlossCollections(GlossCollection glossCollection, GlossCollection glossCollection2) {
        if (glossCollection.size() == 1 && glossCollection2.size() == 1) {
            return glossCollection.toString().compareTo(glossCollection2.toString());
        }
        ArrayList<Gloss> arrayList = new ArrayList<Gloss>(glossCollection);
        ArrayList<Gloss> arrayList2 = new ArrayList<Gloss>(glossCollection2);
        StringRepresentationComparator stringRepresentationComparator = new StringRepresentationComparator();
        Collections.sort(arrayList, stringRepresentationComparator);
        Collections.sort(arrayList2, stringRepresentationComparator);
        return Utils.compareCollections(arrayList, arrayList2, stringRepresentationComparator);
    }

    public static GlossCollection toGlossCollection(Object object) {
        if (object instanceof GlossCollection) {
            return (GlossCollection)object;
        }
        if (object instanceof Gloss) {
            return new GlossCollection((Gloss)object);
        }
        return null;
    }

    public static final boolean isUserGloss(int n) {
        return n >= 128;
    }

    public static final String parseStr(int n, boolean bl) throws DLTException {
        if (n >= 255 || n < 0) {
            throw new DLTException(Messages.getString("error.gloss.range"));
        }
        String string = TYPE_NAME[n];
        if (string == null && !bl) {
            string = Integer.toString(n);
        }
        return string;
    }

    public static final String parseStr(int n) throws DLTException {
        return GlossUtils.parseStr(n, false);
    }

    public static final int parseInt(String string) throws NumberFormatException, DLTException {
        Integer n = NAME_TYPE.get(string);
        if (n != null) {
            return n;
        }
        int n2 = Integer.parseInt(string);
        if (n2 >= 255 || n2 < 0) {
            throw new DLTException(Messages.getString("error.gloss.range"));
        }
        return n2;
    }

    static {
        GlossUtils.TYPE_NAME[0] = "void";
        GlossUtils.TYPE_NAME[1] = "mset";
        GlossUtils.TYPE_NAME[2] = "poscol";
        GlossUtils.TYPE_NAME[4] = "jkomcol";
        GlossUtils.TYPE_NAME[11] = "lemma";
        GlossUtils.TYPE_NAME[12] = "lemcp";
        GlossUtils.TYPE_NAME[13] = "gramm";
        GlossUtils.TYPE_NAME[14] = "pcode";
        GlossUtils.TYPE_NAME[15] = "fset";
        GlossUtils.TYPE_NAME[16] = "lang";
        GlossUtils.TYPE_NAME[17] = "tcr";
        GlossUtils.TYPE_NAME[18] = "int";
        GlossUtils.TYPE_NAME[85] = "tokentype";
        GlossUtils.TYPE_NAME[19] = "cat";
        GlossUtils.TYPE_NAME[20] = "stem";
        GlossUtils.TYPE_NAME[21] = "stemcp";
        GlossUtils.TYPE_NAME[22] = "syn";
        GlossUtils.TYPE_NAME[23] = "phs";
        GlossUtils.TYPE_NAME[24] = "sgst";
        GlossUtils.TYPE_NAME[26] = "morphrule";
        GlossUtils.TYPE_NAME[27] = "constcode";
        GlossUtils.TYPE_NAME[28] = "case";
        GlossUtils.TYPE_NAME[30] = "KOmph";
        GlossUtils.TYPE_NAME[31] = "JMAgr";
        GlossUtils.TYPE_NAME[32] = "JAmph";
        GlossUtils.TYPE_NAME[33] = "JAgrm";
        GlossUtils.TYPE_NAME[34] = "Grs";
        GlossUtils.TYPE_NAME[35] = "transform";
        GlossUtils.TYPE_NAME[36] = "transclass";
        GlossUtils.TYPE_NAME[37] = "transrule";
        GlossUtils.TYPE_NAME[40] = "ZHmph";
        GlossUtils.TYPE_NAME[41] = "ZHlemma";
        GlossUtils.TYPE_NAME[50] = "CRFLabelSet";
        GlossUtils.TYPE_NAME[51] = "CRFStateFeature";
        GlossUtils.TYPE_NAME[52] = "CRFTransitionFeature";
        GlossUtils.TYPE_NAME[53] = "CRFLearningRate";
        GlossUtils.TYPE_NAME[55] = "MWElement";
        GlossUtils.TYPE_NAME[56] = "MWUnit";
        GlossUtils.TYPE_NAME[58] = "MWEntry";
        GlossUtils.TYPE_NAME[57] = "MWValidation";
        GlossUtils.TYPE_NAME[59] = "MW";
        GlossUtils.TYPE_NAME[60] = "string";
        GlossUtils.TYPE_NAME[66] = "Tstring";
        GlossUtils.TYPE_NAME[67] = "Tint";
        GlossUtils.TYPE_NAME[68] = "Tdouble";
        GlossUtils.TYPE_NAME[69] = "Tvector";
        GlossUtils.TYPE_NAME[70] = "Tarray";
        GlossUtils.TYPE_NAME[71] = "ArabicTC";
        GlossUtils.TYPE_NAME[72] = "LemmaTC";
        GlossUtils.TYPE_NAME[80] = "ZHfreq";
        GlossUtils.TYPE_NAME[81] = "ZHcpos";
        GlossUtils.TYPE_NAME[82] = "ZHdecomp";
        GlossUtils.TYPE_NAME[83] = "hyphen";
        GlossUtils.TYPE_NAME[84] = "AlgorithmicHyphenationRule";
        GlossUtils.TYPE_NAME[86] = "StringArray";
        GlossUtils.TYPE_NAME[88] = "FeatureStructure";
        GlossUtils.TYPE_NAME[89] = "IntFeature";
        GlossUtils.TYPE_NAME[90] = "StringFeature";
        GlossUtils.TYPE_NAME[91] = "RegexTransformation";
        GlossUtils.TYPE_NAME[92] = "RegexPattern";
        GlossUtils.TYPE_NAME[93] = "StringArrayFeature";
        NAME_TYPE = new TreeMap<String, Integer>();
        for (int i = 0; i < TYPE_NAME.length; ++i) {
            if (TYPE_NAME[i] == null) continue;
            NAME_TYPE.put(TYPE_NAME[i], i);
        }
    }

    public static class GlossCollectionComparator
    implements Comparator<GlossCollection> {
        @Override
        public int compare(GlossCollection glossCollection, GlossCollection glossCollection2) {
            return GlossUtils.compareGlossCollections(glossCollection, glossCollection2);
        }
    }

    public static class StringRepresentationComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }
    }
}

