/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.BasicCutPasteGloss;
import com.ibm.dltj.gloss.LemmaGloss;
import com.ibm.dltj.gloss.MidGloss;
import java.text.StringCharacterIterator;

public class GuesserUtil {
    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public static GlossCollection adaptLemmaForGuess(String string, GlossCollection glossCollection) {
        GlossCollection glossCollection2 = null;
        if (glossCollection != null) {
            glossCollection2 = new GlossCollection();
            glossCollection2.setOwnerDictionary(glossCollection.getOwnerDictionary());
            for (Gloss gloss : glossCollection) {
                if (gloss instanceof MidGloss) {
                    Gloss[] glossArray = ((MidGloss)gloss).element;
                    Gloss[] glossArray2 = new Gloss[glossArray.length];
                    System.arraycopy(glossArray, 0, glossArray2, 0, glossArray.length);
                    for (int i = glossArray.length - 1; i >= 0; --i) {
                        if (!(glossArray[i] instanceof BasicCutPasteGloss)) continue;
                        try {
                            LemmaGloss lemmaGloss = new LemmaGloss(((BasicCutPasteGloss)glossArray[i]).getLemma(new StringCharacterIterator(string), 0, string.length()));
                            glossArray2[i] = lemmaGloss;
                            continue;
                        }
                        catch (DLTException dLTException) {
                            throw new Error(Messages.getString("error.internal"));
                        }
                    }
                    try {
                        gloss = new MidGloss(glossArray2);
                    }
                    catch (DLTException dLTException) {
                        throw new Error(Messages.getString("error.internal"));
                    }
                }
                glossCollection2.add(gloss);
            }
        }
        return glossCollection2;
    }
}

