/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.util.Utils;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public class IntArray
implements Cloneable {
    static final int MULTIPLIER = 2;
    static final int DIVISOR = 1;
    private int[] data;
    private int size;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public IntArray(int n) {
        this.data = new int[n];
        this.size = 0;
    }

    public IntArray() {
        this(16);
    }

    public IntArray(int[] nArray, int n) {
        this.data = nArray;
        this.size = n;
    }

    private void growToFit(int n) {
        if (n >= this.data.length) {
            int n2 = Math.max(n + 1, this.data.length * 2 / 1);
            int[] nArray = new int[n2];
            System.arraycopy(this.data, 0, nArray, 0, this.data.length);
            this.data = nArray;
        }
    }

    public final void add(int n) {
        this.growToFit(this.size);
        this.data[this.size++] = n;
    }

    private void insertSection(int n, int n2) {
        assert (n <= this.size);
        if (this.size + n2 <= this.data.length) {
            System.arraycopy(this.data, n, this.data, n + n2, this.size - n);
        } else {
            int[] nArray = new int[this.data.length * 2 / 1];
            System.arraycopy(this.data, 0, nArray, 0, n);
            System.arraycopy(this.data, n, nArray, n + n2, this.size - n);
            this.data = nArray;
        }
        this.size += n2;
    }

    public final void add(int n, int n2) {
        this.insertSection(n, 1);
        this.data[n] = n2;
    }

    public final boolean addAll(Collection<? extends Integer> collection) {
        int n = this.size;
        this.growToFit(n + collection.size() - 1);
        for (Integer n2 : collection) {
            this.data[n++] = n2;
        }
        this.size = n;
        return true;
    }

    public final boolean addAll(int n, Collection<? extends Integer> collection) {
        this.insertSection(n, collection.size());
        for (Integer n2 : collection) {
            this.data[n++] = n2;
        }
        return true;
    }

    public final void addAll(int[] nArray) {
        int n = this.size;
        int n2 = nArray.length;
        this.growToFit(n + n2);
        System.arraycopy(nArray, 0, this.data, n, n2);
        this.size += n2;
    }

    public final void addAll(IntArray intArray) {
        int n = this.size;
        int n2 = intArray.size;
        this.growToFit(n + n2);
        System.arraycopy(intArray.data, 0, this.data, n, n2);
        this.size += n2;
    }

    public final void addAll(int n, IntArray intArray) {
        int n2 = intArray.size;
        this.insertSection(n, n2);
        System.arraycopy(intArray.data, 0, this.data, n, n2);
    }

    public final void addMultiple(int n, int n2) {
        int n3 = this.size + n;
        this.growToFit(n3);
        Arrays.fill(this.data, this.size, n3, n2);
        this.size = n3;
    }

    public final void clear() {
        this.size = 0;
    }

    public IntArray clone() {
        return new IntArray(this.toArray(), this.size);
    }

    public final boolean contains(int n) {
        return this.indexOf(n) > -1;
    }

    public final void ensureCapacity(int n) {
        this.growToFit(n - 1);
    }

    public final int get(int n) {
        assert (n < this.size);
        return this.data[n];
    }

    public final int indexOf(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != n) continue;
            return i;
        }
        return -1;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int lastIndexOf(int n) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.data[i] != n) continue;
            return i;
        }
        return -1;
    }

    public final int remove(int n) {
        assert (n < this.size);
        int n2 = this.data[n];
        System.arraycopy(this.data, n + 1, this.data, n, this.size - n - 1);
        --this.size;
        return n2;
    }

    public final void removeRange(int n, int n2) {
        assert (n <= this.size);
        assert (n2 <= this.size);
        assert (n2 >= n);
        System.arraycopy(this.data, n2, this.data, n, this.size - n2);
        this.size -= n2 - n;
    }

    public final int set(int n, int n2) {
        assert (n < this.size);
        int n3 = this.data[n];
        this.data[n] = n2;
        return n3;
    }

    public final void setRange(int n, int n2, int n3) {
        assert (n <= this.size);
        assert (n2 <= this.size);
        assert (n2 >= n);
        Arrays.fill(this.data, n, n2, n3);
    }

    public final int size() {
        return this.size;
    }

    public final int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.data, 0, nArray, 0, this.size);
        return nArray;
    }

    public final int[] toArray(int[] nArray) {
        if (nArray.length < this.size) {
            nArray = new int[this.size];
        }
        System.arraycopy(this.data, 0, nArray, 0, this.size);
        return nArray;
    }

    public final int[] getData() {
        return this.data;
    }

    public final void trimToSize() {
        if (this.data.length > this.size) {
            this.data = this.toArray();
        }
    }

    public final int hashCode() {
        if (this == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = 31 * n + this.data[i];
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IntArray intArray = (IntArray)object;
        if (this.size != intArray.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == intArray.data[i]) continue;
            return false;
        }
        return true;
    }

    public final void push(int n) {
        this.growToFit(this.size);
        this.data[this.size++] = n;
    }

    public final int pop() {
        return this.data[--this.size];
    }

    public final int peek() {
        return this.data[this.size - 1];
    }

    public final void removeDuplicates() {
        this.size = Utils.removeDuplicates(this.data, 0, this.size);
    }

    public final Iter iterator() {
        return new Iter();
    }

    public final Iter listIterator() {
        return new Iter();
    }

    List<Integer> asList() {
        return new ListView();
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public boolean removeAll(IntArray intArray) {
        int n = this.size;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (intArray.contains(this.data[i])) continue;
            this.data[n2++] = this.data[i];
        }
        this.size = n2;
        return n2 < n;
    }

    public boolean retainAll(IntArray intArray) {
        int n = this.size;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!intArray.contains(this.data[i])) continue;
            this.data[n2++] = this.data[i];
        }
        this.size = n2;
        return n2 < n;
    }

    class ListView
    extends AbstractList<Integer>
    implements RandomAccess {
        ListView() {
        }

        @Override
        public Integer get(int n) {
            return IntArray.this.get(n);
        }

        @Override
        public int size() {
            return IntArray.this.size();
        }

        @Override
        public void add(int n, Integer n2) {
            IntArray.this.add(n, n2);
        }

        @Override
        public Integer remove(int n) {
            return IntArray.this.remove(n);
        }

        @Override
        public Integer set(int n, Integer n2) {
            return IntArray.this.set(n, n2);
        }
    }

    final class Iter
    implements ListIterator<Integer> {
        int pos = 0;

        Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < IntArray.this.size();
        }

        @Override
        public Integer next() {
            return IntArray.this.get(this.pos++);
        }

        @Override
        public void remove() {
            IntArray.this.remove(this.pos);
        }

        @Override
        public void add(Integer n) {
            IntArray.this.add(this.pos++, n);
        }

        @Override
        public boolean hasPrevious() {
            return this.pos > 0;
        }

        @Override
        public int nextIndex() {
            return this.pos;
        }

        @Override
        public Integer previous() {
            return IntArray.this.get(--this.pos);
        }

        @Override
        public int previousIndex() {
            return this.pos - 1;
        }

        @Override
        public void set(Integer n) {
            IntArray.this.set(this.pos, n);
        }
    }
}

