/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import java.util.Arrays;

public final class IntPow2HashMap {
    private int[] data;
    private int count;
    private int mask;
    static final int FILL_MULTIPLIER = 11;
    static final int FILL_RSHIFT = 2;
    public static final int VALUE_NOT_PRESENT = 0;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public IntPow2HashMap() {
        this(4);
    }

    public IntPow2HashMap(int n) {
        this.mask = (1 << n + 1) - 2;
        this.data = new int[this.mask + 2];
        this.count = 0;
    }

    public void clear() {
        this.count = 0;
        Arrays.fill(this.data, 0);
    }

    public int get(int n) {
        assert (n != 0);
        int[] nArray = this.data;
        int n2 = this.mask;
        int n3 = n << 1 & n2;
        while (nArray[n3] != n) {
            if (nArray[n3] == 0) {
                return 0;
            }
            n3 = n3 + 2 & n2;
        }
        return nArray[n3 + 1];
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    private void grow() {
        int n = this.mask * 2 + 2;
        int n2 = this.mask;
        int[] nArray = new int[n + 2];
        int[] nArray2 = this.data;
        this.count = 0;
        for (int i = 0; i <= n2; i += 2) {
            if (nArray2[i] == 0) continue;
            this.putValue(nArray, n, nArray2[i], nArray2[i + 1]);
        }
        this.mask = n;
        this.data = nArray;
    }

    public int put(int n, int n2) {
        assert (n2 != 0);
        assert (n != 0);
        if (this.count * 11 >> 2 > this.mask) {
            this.grow();
        }
        return this.putValue(this.data, this.mask, n, n2);
    }

    private int putValue(int[] nArray, int n, int n2, int n3) {
        int n4 = n2 << 1 & n;
        while (nArray[n4] != 0) {
            if (nArray[n4] == n2) {
                int n5 = nArray[n4 + 1];
                nArray[n4 + 1] = n3;
                return n5;
            }
            n4 = n4 + 2 & n;
        }
        ++this.count;
        nArray[n4] = n2;
        nArray[n4 + 1] = n3;
        return 0;
    }

    public int remove(int n) {
        int[] nArray = this.data;
        int n2 = this.mask;
        int n3 = n << 1 & n2;
        while (nArray[n3] != n) {
            if (nArray[n3] == 0) {
                return 0;
            }
            n3 = n3 + 2 & n2;
        }
        --this.count;
        nArray[n3] = 0;
        return nArray[n3 + 1];
    }

    public int size() {
        return this.count;
    }
}

