/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.MWElementGloss;
import com.ibm.dltj.gloss.MWUGloss;
import com.ibm.dltj.gloss.MidGloss;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class MWUDump {
    final Dictionary dict;
    final BufferedWriter writer;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public MWUDump(Dictionary dictionary, BufferedWriter bufferedWriter) {
        this.writer = bufferedWriter;
        this.dict = dictionary;
    }

    static void usage() {
        System.err.println("Dump MWU dictionary into a file.");
        System.err.println("Parameters: MWUDictionary dump_file");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            MWUDump.usage();
            System.exit(1);
        }
        try {
            MWUDump mWUDump = new MWUDump(new Dictionary(new File(stringArray[0])), new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(stringArray[1])), "UTF-16LE")));
            int n = mWUDump.dump();
            System.out.println(n + " multiword entries dumped into " + stringArray[0]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int dump() throws DLTException, IOException {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, Object>> iterator = this.dict.iterator();
        HashMap<MWElementGloss, Object> hashMap = new HashMap<MWElementGloss, Object>(393241);
        HashSet<Gloss> hashSet = new HashSet<Gloss>(393241);
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = object2.getKey();
            GlossCollection glossCollection = (GlossCollection)object2.getValue();
            for (Gloss gloss : glossCollection) {
                if (!(gloss instanceof MWElementGloss)) continue;
                MWElementGloss mWElementGloss = (MWElementGloss)gloss;
                hashMap.put(mWElementGloss, object);
                for (int i = 0; i < mWElementGloss.element.length; ++i) {
                    hashSet.add(mWElementGloss.element[i]);
                }
            }
        }
        object2 = new StringCharacterIterator("");
        object = hashSet.iterator();
        int n = 0;
        while (object.hasNext()) {
            MidGloss midGloss;
            Object object3;
            Gloss gloss;
            Gloss gloss2 = (Gloss)object.next();
            gloss = (MWUGloss)gloss2;
            for (int i = 0; i < ((MWUGloss)gloss).element.length; ++i) {
                object3 = (String)hashMap.get(((MWUGloss)gloss).element[i]);
                this.writer.write((String)object3);
                if (0 != (((MWElementGloss)((MWUGloss)gloss).element[i]).getFlags() & Integer.MIN_VALUE)) {
                    this.writer.write("(!)");
                }
                this.writer.write(" ");
            }
            this.writer.write("= ");
            if (((MWUGloss)gloss).getDefinitionGloss() instanceof LemmaGenerator) {
                LemmaGenerator lemmaGenerator = (LemmaGenerator)((Object)((MWUGloss)gloss).getDefinitionGloss());
                object3 = lemmaGenerator.getLemma((CharacterIterator)object2, 0, 0);
                this.writer.write((String)object3);
            } else if (((MWUGloss)gloss).getDefinitionGloss() instanceof MidGloss && (object3 = (midGloss = (MidGloss)((MWUGloss)gloss).getDefinitionGloss()).getLemmaGloss()) != null) {
                String string = object3.getLemma((CharacterIterator)object2, 0, 0);
                this.writer.write(string);
            }
            this.writer.write("\r\n");
            ++n;
        }
        this.writer.close();
        return n;
    }
}

