/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.util.ArrayUtils;
import com.ibm.dltj.util.ExpUtils;

public class MathUtils {
    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public static double logsumexp(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        int n = ArrayUtils.maxAt(dArray);
        ExpUtils expUtils = new ExpUtils();
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (i == n || dArray[i] == dArray[n]) {
                d += 1.0;
                continue;
            }
            d += expUtils.exp(dArray[i] - dArray[n]);
        }
        return dArray[n] + Math.log(d);
    }

    public static double logsumexp(double[] dArray, double d) {
        double d2 = MathUtils.logsumexp(dArray);
        if (Math.abs(d2) < d) {
            return 0.0;
        }
        return d2;
    }
}

