/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.util.ListBase;

public interface PooledItemAllocator<T> {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";

    public T getCurItem();

    public void commitItem();

    public void popItem(T var1);

    public void reset();

    public static final class Singleton<T extends ListBase<T>>
    implements PooledItemAllocator<T> {
        final T item;

        public Singleton(T t) {
            this.item = t;
        }

        @Override
        public void commitItem() {
        }

        @Override
        public void popItem(T t) {
            assert (t == this.item);
        }

        @Override
        public T getCurItem() {
            return this.item;
        }

        @Override
        public void reset() {
            ((ListBase)this.item).reset();
        }
    }
}

