/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.util.ListBase;
import com.ibm.dltj.util.PooledItemAllocator;
import java.util.Comparator;
import java.util.Iterator;

public abstract class PooledListHandler<T extends ListBase<T>, Q extends PooledListHandler<T, Q>>
extends ListBase<Q>
implements Iterable<T>,
PooledItemAllocator<T> {
    private static final int RESET_CARRYOVER_LIMIT = 30;
    T list_first;
    T list_last;
    int committed_size;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public String toString() {
        String string = "";
        int n = 91;
        for (ListBase listBase : this) {
            string = string + (char)n;
            string = string + listBase.toString();
            n = 44;
        }
        if (n == 91) {
            string = string + (char)n;
        }
        return string + ']';
    }

    protected PooledListHandler(T t) {
        this.list_last = t;
        this.list_first = this.list_last;
        this.committed_size = 0;
    }

    public final int size() {
        return this.committed_size;
    }

    public final boolean isEmpty() {
        return this.list_last == this.list_first;
    }

    public final T getFirst() {
        return this.list_first;
    }

    public final T get(int n) {
        T t = this.list_first;
        while (n-- > 0) {
            t = ((ListBase)t).next;
        }
        return t;
    }

    @Override
    public final T getCurItem() {
        return this.list_last;
    }

    @Override
    public final void commitItem() {
        if (((ListBase)this.list_last).next == null) {
            ((ListBase)this.list_last).next = ((ListBase)this.list_last).createNew();
        }
        this.list_last = ((ListBase)this.list_last).next;
        ++this.committed_size;
    }

    @Override
    public final void popItem(T t) {
        --this.committed_size;
        this.list_last = t;
        assert (this.committed_size >= 0);
        assert (t == this.get(this.committed_size));
    }

    public final void clear() {
        this.list_last = this.list_first;
        this.committed_size = 0;
    }

    public final void dispose() {
        ((ListBase)this.list_first).next = null;
        if (this.list_first instanceof PooledListHandler) {
            ((PooledListHandler)this.list_first).dispose();
        }
        this.reset();
    }

    @Override
    public void reset() {
        this.clear();
        int n = 0;
        T t = this.list_first;
        while (t != null) {
            ((ListBase)t).reset();
            if (++n == 30) {
                ((ListBase)t).next = null;
                return;
            }
            t = ((ListBase)t).next;
        }
    }

    public final void moveToStart(int n) {
        if (n <= 0) {
            return;
        }
        T t = this.list_first;
        while (--n > 0) {
            t = ((ListBase)t).next;
            assert (t != this.list_last);
        }
        Object t2 = ((ListBase)t).next;
        ((ListBase)t).next = ((ListBase)t2).next;
        ((ListBase)t2).next = this.list_first;
        this.list_first = t2;
    }

    public final int removeDuplicates(Comparator<T> comparator) {
        int n = 0;
        T t = this.list_first;
        while (t != this.list_last) {
            T t2 = t;
            while (((ListBase)t2).next != this.list_last) {
                Object t3 = ((ListBase)t2).next;
                if (comparator.compare(t, t3) == 0) {
                    ((ListBase)t2).next = ((ListBase)t3).next;
                    ((ListBase)t3).next = ((ListBase)this.list_last).next;
                    ((ListBase)this.list_last).next = t3;
                    ++n;
                    continue;
                }
                t2 = t3;
            }
            t = ((ListBase)t).next;
        }
        this.committed_size -= n;
        return n;
    }

    @Override
    public final Iterator<T> iterator() {
        return new Iterator<T>(){
            T ptr;
            {
                this.ptr = PooledListHandler.this.list_first;
            }

            @Override
            public boolean hasNext() {
                return this.ptr != PooledListHandler.this.list_last;
            }

            @Override
            public T next() {
                Object t = this.ptr;
                this.ptr = ((ListBase)this.ptr).next;
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

