/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.PayloadManipulator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;

public class SetIndex
implements PayloadManipulator {
    ArrayList<BitSet> sets = new ArrayList();
    HashMap<BitSet, Integer> map = new HashMap();
    public static int EMPTYSET = -1;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public SetIndex() {
        BitSet bitSet = new BitSet();
        this.sets.add(bitSet);
        this.map.put(bitSet, 0);
    }

    public void clear() {
        BitSet bitSet = this.sets.get(0);
        this.sets.clear();
        this.map.clear();
        this.sets.add(bitSet);
        this.map.put(bitSet, 0);
    }

    private final int addNewSet(BitSet bitSet) {
        assert (this.map.get(bitSet) == null);
        this.sets.add(bitSet);
        Integer n = this.sets.size() - 1;
        this.map.put(bitSet, n);
        return n + EMPTYSET;
    }

    private final int findOrAdd(BitSet bitSet) {
        Integer n = this.map.get(bitSet);
        if (n == null) {
            this.sets.add(bitSet);
            n = this.sets.size() - 1;
            this.map.put(bitSet, n);
        }
        return n + EMPTYSET;
    }

    public int add(int n, int n2) {
        BitSet bitSet = (BitSet)this.sets.get(n - EMPTYSET).clone();
        bitSet.set(n2);
        return this.findOrAdd(bitSet);
    }

    public int remove(int n, int n2) {
        BitSet bitSet = (BitSet)this.sets.get(n - EMPTYSET).clone();
        bitSet.clear(n2);
        return this.findOrAdd(bitSet);
    }

    public boolean contains(int n, int n2) {
        BitSet bitSet = this.sets.get(n - EMPTYSET);
        return bitSet.get(n2);
    }

    public BitSet getSet(int n) {
        return this.sets.get(n - EMPTYSET);
    }

    @Override
    public int mergeInternal(int n, int n2) {
        BitSet bitSet = (BitSet)this.sets.get(n - EMPTYSET).clone();
        BitSet bitSet2 = this.sets.get(n2 - EMPTYSET);
        bitSet.or(bitSet2);
        return this.findOrAdd(bitSet);
    }

    public int merge(int n, BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.sets.get(n - EMPTYSET).clone();
        bitSet2.or(bitSet);
        return this.findOrAdd(bitSet2);
    }

    @Override
    public int intersectInternal(int n, int n2) {
        BitSet bitSet = (BitSet)this.sets.get(n - EMPTYSET).clone();
        BitSet bitSet2 = this.sets.get(n2 - EMPTYSET);
        bitSet.and(bitSet2);
        return this.findOrAdd(bitSet);
    }

    public int intersect(int n, BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.sets.get(n - EMPTYSET).clone();
        bitSet2.and(bitSet);
        return this.findOrAdd(bitSet2);
    }

    public int subtract(int n, BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.sets.get(n - EMPTYSET).clone();
        bitSet2.andNot(bitSet);
        return this.findOrAdd(bitSet2);
    }

    @Override
    public int subtractInternal(int n, int n2) {
        BitSet bitSet = (BitSet)this.sets.get(n - EMPTYSET).clone();
        BitSet bitSet2 = this.sets.get(n2 - EMPTYSET);
        bitSet.andNot(bitSet2);
        return this.findOrAdd(bitSet);
    }

    public long save(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.sets.size());
        int n = 4;
        for (BitSet bitSet : this.sets) {
            dataOutput.writeInt(bitSet.size());
            n += 4;
            for (int i = 0; i < bitSet.size(); i += 32) {
                int n2 = 1;
                int n3 = 0;
                for (int j = 0; j < 32; ++j) {
                    if (bitSet.get(i + j)) {
                        n3 |= n2;
                    }
                    n2 <<= 1;
                }
                dataOutput.writeInt(n3);
                n += 4;
            }
        }
        return n;
    }

    public void load(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        this.sets.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            int n2 = dataInput.readInt();
            BitSet bitSet = new BitSet(n2);
            for (int j = 0; j < n2; j += 32) {
                int n3 = 1;
                int n4 = dataInput.readInt();
                for (int k = 0; k < 32; ++k) {
                    if ((n4 & n3) != 0) {
                        bitSet.set(j + k);
                    }
                    n3 <<= 1;
                }
            }
            this.addNewSet(bitSet);
        }
    }

    @Override
    public void dereference(int n) {
    }

    @Override
    public Object getObject(int n) throws DLTException {
        return this.getSet(n);
    }

    @Override
    public int intersect(int n, Object object) throws DLTException {
        return this.intersect(n, (BitSet)object);
    }

    @Override
    public int merge(int n, Object object) throws DLTException {
        return this.merge(n, (BitSet)object);
    }

    @Override
    public int reference(int n) {
        return n;
    }

    @Override
    public int subtract(int n, Object object) throws DLTException {
        return this.subtract(n, (BitSet)object);
    }
}

