/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.Initializer;
import com.ibm.dltj.netgeneric.PayloadManipulator;
import com.ibm.dltj.util.BoundedIntHeap;
import com.ibm.dltj.util.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;

public class SetIndexManipulable
implements Initializer,
PayloadManipulator {
    final ArrayList<IndexBitSet> sets = new ArrayList();
    final HashMap<BitSet, IndexBitSet> map = new HashMap();
    BoundedIntHeap free_heap = null;
    int free_count = 0;
    static final int FREE_HEAP_SIZE = 100;
    public static int EMPTYSET = -1;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public SetIndexManipulable() {
        this.addNewSet(new BitSet()).addRef();
    }

    @Override
    public void reset() {
        this.sets.clear();
        this.map.clear();
        this.free_heap = null;
        this.free_count = 0;
        this.addNewSet(new BitSet()).addRef();
    }

    void ensureModifyStarted() {
        if (this.free_heap == null) {
            this.free_heap = new BoundedIntHeap(100, 1);
            this.rebuildFreeHeap();
        }
    }

    void rebuildFreeHeap() {
        assert (this.free_heap.isEmpty());
        if (this.free_count == 0) {
            return;
        }
        int n = Math.max(this.free_count, 100);
        for (int i = 0; i < this.sets.size() && n > 0; ++i) {
            if (this.sets.get((int)i).set != null) continue;
            this.free_heap.allocateCell(i);
            --n;
        }
    }

    final IndexBitSet addNewSet(BitSet bitSet) {
        IndexBitSet indexBitSet;
        this.ensureModifyStarted();
        if (this.free_count == 0) {
            indexBitSet = new IndexBitSet();
        } else {
            if (this.free_heap.isEmpty()) {
                this.rebuildFreeHeap();
            }
            indexBitSet = this.sets.get(this.free_heap.getTopKey());
            this.free_heap.removeTop();
            --this.free_count;
        }
        indexBitSet.attach(bitSet);
        return indexBitSet;
    }

    private final int findOrAdd(BitSet bitSet) {
        IndexBitSet indexBitSet = this.map.get(bitSet);
        if (indexBitSet == null) {
            indexBitSet = this.addNewSet(bitSet);
        }
        return indexBitSet.associated_index + EMPTYSET;
    }

    public int add(int n, int n2) {
        BitSet bitSet = (BitSet)this.sets.get((int)(n - SetIndexManipulable.EMPTYSET)).set.clone();
        bitSet.set(n2);
        return this.findOrAdd(bitSet);
    }

    public int remove(int n, int n2) {
        BitSet bitSet = (BitSet)this.sets.get((int)(n - SetIndexManipulable.EMPTYSET)).set.clone();
        bitSet.clear(n2);
        return this.findOrAdd(bitSet);
    }

    public boolean contains(int n, int n2) {
        BitSet bitSet = this.sets.get((int)(n - SetIndexManipulable.EMPTYSET)).set;
        return bitSet.get(n2);
    }

    public BitSet getSet(int n) {
        return this.sets.get((int)(n - SetIndexManipulable.EMPTYSET)).set;
    }

    public long save(DataOutput dataOutput) throws IOException {
        while (this.free_count > 0 && this.sets.get((int)(this.sets.size() - 1)).set == null) {
            this.sets.remove(this.sets.size() - 1);
            --this.free_count;
            this.free_heap = null;
        }
        dataOutput.writeInt(this.sets.size());
        int n = 4;
        dataOutput.writeInt(this.free_count);
        n += 4;
        int n2 = this.sets.size();
        for (int i = 1; i < n2; ++i) {
            IndexBitSet indexBitSet = this.sets.get(i);
            indexBitSet.write(dataOutput);
        }
        return n;
    }

    public void load(DataInput dataInput, int n) throws IOException {
        this.sets.ensureCapacity(n);
        this.free_count = dataInput.readInt();
        for (int i = 1; i < n; ++i) {
            IndexBitSet indexBitSet = new IndexBitSet();
            indexBitSet.read(dataInput);
        }
    }

    @Override
    public void endModify() {
        this.free_heap = null;
    }

    @Override
    public void startModify() throws DLTException {
        this.ensureModifyStarted();
    }

    @Override
    public int reference(int n) {
        this.sets.get(n).addRef();
        return n;
    }

    @Override
    public void dereference(int n) {
        this.sets.get(n).delRef();
    }

    @Override
    public Object getObject(int n) throws DLTException {
        return this.sets.get((int)(n - SetIndexManipulable.EMPTYSET)).set;
    }

    public int merge(int n, BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.sets.get((int)(n - SetIndexManipulable.EMPTYSET)).set.clone();
        bitSet2.or(bitSet);
        return this.findOrAdd(bitSet2);
    }

    @Override
    public int merge(int n, Object object) throws DLTException {
        if (object == null) {
            return n;
        }
        return this.merge(n, (BitSet)object);
    }

    @Override
    public int mergeInternal(int n, int n2) {
        BitSet bitSet = (BitSet)this.sets.get((int)(n - SetIndexManipulable.EMPTYSET)).set.clone();
        BitSet bitSet2 = this.sets.get((int)(n2 - SetIndexManipulable.EMPTYSET)).set;
        bitSet.or(bitSet2);
        return this.findOrAdd(bitSet);
    }

    public int intersect(int n, BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.sets.get((int)(n - SetIndexManipulable.EMPTYSET)).set.clone();
        bitSet2.and(bitSet);
        return this.findOrAdd(bitSet2);
    }

    @Override
    public int intersect(int n, Object object) throws DLTException {
        if (object == null) {
            return -1;
        }
        return this.intersect(n, (BitSet)object);
    }

    @Override
    public int intersectInternal(int n, int n2) {
        BitSet bitSet = (BitSet)this.sets.get((int)(n - SetIndexManipulable.EMPTYSET)).set.clone();
        BitSet bitSet2 = this.sets.get((int)(n2 - SetIndexManipulable.EMPTYSET)).set;
        bitSet.and(bitSet2);
        return this.findOrAdd(bitSet);
    }

    public int subtract(int n, BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.sets.get((int)(n - SetIndexManipulable.EMPTYSET)).set.clone();
        bitSet2.andNot(bitSet);
        return this.findOrAdd(bitSet2);
    }

    @Override
    public int subtract(int n, Object object) throws DLTException {
        if (object == null) {
            return n;
        }
        return this.merge(n, (BitSet)object);
    }

    @Override
    public int subtractInternal(int n, int n2) {
        BitSet bitSet = (BitSet)this.sets.get((int)(n - SetIndexManipulable.EMPTYSET)).set.clone();
        BitSet bitSet2 = this.sets.get((int)(n2 - SetIndexManipulable.EMPTYSET)).set;
        bitSet.andNot(bitSet2);
        return this.findOrAdd(bitSet);
    }

    public int fromIntMask(long l) {
        return this.findOrAdd(Utils.bitSetFromLongMask(l));
    }

    public int fromIntMask(int n) {
        return this.findOrAdd(Utils.bitSetFromIntMask(n));
    }

    public int getHighestRule() {
        int n = -1;
        for (IndexBitSet indexBitSet : this.sets) {
            if (indexBitSet.set == null) continue;
            n = Math.max(n, indexBitSet.set.length());
        }
        return n;
    }

    class IndexBitSet {
        BitSet set;
        int associated_index;
        int reference_count = 0;

        IndexBitSet() {
            assert (SetIndexManipulable.this.free_count == 0);
            this.associated_index = SetIndexManipulable.this.sets.size();
            SetIndexManipulable.this.sets.add(this);
        }

        void attach(BitSet bitSet) {
            this.set = bitSet;
            assert (SetIndexManipulable.this.map.get(bitSet) == null);
            SetIndexManipulable.this.map.put(bitSet, this);
        }

        private void detach() {
            SetIndexManipulable.this.map.remove(this.set);
            this.set = null;
            ++SetIndexManipulable.this.free_count;
            if (!SetIndexManipulable.this.free_heap.isFull()) {
                SetIndexManipulable.this.free_heap.allocateCell(this.associated_index);
            }
        }

        int addRef() {
            assert (this.set != null);
            return ++this.reference_count;
        }

        int delRef() {
            int n = --this.reference_count;
            return n;
        }

        int write(DataOutput dataOutput) throws IOException {
            if (this.set == null) {
                dataOutput.writeInt(-1);
                return 4;
            }
            dataOutput.writeInt(this.set.size());
            int n = 4;
            dataOutput.writeInt(this.reference_count);
            n += 4;
            for (int i = 0; i < this.set.size(); i += 32) {
                int n2 = 1;
                int n3 = 0;
                for (int j = 0; j < 32; ++j) {
                    if (this.set.get(i + j)) {
                        n3 |= n2;
                    }
                    n2 <<= 1;
                }
                dataOutput.writeInt(n3);
                n += 4;
            }
            return n;
        }

        void read(DataInput dataInput) throws IOException {
            int n = dataInput.readInt();
            if (n == -1) {
                return;
            }
            this.reference_count = dataInput.readInt();
            BitSet bitSet = new BitSet(n);
            for (int i = 0; i < n; i += 32) {
                int n2 = 1;
                int n3 = dataInput.readInt();
                for (int j = 0; j < 32; ++j) {
                    if ((n3 & n2) != 0) {
                        bitSet.set(i + j);
                    }
                    n2 <<= 1;
                }
            }
            this.attach(bitSet);
        }

        public String toString() {
            return this.set != null ? this.set.toString() : "n/a";
        }
    }
}

