/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class SizedIOBuffers {
    private static ThreadLocal<SizedIOBuffers> ssdo = new ThreadLocal<SizedIOBuffers>(){

        @Override
        protected SizedIOBuffers initialValue() {
            return new SizedIOBuffers();
        }
    };
    private boolean locked = false;
    byte[] data;
    int position;
    private final ByteInStream byte_in = new ByteInStream();
    private final ByteOutStream byte_out;
    private final DataInput data_in = new DataInputStream(this.byte_in);
    private final DataOutput data_out;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    void makeRoom(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        while (n > n2) {
            n2 *= 2;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        this.data = byArray;
    }

    SizedIOBuffers() {
        this.byte_out = new ByteOutStream();
        this.data_out = new DataOutputStream(this.byte_out);
        this.data = new byte[32];
    }

    public static DataOutput allocateOutput() {
        SizedIOBuffers sizedIOBuffers = ssdo.get();
        if (sizedIOBuffers.locked) {
            return null;
        }
        sizedIOBuffers.byte_out.allocate();
        sizedIOBuffers.locked = true;
        return sizedIOBuffers.data_out;
    }

    public static int finalizeOutput(OutputStream outputStream) throws IOException {
        SizedIOBuffers sizedIOBuffers = ssdo.get();
        assert (sizedIOBuffers.locked);
        int n = sizedIOBuffers.byte_out.commit(outputStream);
        sizedIOBuffers.locked = false;
        return n;
    }

    public static DataInput allocateInput(InputStream inputStream) throws IOException {
        SizedIOBuffers sizedIOBuffers = ssdo.get();
        if (sizedIOBuffers.locked) {
            return null;
        }
        sizedIOBuffers.byte_in.load(inputStream);
        sizedIOBuffers.locked = true;
        return sizedIOBuffers.data_in;
    }

    public static void finalizeInput() {
        SizedIOBuffers sizedIOBuffers = ssdo.get();
        assert (sizedIOBuffers.locked);
        sizedIOBuffers.locked = false;
    }

    class ByteInStream
    extends InputStream {
        private int data_len;

        ByteInStream() {
        }

        void load(InputStream inputStream) throws IOException {
            inputStream.read(SizedIOBuffers.this.data, 0, 4);
            this.data_len = (SizedIOBuffers.this.data[0] & 0xFF) << 24 | (SizedIOBuffers.this.data[1] & 0xFF) << 16 | (SizedIOBuffers.this.data[2] & 0xFF) << 8 | SizedIOBuffers.this.data[3] & 0xFF;
            SizedIOBuffers.this.makeRoom(this.data_len);
            inputStream.read(SizedIOBuffers.this.data, 4, this.data_len - 4);
            SizedIOBuffers.this.position = 4;
        }

        @Override
        public int read() throws IOException {
            if (SizedIOBuffers.this.position == this.data_len) {
                return 0;
            }
            return SizedIOBuffers.this.data[SizedIOBuffers.this.position++] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = Math.min(this.data_len - SizedIOBuffers.this.position, n2);
            System.arraycopy(SizedIOBuffers.this.data, SizedIOBuffers.this.position, byArray, n, n3);
            Arrays.fill(byArray, n + n3, n + n2, (byte)0);
            SizedIOBuffers.this.position += n3;
            assert (SizedIOBuffers.this.position <= this.data_len);
            return n2;
        }
    }

    class ByteOutStream
    extends OutputStream {
        ByteOutStream() {
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            SizedIOBuffers.this.makeRoom(SizedIOBuffers.this.position + n2);
            System.arraycopy(byArray, n, SizedIOBuffers.this.data, SizedIOBuffers.this.position, n2);
            SizedIOBuffers.this.position += n2;
        }

        @Override
        public void write(int n) throws IOException {
            SizedIOBuffers.this.makeRoom(SizedIOBuffers.this.position + 1);
            SizedIOBuffers.this.data[SizedIOBuffers.this.position++] = (byte)n;
        }

        void allocate() {
            SizedIOBuffers.this.position = 4;
        }

        int commit(OutputStream outputStream) throws IOException {
            SizedIOBuffers.this.data[3] = 1;
            while (SizedIOBuffers.this.data[SizedIOBuffers.this.position - 1] == 0) {
                --SizedIOBuffers.this.position;
            }
            SizedIOBuffers.this.data[3] = (byte)(SizedIOBuffers.this.position & 0xFF);
            SizedIOBuffers.this.data[2] = (byte)(SizedIOBuffers.this.position >> 8 & 0xFF);
            SizedIOBuffers.this.data[1] = (byte)(SizedIOBuffers.this.position >> 16 & 0xFF);
            SizedIOBuffers.this.data[0] = (byte)(SizedIOBuffers.this.position >> 24 & 0xFF);
            outputStream.write(SizedIOBuffers.this.data, 0, SizedIOBuffers.this.position);
            return SizedIOBuffers.this.position;
        }
    }
}

