/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.Messages;
import java.text.CharacterIterator;

public final class StringBufferCharacterIterator
implements CharacterIterator {
    private CharSequence _text;
    private int _begin;
    private int _end;
    private int _pos;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public StringBufferCharacterIterator(CharSequence charSequence) {
        this(charSequence, 0);
    }

    public StringBufferCharacterIterator(CharSequence charSequence, int n) {
        this(charSequence, 0, charSequence.length(), n);
    }

    public StringBufferCharacterIterator(CharSequence charSequence, int n, int n2, int n3) {
        if (charSequence == null) {
            throw new NullPointerException();
        }
        this._text = charSequence;
        if (n < 0 || n > n2 || n2 > charSequence.length()) {
            throw new IllegalArgumentException(Messages.getString("invalid.substring"));
        }
        if (n3 < n || n3 > n2) {
            throw new IllegalArgumentException(Messages.getString("invalid.position"));
        }
        this._begin = n;
        this._end = n2;
        this._pos = n3;
    }

    public void setText(CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException();
        }
        this._text = charSequence;
        this._begin = 0;
        this._end = charSequence.length();
        this._pos = 0;
    }

    @Override
    public char first() {
        this._pos = this._begin;
        return this.current();
    }

    @Override
    public char last() {
        this._pos = this._end != this._begin ? this._end - 1 : this._end;
        return this.current();
    }

    @Override
    public char setIndex(int n) {
        if (n < this._begin || n > this._end) {
            throw new IllegalArgumentException(Messages.getString("invalid.index"));
        }
        this._pos = n;
        return this.current();
    }

    @Override
    public char current() {
        if (this._pos >= this._begin && this._pos < this._end) {
            return this._text.charAt(this._pos);
        }
        return '\uffff';
    }

    @Override
    public char next() {
        if (this._pos < this._end - 1) {
            return this._text.charAt(++this._pos);
        }
        this._pos = this._end;
        return '\uffff';
    }

    @Override
    public char previous() {
        if (this._pos > this._begin) {
            return this._text.charAt(--this._pos);
        }
        return '\uffff';
    }

    @Override
    public int getBeginIndex() {
        return this._begin;
    }

    @Override
    public int getEndIndex() {
        return this._end;
    }

    @Override
    public int getIndex() {
        return this._pos;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this._begin;
        n = 31 * n + this._end;
        n = 31 * n + (this._text == null ? 0 : this._text.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StringBufferCharacterIterator stringBufferCharacterIterator = (StringBufferCharacterIterator)object;
        if (this._begin != stringBufferCharacterIterator._begin) {
            return false;
        }
        if (this._end != stringBufferCharacterIterator._end) {
            return false;
        }
        if (this._pos != stringBufferCharacterIterator._pos) {
            return false;
        }
        return !(this._text == null ? stringBufferCharacterIterator._text != null : !this._text.equals(stringBufferCharacterIterator._text));
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

