/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.util.CharacterMapper;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public class TitlecasingCharacterIterator
implements CharacterIterator {
    CharacterIterator iterator;
    boolean isFirstLetterOfWord = false;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public TitlecasingCharacterIterator() {
        this.iterator = new StringCharacterIterator("");
    }

    public TitlecasingCharacterIterator(CharacterIterator characterIterator) {
        this.iterator = characterIterator;
    }

    @Override
    public char first() {
        char c = this.iterator.first();
        c = CharacterMapper.toLowerCase(c);
        return c;
    }

    @Override
    public char last() {
        char c = this.iterator.last();
        c = CharacterMapper.toLowerCase(c);
        return c;
    }

    @Override
    public char current() {
        char c = this.iterator.current();
        if (this.isFirstLetterOfWord) {
            if (Character.isUpperCase(c) || Character.isTitleCase(c)) {
                this.isFirstLetterOfWord = false;
                return c;
            }
            this.isFirstLetterOfWord = false;
            return Character.toTitleCase(c);
        }
        c = CharacterMapper.toLowerCase(c);
        return c;
    }

    @Override
    public char next() {
        char c = this.iterator.next();
        c = CharacterMapper.toLowerCase(c);
        return c;
    }

    @Override
    public char previous() {
        char c = this.iterator.previous();
        c = CharacterMapper.toLowerCase(c);
        return c;
    }

    @Override
    public char setIndex(int n) {
        char c = this.iterator.setIndex(n);
        this.isFirstLetterOfWord = true;
        c = Character.toTitleCase(c);
        return c;
    }

    @Override
    public int getBeginIndex() {
        return this.iterator.getBeginIndex();
    }

    @Override
    public int getEndIndex() {
        return this.iterator.getEndIndex();
    }

    @Override
    public int getIndex() {
        return this.iterator.getIndex();
    }

    @Override
    public Object clone() {
        try {
            TitlecasingCharacterIterator titlecasingCharacterIterator = (TitlecasingCharacterIterator)super.clone();
            titlecasingCharacterIterator.iterator = (CharacterIterator)this.iterator.clone();
            return titlecasingCharacterIterator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public CharacterIterator getIterator() {
        return this.iterator;
    }

    public void setIterator(CharacterIterator characterIterator) {
        this.iterator = characterIterator;
    }
}

