/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import java.text.CharacterIterator;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Utils {
    private static final byte[] trailingZeroTable = new byte[]{-25, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public static int combineHash(int n, int n2, int n3) {
        return (n * 31 + n2) * 31 + n3;
    }

    public static int combineHash(int n, int n2) {
        return n * 31 + n2;
    }

    public static StringBuffer makeString(StringBuffer stringBuffer, CharacterIterator characterIterator, int n, int n2) {
        int n3 = characterIterator.getIndex();
        characterIterator.setIndex(n);
        if (n2 > characterIterator.getEndIndex()) {
            n2 = characterIterator.getEndIndex();
        }
        char c = characterIterator.current();
        while (n2 > characterIterator.getIndex()) {
            stringBuffer.append(c);
            c = characterIterator.next();
        }
        characterIterator.setIndex(n3);
        return stringBuffer;
    }

    public static StringBuilder makeString(StringBuilder stringBuilder, CharacterIterator characterIterator, int n, int n2) {
        int n3 = characterIterator.getIndex();
        characterIterator.setIndex(n);
        if (n2 > characterIterator.getEndIndex()) {
            n2 = characterIterator.getEndIndex();
        }
        char c = characterIterator.current();
        while (n2 > characterIterator.getIndex()) {
            stringBuilder.append(c);
            c = characterIterator.next();
        }
        characterIterator.setIndex(n3);
        return stringBuilder;
    }

    public static String makeString(CharacterIterator characterIterator, int n, int n2) {
        return Utils.makeString(new StringBuilder(), characterIterator, n, n2).toString();
    }

    public static int compareCollections(Collection<?> collection, Collection<?> collection2, Comparator<Object> comparator) {
        Iterator<?> iterator = collection.iterator();
        Iterator<?> iterator2 = collection2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            int n = comparator.compare(iterator.next(), iterator2.next());
            if (n == 0) continue;
            return n;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        if (iterator.hasNext()) {
            return 1;
        }
        return 0;
    }

    public static int[] assureIntArrayRoom(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray.length;
        if (n >= n4) {
            int[] nArray2 = new int[Math.max(n + 1, n4 * n2 / n3)];
            System.arraycopy(nArray, 0, nArray2, 0, n4);
            return nArray2;
        }
        return nArray;
    }

    public static int[] assureIntArrayRoom(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        if (n >= n3) {
            int[] nArray2 = new int[Math.max(n + 1, n3 + n2)];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            return nArray2;
        }
        return nArray;
    }

    public static char[] assureCharArrayRoom(char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = cArray.length;
        if (n >= n5) {
            assert (n4 >= 1);
            char[] cArray2 = new char[Math.max(n + n4, n5 * n2 / n3)];
            System.arraycopy(cArray, 0, cArray2, 0, n5);
            return cArray2;
        }
        return cArray;
    }

    public static int[] insertInIntArray(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        if (nArray.length == n) {
            int[] nArray2 = new int[Math.max(n2 + 1, nArray.length * n4 / n5)];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray2[n2] = n3;
            System.arraycopy(nArray, n2, nArray2, n2 + 1, n - n2);
            Arrays.fill(nArray2, n + 1, nArray2.length, Integer.MAX_VALUE);
            return nArray2;
        }
        System.arraycopy(nArray, n2, nArray, n2 + 1, n - n2);
        nArray[n2] = n3;
        return nArray;
    }

    public static int[] mergeSortedIntSets(int[] nArray, int[] nArray2) {
        if (nArray2.length == 0) {
            return nArray;
        }
        if (nArray.length == 0) {
            return nArray2;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < nArray.length && n2 < nArray2.length) {
            if (nArray[n] == nArray2[n2]) {
                ++n;
                ++n2;
            } else if (nArray[n] < nArray2[n2]) {
                ++n;
            } else {
                ++n2;
            }
            ++n3;
        }
        int[] nArray3 = new int[n3 += nArray.length - n + nArray2.length - n2];
        n3 = 0;
        n2 = 0;
        n = 0;
        while (n < nArray.length && n2 < nArray2.length) {
            if (nArray[n] == nArray2[n2]) {
                nArray3[n3] = nArray[n];
                ++n;
                ++n2;
            } else if (nArray[n] < nArray2[n2]) {
                nArray3[n3] = nArray[n];
                ++n;
            } else {
                nArray3[n3] = nArray2[n2];
                ++n2;
            }
            ++n3;
        }
        while (n < nArray.length) {
            nArray3[n3++] = nArray[n++];
        }
        while (n2 < nArray2.length) {
            nArray3[n3++] = nArray2[n2++];
        }
        return nArray3;
    }

    public static int[] growArray(int[] nArray, int n) {
        if (n <= nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static int[] removeDuplicates(int[] nArray) {
        if (nArray.length < 2) {
            return nArray;
        }
        Arrays.sort(nArray);
        int n = 1;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == nArray[i - 1]) continue;
            ++n;
        }
        if (n == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        n = 0;
        nArray2[0] = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == nArray[i - 1]) continue;
            nArray2[++n] = nArray[i];
        }
        return nArray2;
    }

    public static int removeDuplicates(int[] nArray, int n, int n2) {
        int n3;
        if (n2 == n) {
            return n2;
        }
        Arrays.sort(nArray, n, n2);
        for (n3 = n + 1; n3 < n2 && nArray[n3] != nArray[n3 - 1]; ++n3) {
        }
        for (int i = n3 + 1; i < n2; ++i) {
            if (nArray[i] == nArray[i - 1]) continue;
            nArray[n3++] = nArray[i];
        }
        return n3;
    }

    public static boolean setsIntersect(int[] nArray, int[] nArray2) {
        if (nArray.length == 0 || nArray2.length == 0) {
            return false;
        }
        int n = nArray[0];
        int n2 = nArray2[0];
        int n3 = 1;
        int n4 = 1;
        while (true) {
            if (n < n2) {
                if (n3 == nArray.length) {
                    return false;
                }
                n = nArray[n3++];
                continue;
            }
            while (n2 < n) {
                if (n4 == nArray2.length) {
                    return false;
                }
                n2 = nArray2[n4++];
            }
            if (n == n2) break;
        }
        return true;
    }

    public static int countIntersection(int[] nArray, int[] nArray2) {
        if (nArray.length == 0 || nArray2.length == 0) {
            return 0;
        }
        int n = 0;
        int n2 = nArray[0];
        int n3 = nArray2[0];
        int n4 = 1;
        int n5 = 1;
        while (true) {
            if (n2 < n3) {
                if (n4 == nArray.length) {
                    return n;
                }
                n2 = nArray[n4++];
                continue;
            }
            while (n3 < n2) {
                if (n5 == nArray2.length) {
                    return n;
                }
                n3 = nArray2[n5++];
            }
            if (n2 != n3) continue;
            ++n;
            if (n4 == nArray.length || n5 == nArray2.length) {
                return n;
            }
            n2 = nArray[n4++];
            n3 = nArray2[n5++];
        }
    }

    public static int[] intersection(int[] nArray, int[] nArray2) {
        int n = Utils.countIntersection(nArray, nArray2);
        int[] nArray3 = new int[n];
        if (n == 0) {
            return nArray3;
        }
        n = 0;
        int n2 = nArray[0];
        int n3 = nArray2[0];
        int n4 = 1;
        int n5 = 1;
        while (true) {
            if (n2 < n3) {
                assert (n4 < nArray.length);
                n2 = nArray[n4++];
                continue;
            }
            while (n3 < n2) {
                assert (n5 < nArray2.length);
                n3 = nArray2[n5++];
            }
            if (n2 != n3) continue;
            nArray3[n] = n2;
            if (++n == nArray3.length) {
                return nArray3;
            }
            n2 = nArray[n4++];
            n3 = nArray2[n5++];
        }
    }

    public static int[] removeExisting(int[] nArray, int[] nArray2) {
        if (nArray2.length == 0) {
            return nArray;
        }
        int[] nArray3 = new int[nArray.length - nArray2.length];
        int n = nArray[0];
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray2.length) {
            n = nArray[n2++];
            int n4 = nArray2[n3++];
            while (n < n4) {
                nArray3[n2 - n3] = n;
                n = nArray[n2++];
            }
            assert (n == n4);
        }
        ++n3;
        while (n2 < nArray.length) {
            int n5 = n2++;
            nArray3[n2 - n3] = n = nArray[n5];
        }
        return nArray3;
    }

    public static String toString(int[] nArray) {
        return Arrays.toString(nArray);
    }

    public static <V, K> Map<V, K> invertMap(Map<K, V> map, Map<V, K> map2) {
        if (map2 == null) {
            map2 = new HashMap<V, K>();
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            map2.put(entry.getValue(), entry.getKey());
        }
        return map2;
    }

    public static int translateThroughMap(int n, Map<Integer, Integer> map) {
        if (map == null) {
            return n;
        }
        Integer n2 = map.get(n);
        if (n2 != null) {
            return n2;
        }
        return n;
    }

    public static int bitsNeeded(int n) {
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }

    public static int trailingZeroCnt(int n) {
        int n2 = n & 0xFF;
        if (n2 != 0) {
            return trailingZeroTable[n2];
        }
        n2 = n >>> 8 & 0xFF;
        if (n2 != 0) {
            return trailingZeroTable[n2] + 8;
        }
        n2 = n >>> 16 & 0xFF;
        if (n2 != 0) {
            return trailingZeroTable[n2] + 16;
        }
        n2 = n >>> 24 & 0xFF;
        return trailingZeroTable[n2] + 24;
    }

    public static BitSet bitSetFromLongMask(long l) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < 64; ++i) {
            if ((l & 1L << i) == 0L) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public static BitSet bitSetFromIntMask(int n) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < 32; ++i) {
            if ((n & 1 << i) == 0) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public static long longMaskFromBitSet(BitSet bitSet) {
        long l = 0L;
        for (int i = 0; i < 64; ++i) {
            if (!bitSet.get(i)) continue;
            l |= 1L << i;
        }
        return l;
    }

    public static int intMaskFromBitSet(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            if (!bitSet.get(i)) continue;
            n |= 1 << i;
        }
        return n;
    }

    public static <T extends Comparable<T>> void removeDuplicates(List<T> list) {
        int n;
        int n2;
        Collections.sort(list);
        int n3 = 0;
        int n4 = list.size();
        for (n2 = n3 + 1; n2 < n4 && !((Comparable)list.get(n2)).equals(list.get(n2 - 1)); ++n2) {
        }
        if (n2 >= n4) {
            return;
        }
        for (n = n2 + 1; n < n4; ++n) {
            if (((Comparable)list.get(n)).equals(list.get(n - 1))) continue;
            list.set(n2++, list.get(n));
        }
        while (--n >= n2) {
            list.remove(n);
        }
    }

    public static final class HashableIntPair {
        private final int l;
        private final int r;

        public HashableIntPair(int n, int n2) {
            this.l = n;
            this.r = n2;
        }

        public int hashCode() {
            return Utils.combineHash(this.l, this.r);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HashableIntPair hashableIntPair = (HashableIntPair)object;
            return this.l == hashableIntPair.l && this.r == hashableIntPair.r;
        }

        public int left() {
            return this.l;
        }

        public int right() {
            return this.r;
        }

        public String toString() {
            return "(" + this.l + ", " + this.r + ")";
        }
    }

    public static final class HashableObjectPair<TypeA, TypeB> {
        public final TypeA l;
        public final TypeB r;

        public HashableObjectPair(TypeA TypeA, TypeB TypeB) {
            this.l = TypeA;
            this.r = TypeB;
        }

        public String toString() {
            return "(" + this.l + ", " + this.r + ")";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HashableObjectPair hashableObjectPair = (HashableObjectPair)object;
            if (this.l == null ? hashableObjectPair.l != null : !this.l.equals(hashableObjectPair.l)) {
                return false;
            }
            return !(this.r == null ? hashableObjectPair.r != null : !this.r.equals(hashableObjectPair.r));
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.l == null ? 0 : this.l.hashCode());
            n = 31 * n + (this.r == null ? 0 : this.r.hashCode());
            return n;
        }
    }

    public static final class ObjectPair<TypeA, TypeB> {
        public final TypeA l;
        public final TypeB r;

        public ObjectPair(TypeA TypeA, TypeB TypeB) {
            this.l = TypeA;
            this.r = TypeB;
        }

        public String toString() {
            return "(" + this.l + ", " + this.r + ")";
        }
    }

    public static final class ModifiableObjectPair<TypeA, TypeB> {
        public TypeA l;
        public TypeB r;

        public ModifiableObjectPair(TypeA TypeA, TypeB TypeB) {
            this.l = TypeA;
            this.r = TypeB;
        }

        public String toString() {
            return "(" + this.l + ", " + this.r + ")";
        }
    }

    public static final class ModifiableIntPair {
        public int l;
        public int r;

        public ModifiableIntPair(int n, int n2) {
            this.l = n;
            this.r = n2;
        }

        public String toString() {
            return "(" + this.l + ", " + this.r + ")";
        }

        public int getValue() {
            return this.l;
        }

        public void setValue(int n) {
            this.l = n;
        }
    }

    public static final class ModifiableInteger {
        public int v;

        public ModifiableInteger(int n) {
            this.v = n;
        }

        public String toString() {
            return Integer.toString(this.v);
        }

        public int getValue() {
            return this.v;
        }

        public void setValue(int n) {
            this.v = n;
        }
    }
}

