/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class XMLWriter {
    private final PrintWriter writer;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private final Stack<String> elementNames = new Stack();
    private boolean isInStartElementTag = false;
    private boolean isLineHead = true;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public XMLWriter(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
    }

    public void writeProcessingInstruction(String string, String string2) {
        this.writer.print("<?" + string + ' ' + string2 + "?>");
        this.newLine();
    }

    public void writeStartDocument() {
        this.writer.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.newLine();
    }

    public void writeEndDocument() {
        this.writer.flush();
    }

    public void writeStartElement(String string) {
        if (this.isInStartElementTag) {
            this.writer.print('>');
            this.newLine();
            this.isInStartElementTag = false;
        }
        this.tab();
        this.writer.print('<');
        this.writer.print(string);
        this.isInStartElementTag = true;
        this.isLineHead = false;
        this.elementNames.push(string);
    }

    public void writeStartElement(String string, String string2) {
        String string3 = this.namespaces.get(string);
        this.writeStartElement((string3 != null ? string3 : string) + ':' + string2);
    }

    public void writeEndElement() {
        String string = this.elementNames.pop();
        if (this.isInStartElementTag) {
            this.writer.print("/>");
            this.newLine();
            this.isInStartElementTag = false;
        } else {
            this.tab();
            this.writer.print("</");
            this.writer.print(string);
            this.writer.print('>');
            this.newLine();
        }
    }

    public void writeAttribute(String string, String string2) throws IllegalStateException {
        this.writer.print(' ');
        this.writer.print(string);
        this.writer.print("=\"");
        this.writer.print(this.escape(string2));
        this.writer.print('\"');
        this.isLineHead = false;
    }

    public void writeAttribute(String string, String string2, String string3) throws IllegalStateException {
        String string4 = this.namespaces.get(string2);
        this.writeAttribute((string4 != null ? string4 : string) + ':' + string2, string3);
    }

    public void writeNamespace(String string, String string2) {
        this.writer.print(" xmlns:");
        this.writer.print(string);
        this.writer.print("=\"");
        this.writer.print(string2);
        this.writer.print('\"');
        this.isLineHead = false;
        this.namespaces.put(string2, string);
    }

    public void writeCharacters(String string) {
        if (string.length() == 0) {
            return;
        }
        if (this.isInStartElementTag) {
            this.writer.print('>');
            this.isInStartElementTag = false;
        }
        this.writer.print(this.escape(string));
        this.isLineHead = false;
    }

    public void writeComment(String string) {
        if (string.length() == 0) {
            return;
        }
        if (this.isInStartElementTag) {
            this.writer.print('>');
            this.newLine();
            this.isInStartElementTag = false;
        }
        this.tab();
        this.writer.print("<!--");
        this.writer.print(string);
        this.writer.print("-->");
        this.newLine();
    }

    private void tab() {
        if (this.isLineHead) {
            for (int i = 0; i < this.elementNames.size(); ++i) {
                this.writer.print('\t');
            }
        }
    }

    private void newLine() {
        this.writer.println();
        this.isLineHead = true;
    }

    private String escape(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
    }
}

