/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.md;

import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.md.CorefMentionFinder;
import edu.stanford.nlp.coref.md.MentionDetectionClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class HybridCorefMentionFinder
extends CorefMentionFinder {
    public MentionDetectionClassifier mdClassifier = null;

    public HybridCorefMentionFinder(HeadFinder headFinder, Properties props) throws ClassNotFoundException, IOException {
        this.headFinder = headFinder;
        this.lang = CorefProperties.getLanguage(props);
        this.mdClassifier = CorefProperties.isMentionDetectionTraining(props) ? null : (MentionDetectionClassifier)IOUtils.readObjectFromURLOrClasspathOrFileSystem(CorefProperties.getMentionDetectionModel(props));
    }

    @Override
    public List<List<Mention>> findMentions(Annotation doc, Dictionaries dict, Properties props) {
        ArrayList<List<Mention>> predictedMentions = new ArrayList<List<Mention>>();
        Set<String> neStrings = Generics.newHashSet();
        ArrayList<Set<IntPair>> mentionSpanSetList = Generics.newArrayList();
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap s : sentences) {
            ArrayList<Mention> mentions = new ArrayList<Mention>();
            predictedMentions.add(mentions);
            Set<IntPair> mentionSpanSet = Generics.newHashSet();
            Set<IntPair> namedEntitySpanSet = Generics.newHashSet();
            HybridCorefMentionFinder.extractPremarkedEntityMentions(s, mentions, mentionSpanSet, namedEntitySpanSet);
            HybridCorefMentionFinder.extractNamedEntityMentions(s, mentions, mentionSpanSet, namedEntitySpanSet);
            HybridCorefMentionFinder.extractNPorPRP(s, mentions, mentionSpanSet, namedEntitySpanSet);
            HybridCorefMentionFinder.extractEnumerations(s, mentions, mentionSpanSet, namedEntitySpanSet);
            HybridCorefMentionFinder.addNamedEntityStrings(s, neStrings, namedEntitySpanSet);
            mentionSpanSetList.add(mentionSpanSet);
        }
        HybridCorefMentionFinder.extractNamedEntityModifiers(sentences, mentionSpanSetList, predictedMentions, neStrings);
        for (int i = 0; i < sentences.size(); ++i) {
            this.findHead((CoreMap)sentences.get(i), (List)predictedMentions.get(i));
        }
        this.removeSpuriousMentions(doc, predictedMentions, dict, CorefProperties.removeNestedMentions(props), this.lang);
        if (!CorefProperties.isMentionDetectionTraining(props)) {
            this.mdClassifier.classifyMentions(predictedMentions, dict, props);
        }
        return predictedMentions;
    }

    protected static void extractNamedEntityMentions(CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        IntPair mSpan;
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        SemanticGraph basicDependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        SemanticGraph enhancedDependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class);
        if (enhancedDependency == null) {
            enhancedDependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        }
        String preNE = "O";
        int beginIndex = -1;
        for (CoreLabel w : sent) {
            String nerString = w.ner();
            if (nerString.equals(preNE)) continue;
            int endIndex = (Integer)w.get(CoreAnnotations.IndexAnnotation.class) - 1;
            if (!preNE.matches("O")) {
                if (((String)w.get(CoreAnnotations.TextAnnotation.class)).equals("'s") && w.tag().equals("POS")) {
                    ++endIndex;
                }
                IntPair mSpan2 = new IntPair(beginIndex, endIndex);
                if (beginIndex < endIndex && !mentionSpanSet.contains(mSpan2)) {
                    int dummyMentionId = -1;
                    Mention m = new Mention(dummyMentionId, beginIndex, endIndex, sent, basicDependency, enhancedDependency, new ArrayList<CoreLabel>(sent.subList(beginIndex, endIndex)));
                    mentions.add(m);
                    mentionSpanSet.add(mSpan2);
                    namedEntitySpanSet.add(mSpan2);
                }
            }
            beginIndex = endIndex;
            preNE = nerString;
        }
        if (!preNE.matches("O") && !mentionSpanSet.contains(mSpan = new IntPair(beginIndex, sent.size()))) {
            int dummyMentionId = -1;
            Mention m = new Mention(dummyMentionId, beginIndex, sent.size(), sent, basicDependency, enhancedDependency, new ArrayList<CoreLabel>(sent.subList(beginIndex, sent.size())));
            mentions.add(m);
            mentionSpanSet.add(mSpan);
            namedEntitySpanSet.add(mSpan);
        }
    }

    private static void extractNPorPRP(CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        Tree tree = (Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class);
        tree.indexLeaves();
        SemanticGraph basicDependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        SemanticGraph enhancedDependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class);
        if (enhancedDependency == null) {
            enhancedDependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        }
        TregexPattern tgrepPattern = npOrPrpMentionPattern;
        TregexMatcher matcher = tgrepPattern.matcher(tree);
        while (matcher.find()) {
            IntPair mSpan;
            Tree t = matcher.getMatch();
            List mLeaves = t.getLeaves();
            int beginIdx = (Integer)((CoreLabel)((Tree)mLeaves.get(0)).label()).get(CoreAnnotations.IndexAnnotation.class) - 1;
            int endIdx = (Integer)((CoreLabel)((Tree)mLeaves.get(mLeaves.size() - 1)).label()).get(CoreAnnotations.IndexAnnotation.class);
            if (",".equals(((CoreLabel)sent.get(endIdx - 1)).word())) {
                --endIdx;
            }
            if (mentionSpanSet.contains(mSpan = new IntPair(beginIdx, endIdx)) || HybridCorefMentionFinder.insideNE(mSpan, namedEntitySpanSet) && !t.value().startsWith("PRP")) continue;
            int dummyMentionId = -1;
            Mention m = new Mention(dummyMentionId, beginIdx, endIdx, sent, basicDependency, enhancedDependency, new ArrayList<CoreLabel>(sent.subList(beginIdx, endIdx)), t);
            mentions.add(m);
            mentionSpanSet.add(mSpan);
            if (m.originalSpan.size() <= 1) continue;
            boolean isNE = true;
            for (CoreLabel cl : m.originalSpan) {
                if (cl.tag().startsWith("NNP")) continue;
                isNE = false;
            }
            if (!isNE) continue;
            namedEntitySpanSet.add(mSpan);
        }
    }
}

