/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.NodePattern;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComplexNodePattern<M, K>
extends NodePattern<M> {
    private final List<Pair<K, NodePattern>> annotationPatterns;
    private final BiFunction<M, K, Object> getter;
    private static final Pattern LITERAL_PATTERN = Pattern.compile("[^\\[\\]?.\\\\^$()*+{}|]*");

    public ComplexNodePattern(BiFunction<M, K, Object> getter, List<Pair<K, NodePattern>> annotationPatterns) {
        this.annotationPatterns = annotationPatterns;
        this.getter = getter;
    }

    public ComplexNodePattern(BiFunction<M, K, Object> getter, Pair<K, NodePattern> ... annotationPatterns) {
        this.annotationPatterns = Arrays.asList(annotationPatterns);
        this.getter = getter;
    }

    public ComplexNodePattern(BiFunction<M, K, Object> getter, K key, NodePattern pattern) {
        this(getter, Pair.makePair(key, pattern));
    }

    public List<Pair<K, NodePattern>> getAnnotationPatterns() {
        return Collections.unmodifiableList(this.annotationPatterns);
    }

    public static NodePattern<String> newStringRegexPattern(String regex, int flags) {
        boolean isLiteral;
        boolean bl = isLiteral = (flags & 0x10) != 0 || LITERAL_PATTERN.matcher(regex).matches();
        if (isLiteral) {
            boolean caseInsensitive = (flags & 2) != 0;
            int stringMatchFlags = caseInsensitive ? 2 : 0;
            return new StringAnnotationPattern(regex, stringMatchFlags);
        }
        return new StringAnnotationRegexPattern(regex, flags);
    }

    public static <M, K> ComplexNodePattern valueOf(Env env, Map<String, String> attributes, BiFunction<M, K, Object> getter, Function<Pair<Env, String>, K> getKey) {
        ComplexNodePattern<M, K> p = new ComplexNodePattern<M, K>(getter, new ArrayList<Pair<K, NodePattern>>(attributes.size()));
        p.populate(env, attributes, getKey);
        return p;
    }

    protected void populate(Env env, Map<String, String> attributes, Function<Pair<Env, String>, K> getKey) {
        ComplexNodePattern p = this;
        block12: for (String attr : attributes.keySet()) {
            String value = attributes.get(attr);
            K c = getKey.apply(Pair.makePair(env, attr));
            if (c != null) {
                Double v;
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                    value = value.replaceAll("\\\\\"", "\"");
                    p.add(c, new StringAnnotationPattern(value, env.defaultStringMatchFlags));
                    continue;
                }
                if (value.startsWith("/") && value.endsWith("/")) {
                    value = value.substring(1, value.length() - 1);
                    value = value.replaceAll("\\\\/", "/");
                    String regex = env != null ? env.expandStringRegex(value) : value;
                    int flags = env != null ? env.defaultStringPatternFlags : 0;
                    p.add(c, ComplexNodePattern.newStringRegexPattern(regex, flags));
                    continue;
                }
                if (value.startsWith("::")) {
                    switch (value) {
                        case "::IS_NIL": 
                        case "::NOT_EXISTS": {
                            p.add(c, new NilAnnotationPattern());
                            break;
                        }
                        case "::EXISTS": 
                        case "::NOT_NIL": {
                            p.add(c, new NotNilAnnotationPattern());
                            break;
                        }
                        case "::IS_NUM": {
                            p.add(c, new NumericAnnotationPattern(0.0, NumericAnnotationPattern.CmpType.IS_NUM));
                            break;
                        }
                        default: {
                            Object custom;
                            boolean ok = false;
                            if (env != null && (custom = env.get(value)) != null) {
                                p.add(c, (NodePattern)custom);
                                ok = true;
                            }
                            if (ok) continue block12;
                            throw new IllegalArgumentException("Invalid value " + value + " for key: " + attr);
                        }
                    }
                    continue;
                }
                if (value.startsWith("<=")) {
                    v = Double.parseDouble(value.substring(2));
                    p.add(c, new NumericAnnotationPattern(v, NumericAnnotationPattern.CmpType.LE));
                    continue;
                }
                if (value.startsWith(">=")) {
                    v = Double.parseDouble(value.substring(2));
                    p.add(c, new NumericAnnotationPattern(v, NumericAnnotationPattern.CmpType.GE));
                    continue;
                }
                if (value.startsWith("==")) {
                    v = Double.parseDouble(value.substring(2));
                    p.add(c, new NumericAnnotationPattern(v, NumericAnnotationPattern.CmpType.EQ));
                    continue;
                }
                if (value.startsWith("!=")) {
                    v = Double.parseDouble(value.substring(2));
                    p.add(c, new NumericAnnotationPattern(v, NumericAnnotationPattern.CmpType.NE));
                    continue;
                }
                if (value.startsWith(">")) {
                    v = Double.parseDouble(value.substring(1));
                    p.add(c, new NumericAnnotationPattern(v, NumericAnnotationPattern.CmpType.GT));
                    continue;
                }
                if (value.startsWith("<")) {
                    v = Double.parseDouble(value.substring(1));
                    p.add(c, new NumericAnnotationPattern(v, NumericAnnotationPattern.CmpType.LT));
                    continue;
                }
                if (value.matches("[A-Za-z0-9_+-.]+")) {
                    p.add(c, new StringAnnotationPattern(value, env.defaultStringMatchFlags));
                    continue;
                }
                throw new IllegalArgumentException("Invalid value " + value + " for key: " + attr);
            }
            throw new IllegalArgumentException("Unknown annotation key: " + attr);
        }
    }

    public void add(K c, NodePattern pattern) {
        this.annotationPatterns.add(Pair.makePair(c, pattern));
    }

    @Override
    public boolean match(M token) {
        boolean matched = true;
        for (Pair<K, NodePattern> entry : this.annotationPatterns) {
            NodePattern annoPattern = (NodePattern)entry.second;
            Object anno = this.getter.apply(token, entry.first);
            if (annoPattern.match(anno)) continue;
            matched = false;
            break;
        }
        return matched;
    }

    @Override
    public Object matchWithResult(M token) {
        HashMap matchResults = new HashMap();
        if (this.match(token, matchResults)) {
            return matchResults;
        }
        return null;
    }

    protected boolean match(M token, Map<K, Object> matchResults) {
        boolean matched = true;
        for (Pair<K, NodePattern> entry : this.annotationPatterns) {
            NodePattern annoPattern = (NodePattern)entry.second;
            Object anno = this.getter.apply(token, entry.first);
            Object matchResult = annoPattern.matchWithResult(anno);
            if (matchResult != null) {
                matchResults.put(entry.first, matchResult);
                continue;
            }
            matched = false;
            break;
        }
        return matched;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Pair<K, NodePattern> entry : this.annotationPatterns) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(entry.first).append(entry.second);
        }
        return sb.toString();
    }

    public static class IntegerAnnotationPattern
    extends NodePattern<Integer> {
        int value;

        public IntegerAnnotationPattern(int v) {
            this.value = v;
        }

        @Override
        public boolean match(Integer node) {
            return this.value == node;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class AttributesEqualMatchChecker<K>
    implements SequencePattern.NodesMatchChecker<Map<K, Object>> {
        Collection<K> keys;

        public AttributesEqualMatchChecker(K ... keys) {
            this.keys = CollectionUtils.asSet(keys);
        }

        @Override
        public boolean matches(Map<K, Object> o1, Map<K, Object> o2) {
            for (K key : this.keys) {
                Object v1 = o1.get(key);
                Object v2 = o2.get(key);
                if (!(v1 != null ? !v1.equals(v2) : v2 != null)) continue;
                return false;
            }
            return true;
        }
    }

    public static class NumericAnnotationPattern
    extends NodePattern<Object> {
        CmpType cmpType;
        double value;

        public NumericAnnotationPattern(double value, CmpType cmpType) {
            this.value = value;
            this.cmpType = cmpType;
        }

        @Override
        public boolean match(Object node) {
            if (node instanceof String) {
                return this.match((String)node);
            }
            if (node instanceof Number) {
                return this.match((Number)node);
            }
            return false;
        }

        @Override
        public boolean match(Number number) {
            if (number != null) {
                return this.cmpType.accept(number.doubleValue(), this.value);
            }
            return false;
        }

        @Override
        public boolean match(String str) {
            if (str != null) {
                try {
                    double v = Double.parseDouble(str);
                    return this.cmpType.accept(v, this.value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }

        public String toString() {
            return " " + (Object)((Object)this.cmpType) + " " + this.value;
        }

        static enum CmpType {
            IS_NUM{

                @Override
                boolean accept(double v1, double v2) {
                    return true;
                }
            }
            ,
            EQ{

                @Override
                boolean accept(double v1, double v2) {
                    return v1 == v2;
                }
            }
            ,
            NE{

                @Override
                boolean accept(double v1, double v2) {
                    return v1 != v2;
                }
            }
            ,
            GT{

                @Override
                boolean accept(double v1, double v2) {
                    return v1 > v2;
                }
            }
            ,
            GE{

                @Override
                boolean accept(double v1, double v2) {
                    return v1 >= v2;
                }
            }
            ,
            LT{

                @Override
                boolean accept(double v1, double v2) {
                    return v1 < v2;
                }
            }
            ,
            LE{

                @Override
                boolean accept(double v1, double v2) {
                    return v1 <= v2;
                }
            };


            boolean accept(double v1, double v2) {
                return false;
            }
        }
    }

    public static class StringInSetAnnotationPattern
    extends AbstractStringAnnotationPattern {
        Set<String> targets;

        public StringInSetAnnotationPattern(Set<String> targets, int flags) {
            this.flags = flags;
            this.targets = new HashSet<String>(targets.size());
            for (String target : targets) {
                this.targets.add(this.getNormalized(target));
            }
        }

        public StringInSetAnnotationPattern(Set<String> targets) {
            this(targets, 0);
        }

        public Set<String> getTargets() {
            return this.targets;
        }

        @Override
        public boolean match(String str) {
            return this.targets.contains(this.getNormalized(str));
        }

        public String toString() {
            return ":" + this.targets;
        }
    }

    public static class StringAnnotationPattern
    extends AbstractStringAnnotationPattern {
        String target;

        public StringAnnotationPattern(String str, int flags) {
            this.target = str;
            this.flags = flags;
        }

        public StringAnnotationPattern(String str) {
            this.target = str;
        }

        public String getString() {
            return this.target;
        }

        @Override
        public boolean match(String str) {
            if (this.normalize()) {
                str = this.getNormalized(str);
            }
            if (this.ignoreCase()) {
                return this.target.equalsIgnoreCase(str);
            }
            return this.target.equals(str);
        }

        public String toString() {
            return ":" + this.target;
        }
    }

    public static abstract class AbstractStringAnnotationPattern
    extends NodePattern<String> {
        int flags;

        public boolean ignoreCase() {
            return (this.flags & 2) != 0;
        }

        public boolean normalize() {
            return (this.flags & 4) != 0;
        }

        public String getNormalized(String str) {
            if (this.normalize()) {
                str = StringUtils.normalize(str);
            }
            if (this.ignoreCase()) {
                str = str.toLowerCase();
            }
            return str;
        }
    }

    public static class StringAnnotationRegexPattern
    extends NodePattern<String> {
        Pattern pattern;

        public StringAnnotationRegexPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        public StringAnnotationRegexPattern(String regex, int flags) {
            this.pattern = Pattern.compile(regex, flags);
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Matcher matcher(String str) {
            return this.pattern.matcher(str);
        }

        @Override
        public boolean match(String str) {
            if (str == null) {
                return false;
            }
            return this.pattern.matcher(str).matches();
        }

        @Override
        public Object matchWithResult(String str) {
            if (str == null) {
                return null;
            }
            Matcher m = this.pattern.matcher(str);
            if (m.matches()) {
                return m.toMatchResult();
            }
            return null;
        }

        public String toString() {
            return ":/" + this.pattern.pattern() + "/";
        }
    }

    public static class SequenceRegexPattern<T>
    extends NodePattern<List<T>> {
        SequencePattern<T> pattern;

        public SequenceRegexPattern(SequencePattern<T> pattern) {
            this.pattern = pattern;
        }

        public SequencePattern<T> getPattern() {
            return this.pattern;
        }

        public SequenceMatcher<T> matcher(List<T> list) {
            return this.pattern.getMatcher(list);
        }

        @Override
        public boolean match(List<T> list) {
            return this.pattern.getMatcher(list).matches();
        }

        @Override
        public Object matchWithResult(List<T> list) {
            SequenceMatcher<T> m = this.pattern.getMatcher(list);
            if (m.matches()) {
                return m.toBasicSequenceMatchResult();
            }
            return null;
        }

        public String toString() {
            return ":" + this.pattern.toString();
        }
    }

    public static class NotNilAnnotationPattern
    extends NodePattern<Object> {
        @Override
        public boolean match(Object obj) {
            return obj != null;
        }

        public String toString() {
            return "::NOT_NIL";
        }
    }

    public static class NilAnnotationPattern
    extends NodePattern<Object> {
        @Override
        public boolean match(Object obj) {
            return obj == null;
        }

        public String toString() {
            return "::IS_NIL";
        }
    }
}

