/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.DependencyGrammar;
import edu.stanford.nlp.parser.lexparser.IntDependency;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TagProjection;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Interner;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractDependencyGrammar
implements DependencyGrammar {
    private static Redwood.RedwoodChannels log = Redwood.channels(AbstractDependencyGrammar.class);
    protected TagProjection tagProjection;
    protected final Index<String> tagIndex;
    protected final Index<String> wordIndex;
    protected int numTagBins;
    protected int[] tagBin;
    protected TreebankLanguagePack tlp;
    protected boolean directional;
    protected boolean useDistance;
    protected boolean useCoarseDistance;
    protected Lexicon lex;
    protected final IntTaggedWord stopTW;
    protected final IntTaggedWord wildTW;
    protected transient Map<IntDependency, IntDependency> expandDependencyMap = Generics.newHashMap();
    private static final boolean DEBUG = false;
    protected int[] coarseDistanceBins = new int[]{0, 2, 5};
    protected int[] regDistanceBins = new int[]{0, 1, 5, 10};
    protected final Options op;
    protected transient Interner<IntTaggedWord> itwInterner = new Interner();
    private static final long serialVersionUID = 3L;

    public AbstractDependencyGrammar(TreebankLanguagePack tlp, TagProjection tagProjection, boolean directional, boolean useDistance, boolean useCoarseDistance, Options op, Index<String> wordIndex, Index<String> tagIndex) {
        this.tlp = tlp;
        this.tagProjection = tagProjection;
        this.directional = directional;
        this.useDistance = useDistance;
        this.useCoarseDistance = useCoarseDistance;
        this.op = op;
        this.wordIndex = wordIndex;
        this.tagIndex = tagIndex;
        this.stopTW = new IntTaggedWord(-2, -2);
        this.wildTW = new IntTaggedWord(-1, -1);
        this.initTagBins();
    }

    @Override
    public void setLexicon(Lexicon lexicon) {
        this.lex = lexicon;
    }

    @Override
    public void tune(Collection<Tree> trees) {
    }

    @Override
    public int numTagBins() {
        return this.numTagBins;
    }

    @Override
    public int tagBin(int tag) {
        if (tag < 0) {
            return tag;
        }
        return this.tagBin[tag];
    }

    public boolean rootTW(IntTaggedWord rTW) {
        return rTW.tag == this.tagIndex.indexOf(".$$.");
    }

    protected short valenceBin(int distance) {
        if (!this.useDistance) {
            return 0;
        }
        if (distance < 0) {
            return -1;
        }
        if (distance == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public int numDistBins() {
        return this.useCoarseDistance ? 4 : 5;
    }

    @Override
    public short distanceBin(int distance) {
        if (!this.useDistance) {
            return 0;
        }
        if (this.useCoarseDistance) {
            return this.coarseDistanceBin(distance);
        }
        return this.regDistanceBin(distance);
    }

    public short regDistanceBin(int distance) {
        for (short i = 0; i < this.regDistanceBins.length; i = (short)(i + 1)) {
            if (distance > this.regDistanceBins[i]) continue;
            return i;
        }
        return (short)this.regDistanceBins.length;
    }

    public short coarseDistanceBin(int distance) {
        for (short i = 0; i < this.coarseDistanceBins.length; i = (short)(i + 1)) {
            if (distance > this.coarseDistanceBins[i]) continue;
            return i;
        }
        return (short)this.coarseDistanceBins.length;
    }

    void setCoarseDistanceBins(int[] bins) {
        assert (bins.length == 3);
        this.coarseDistanceBins = bins;
    }

    void setRegDistanceBins(int[] bins) {
        assert (bins.length == 4);
        this.regDistanceBins = bins;
    }

    protected void initTagBins() {
        HashIndex<String> tagBinIndex = new HashIndex<String>();
        this.tagBin = new int[this.tagIndex.size()];
        for (int t = 0; t < this.tagBin.length; ++t) {
            String tagStr = this.tagIndex.get(t);
            String binStr = this.tagProjection == null ? tagStr : this.tagProjection.project(tagStr);
            this.tagBin[t] = tagBinIndex.addToIndex(binStr);
        }
        this.numTagBins = tagBinIndex.size();
    }

    @Override
    public double score(IntDependency dependency) {
        return this.scoreTB(dependency.head.word, this.tagBin(dependency.head.tag), dependency.arg.word, this.tagBin(dependency.arg.tag), dependency.leftHeaded, dependency.distance);
    }

    @Override
    public double score(int headWord, int headTag, int argWord, int argTag, boolean leftHeaded, int dist) {
        IntDependency tempDependency = new IntDependency(headWord, headTag, argWord, argTag, leftHeaded, dist);
        return this.score(tempDependency);
    }

    @Override
    public double scoreTB(int headWord, int headTag, int argWord, int argTag, boolean leftHeaded, int dist) {
        IntDependency tempDependency = new IntDependency(headWord, headTag, argWord, argTag, leftHeaded, dist);
        return this.scoreTB(tempDependency);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.itwInterner = new Interner();
    }

    @Override
    public void readData(BufferedReader in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeData(PrintWriter out2) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected IntDependency intern(IntTaggedWord headTW, IntTaggedWord argTW, boolean leftHeaded, short dist) {
        IntDependency internTempDependency;
        Map<IntDependency, IntDependency> map = this.expandDependencyMap;
        IntDependency returnDependency = internTempDependency = new IntDependency(this.itwInterner.intern(headTW), this.itwInterner.intern(argTW), leftHeaded, dist);
        if (map != null && (returnDependency = map.get(internTempDependency)) == null) {
            map.put(internTempDependency, internTempDependency);
            returnDependency = internTempDependency;
        }
        return returnDependency;
    }
}

