/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasContext;
import edu.stanford.nlp.ling.HasOffset;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.parser.KBestViterbiParser;
import edu.stanford.nlp.parser.common.ParserAnnotations;
import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.parser.lexparser.Debinarizer;
import edu.stanford.nlp.parser.lexparser.Edge;
import edu.stanford.nlp.parser.lexparser.HTKLatticeReader;
import edu.stanford.nlp.parser.lexparser.Hook;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Lattice;
import edu.stanford.nlp.parser.lexparser.LatticeEdge;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.OutsideRuleFilter;
import edu.stanford.nlp.parser.lexparser.Scorer;
import edu.stanford.nlp.parser.lexparser.TreeAnnotatorAndBinarizer;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.BinaryHeapPriorityQueue;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.PriorityQueue;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.ScoredObject;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

public class ExhaustivePCFGParser
implements Scorer,
KBestViterbiParser {
    private static Redwood.RedwoodChannels log = Redwood.channels(ExhaustivePCFGParser.class);
    protected final String goalStr;
    protected final Index<String> stateIndex;
    protected final Index<String> wordIndex;
    protected final Index<String> tagIndex;
    protected final TreeFactory tf;
    protected final BinaryGrammar bg;
    protected final UnaryGrammar ug;
    protected final Lexicon lex;
    protected final Options op;
    protected final TreebankLanguagePack tlp;
    protected OutsideRuleFilter orf;
    protected float[][][] iScore;
    protected float[][][] oScore;
    protected float bestScore;
    protected int[][][] wordsInSpan;
    protected boolean[][] oFilteredStart;
    protected boolean[][] oFilteredEnd;
    protected boolean[][] iPossibleByL;
    protected boolean[][] iPossibleByR;
    protected boolean[][] oPossibleByL;
    protected boolean[][] oPossibleByR;
    protected int[] words;
    private int[] beginOffsets;
    private int[] endOffsets;
    private CoreLabel[] originalCoreLabels;
    private HasTag[] originalTags;
    protected int length;
    protected boolean[][] tags;
    protected int myMaxLength = 559038737;
    protected final int numStates;
    protected int arraySize = 0;
    protected List<ParserConstraint> constraints = null;
    static final boolean spillGuts = false;
    static final boolean dumpTagging = false;
    private long time = System.currentTimeMillis();
    protected boolean floodTags = false;
    protected List sentence = null;
    protected Lattice lr = null;
    protected int[][] narrowLExtent;
    protected int[][] wideLExtent;
    protected int[][] narrowRExtent;
    protected int[][] wideRExtent;
    protected final boolean[] isTag;
    private static final double TOL = 1.0E-5;
    private Map<Vertex, PriorityQueue<Derivation>> cand = Generics.newHashMap();
    private Map<Vertex, LinkedList<Derivation>> dHat = Generics.newHashMap();

    private CoreLabel getCoreLabel(int labelIndex) {
        if (this.originalCoreLabels[labelIndex] != null) {
            CoreLabel terminalLabel = this.originalCoreLabels[labelIndex];
            if (terminalLabel.value() == null && terminalLabel.word() != null) {
                terminalLabel.setValue(terminalLabel.word());
            }
            return terminalLabel;
        }
        String wordStr = this.wordIndex.get(this.words[labelIndex]);
        CoreLabel terminalLabel = new CoreLabel();
        terminalLabel.setValue(wordStr);
        terminalLabel.setWord(wordStr);
        terminalLabel.setBeginPosition(this.beginOffsets[labelIndex]);
        terminalLabel.setEndPosition(this.endOffsets[labelIndex]);
        if (this.originalTags[labelIndex] != null) {
            terminalLabel.setTag(this.originalTags[labelIndex].tag());
        }
        return terminalLabel;
    }

    @Override
    public double oScore(Edge edge) {
        double oS = this.oScore[edge.start][edge.end][edge.state];
        this.op.testOptions.getClass();
        return oS;
    }

    @Override
    public double iScore(Edge edge) {
        return this.iScore[edge.start][edge.end][edge.state];
    }

    @Override
    public boolean oPossible(Hook hook) {
        return hook.isPreHook() ? this.oPossibleByR[hook.end][hook.state] : this.oPossibleByL[hook.start][hook.state];
    }

    @Override
    public boolean iPossible(Hook hook) {
        return hook.isPreHook() ? this.iPossibleByR[hook.start][hook.subState] : this.iPossibleByL[hook.end][hook.subState];
    }

    public boolean oPossibleL(int state, int start) {
        return this.oPossibleByL[start][state];
    }

    public boolean oPossibleR(int state, int end) {
        return this.oPossibleByR[end][state];
    }

    public boolean iPossibleL(int state, int start) {
        return this.iPossibleByL[start][state];
    }

    public boolean iPossibleR(int state, int end) {
        return this.iPossibleByR[end][state];
    }

    protected void buildOFilter() {
        this.oFilteredStart = new boolean[this.length][this.numStates];
        this.oFilteredEnd = new boolean[this.length + 1][this.numStates];
        this.orf.init();
        for (int start = 0; start < this.length; ++start) {
            this.orf.leftAccepting(this.oFilteredStart[start]);
            this.orf.advanceRight(this.tags[start]);
        }
        for (int end = this.length; end > 0; --end) {
            this.orf.rightAccepting(this.oFilteredEnd[end]);
            this.orf.advanceLeft(this.tags[end - 1]);
        }
    }

    public double validateBinarizedTree(Tree tree, int start) {
        double bound;
        if (tree.isLeaf()) {
            return 0.0;
        }
        float epsilon = 1.0E-4f;
        if (tree.isPreTerminal()) {
            float bound2;
            String wordStr = tree.children()[0].label().value();
            int tag = this.tagIndex.indexOf(tree.label().value());
            int word = this.wordIndex.indexOf(wordStr);
            IntTaggedWord iTW = new IntTaggedWord(word, tag);
            float score = this.lex.score(iTW, start, wordStr, null);
            if (score > (bound2 = this.iScore[start][start + 1][this.stateIndex.indexOf(tree.label().value())]) + epsilon) {
                System.out.println("Invalid tagging:");
                System.out.println("  Tag: " + tree.label().value());
                System.out.println("  Word: " + tree.children()[0].label().value());
                System.out.println("  Score: " + score);
                System.out.println("  Bound: " + bound2);
            }
            return score;
        }
        int parent = this.stateIndex.indexOf(tree.label().value());
        int firstChild = this.stateIndex.indexOf(tree.children()[0].label().value());
        if (tree.numChildren() == 1) {
            double bound3;
            UnaryRule ur = new UnaryRule(parent, firstChild);
            double score = SloppyMath.max(this.ug.scoreRule(ur), -10000.0) + this.validateBinarizedTree(tree.children()[0], start);
            if (score > (bound3 = (double)this.iScore[start][start + tree.yield().size()][parent]) + (double)epsilon) {
                System.out.println("Invalid unary:");
                System.out.println("  Parent: " + tree.label().value());
                System.out.println("  Child: " + tree.children()[0].label().value());
                System.out.println("  Start: " + start);
                System.out.println("  End: " + (start + tree.yield().size()));
                System.out.println("  Score: " + score);
                System.out.println("  Bound: " + bound3);
            }
            return score;
        }
        int secondChild = this.stateIndex.indexOf(tree.children()[1].label().value());
        BinaryRule br = new BinaryRule(parent, firstChild, secondChild);
        double score = SloppyMath.max(this.bg.scoreRule(br), -10000.0) + this.validateBinarizedTree(tree.children()[0], start) + this.validateBinarizedTree(tree.children()[1], start + tree.children()[0].yield().size());
        if (score > (bound = (double)this.iScore[start][start + tree.yield().size()][parent]) + (double)epsilon) {
            System.out.println("Invalid binary:");
            System.out.println("  Parent: " + tree.label().value());
            System.out.println("  LChild: " + tree.children()[0].label().value());
            System.out.println("  RChild: " + tree.children()[1].label().value());
            System.out.println("  Start: " + start);
            System.out.println("  End: " + (start + tree.yield().size()));
            System.out.println("  Score: " + score);
            System.out.println("  Bound: " + bound);
        }
        return score;
    }

    public Tree scoreNonBinarizedTree(Tree tree) {
        TreeAnnotatorAndBinarizer binarizer = new TreeAnnotatorAndBinarizer(this.op.tlpParams, this.op.forceCNF, !this.op.trainOptions.outsideFactor(), true, this.op);
        tree = binarizer.transformTree(tree);
        this.scoreBinarizedTree(tree, 0);
        return this.op.tlpParams.subcategoryStripper().transformTree(new Debinarizer(this.op.forceCNF).transformTree(tree));
    }

    public double scoreBinarizedTree(Tree tree, int start) {
        if (tree.isLeaf()) {
            return 0.0;
        }
        if (tree.isPreTerminal()) {
            String wordStr = tree.children()[0].label().value();
            int tag = this.tagIndex.indexOf(tree.label().value());
            int word = this.wordIndex.indexOf(wordStr);
            IntTaggedWord iTW = new IntTaggedWord(word, tag);
            float score = this.lex.score(iTW, start, wordStr, null);
            tree.setScore(score);
            return score;
        }
        int parent = this.stateIndex.indexOf(tree.label().value());
        int firstChild = this.stateIndex.indexOf(tree.children()[0].label().value());
        if (tree.numChildren() == 1) {
            UnaryRule ur = new UnaryRule(parent, firstChild);
            double score = this.ug.scoreRule(ur) + this.scoreBinarizedTree(tree.children()[0], start);
            tree.setScore(score);
            return score;
        }
        int secondChild = this.stateIndex.indexOf(tree.children()[1].label().value());
        BinaryRule br = new BinaryRule(parent, firstChild, secondChild);
        double score = this.bg.scoreRule(br) + this.scoreBinarizedTree(tree.children()[0], start) + this.scoreBinarizedTree(tree.children()[1], start + tree.children()[0].yield().size());
        tree.setScore(score);
        return score;
    }

    protected void tick(String str) {
        long time2 = System.currentTimeMillis();
        long diff = time2 - this.time;
        this.time = time2;
        log.info("done.  " + diff + "\n" + str);
    }

    @Override
    public boolean parse(List<? extends HasWord> sentence) {
        int loc;
        this.lr = null;
        if (sentence != this.sentence) {
            this.sentence = sentence;
            this.floodTags = false;
        }
        if (this.op.testOptions.verbose) {
            Timing.tick("Starting pcfg parse.");
        }
        this.length = sentence.size();
        if (this.length > this.arraySize) {
            this.considerCreatingArrays(this.length);
        }
        int goal = this.stateIndex.indexOf(this.goalStr);
        if (this.op.testOptions.verbose) {
            log.info("Initializing PCFG...");
        }
        this.words = new int[this.length];
        this.beginOffsets = new int[this.length];
        this.endOffsets = new int[this.length];
        this.originalCoreLabels = new CoreLabel[this.length];
        this.originalTags = new HasTag[this.length];
        int unk = 0;
        StringBuilder unkWords = new StringBuilder("[");
        for (int i = 0; i < this.length; ++i) {
            HasTag tag;
            String s = sentence.get(i).word();
            if (sentence.get(i) instanceof HasOffset) {
                HasOffset word = (HasOffset)((Object)sentence.get(i));
                this.beginOffsets[i] = word.beginPosition();
                this.endOffsets[i] = word.endPosition();
            } else {
                this.beginOffsets[i] = i == 0 ? 0 : this.endOffsets[i - 1] + 1;
                this.endOffsets[i] = this.beginOffsets[i] + s.length();
            }
            if (sentence.get(i) instanceof CoreLabel) {
                this.originalCoreLabels[i] = (CoreLabel)sentence.get(i);
            }
            if (sentence.get(i) instanceof HasTag && (tag = (HasTag)((Object)sentence.get(i))).tag() != null) {
                this.originalTags[i] = tag;
            }
            if (!(!this.op.testOptions.verbose || this.wordIndex.contains(s) && this.lex.isKnown(this.wordIndex.indexOf(s)))) {
                ++unk;
                unkWords.append(' ');
                unkWords.append(s);
                unkWords.append(" { ");
                for (int jj = 0; jj < s.length(); ++jj) {
                    char ch = s.charAt(jj);
                    unkWords.append(Character.getType(ch)).append(" ");
                }
                unkWords.append("}");
            }
            this.words[i] = this.wordIndex.addToIndex(s);
        }
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                Arrays.fill(this.iScore[start][end], Float.NEGATIVE_INFINITY);
                if (this.op.doDep && !this.op.testOptions.useFastFactored) {
                    Arrays.fill(this.oScore[start][end], Float.NEGATIVE_INFINITY);
                }
                if (!this.op.testOptions.lengthNormalization) continue;
                Arrays.fill(this.wordsInSpan[start][end], 1);
            }
        }
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        for (loc = 0; loc <= this.length; ++loc) {
            Arrays.fill(this.narrowLExtent[loc], -1);
            Arrays.fill(this.wideLExtent[loc], this.length + 1);
        }
        for (loc = 0; loc < this.length; ++loc) {
            Arrays.fill(this.narrowRExtent[loc], this.length + 1);
            Arrays.fill(this.wideRExtent[loc], -1);
        }
        if (this.op.testOptions.verbose) {
            Timing.tick("done.");
            unkWords.append(" ]");
            this.op.tlpParams.pw(System.err).println("Unknown words: " + unk + " " + unkWords);
            log.info("Starting filters...");
        }
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        this.initializeChart(sentence);
        if (this.op.testOptions.verbose) {
            Timing.tick("done.");
            log.info("Starting insides...");
        }
        this.doInsideScores();
        if (this.op.testOptions.verbose) {
            Timing.tick("done.");
            System.out.println("PCFG parsing " + this.length + " words (incl. stop): insideScore = " + this.iScore[0][this.length][goal]);
        }
        this.bestScore = this.iScore[0][this.length][goal];
        boolean succeeded = this.hasParse();
        if (this.op.testOptions.doRecovery && !succeeded && !this.floodTags) {
            this.floodTags = true;
            return this.parse(sentence);
        }
        if (!this.op.doDep || this.op.testOptions.useFastFactored) {
            return succeeded;
        }
        if (this.op.testOptions.verbose) {
            log.info("Starting outsides...");
        }
        this.oScore[0][this.length][goal] = 0.0f;
        this.doOutsideScores();
        if (this.op.testOptions.verbose) {
            Timing.tick("done.");
        }
        if (this.op.doDep) {
            this.initializePossibles();
        }
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        return succeeded;
    }

    public boolean parse(HTKLatticeReader lr) {
        System.err.printf("%s: HTK lattice parsing presently disabled.\n", this.getClass().getName());
        return false;
    }

    public boolean parse(Lattice lr) {
        boolean succeeded;
        int loc;
        this.sentence = null;
        if (lr != this.lr) {
            this.lr = lr;
            this.floodTags = false;
        }
        if (this.op.testOptions.verbose) {
            Timing.tick("Doing lattice PCFG parse...");
        }
        this.length = lr.getNumNodes() - 1;
        if (this.length > this.arraySize) {
            this.considerCreatingArrays(this.length);
        }
        int goal = this.stateIndex.indexOf(this.goalStr);
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                Arrays.fill(this.iScore[start][end], Float.NEGATIVE_INFINITY);
                if (!this.op.doDep) continue;
                Arrays.fill(this.oScore[start][end], Float.NEGATIVE_INFINITY);
            }
        }
        for (loc = 0; loc <= this.length; ++loc) {
            Arrays.fill(this.narrowLExtent[loc], -1);
            Arrays.fill(this.wideLExtent[loc], this.length + 1);
        }
        for (loc = 0; loc < this.length; ++loc) {
            Arrays.fill(this.narrowRExtent[loc], this.length + 1);
            Arrays.fill(this.wideRExtent[loc], -1);
        }
        this.initializeChart(lr);
        this.doInsideScores();
        this.bestScore = this.iScore[0][this.length][goal];
        if (this.op.testOptions.verbose) {
            Timing.tick("done.");
            log.info("PCFG " + this.length + " words (incl. stop) iScore " + this.bestScore);
        }
        if (!(succeeded = this.hasParse()) && this.op.testOptions.doRecovery && !this.floodTags) {
            this.floodTags = true;
            System.err.printf(this.getClass().getName() + ": Parse failed. Trying recovery parse...", new Object[0]);
            succeeded = this.parse(lr);
            if (!succeeded) {
                return false;
            }
        }
        this.oScore[0][this.length][goal] = 0.0f;
        this.doOutsideScores();
        if (this.op.testOptions.verbose) {
            Timing.tick("done.");
        }
        if (this.op.doDep) {
            this.initializePossibles();
        }
        return succeeded;
    }

    protected void initializePossibles() {
        int loc;
        for (loc = 0; loc < this.length; ++loc) {
            Arrays.fill(this.iPossibleByL[loc], false);
            Arrays.fill(this.oPossibleByL[loc], false);
        }
        for (loc = 0; loc <= this.length; ++loc) {
            Arrays.fill(this.iPossibleByR[loc], false);
            Arrays.fill(this.oPossibleByR[loc], false);
        }
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                for (int state = 0; state < this.numStates; ++state) {
                    if (!(this.iScore[start][end][state] > Float.NEGATIVE_INFINITY) || !(this.oScore[start][end][state] > Float.NEGATIVE_INFINITY)) continue;
                    this.iPossibleByL[start][state] = true;
                    this.iPossibleByR[end][state] = true;
                    this.oPossibleByL[start][state] = true;
                    this.oPossibleByR[end][state] = true;
                }
            }
        }
    }

    private void doOutsideScores() {
        for (int diff = this.length; diff >= 1; --diff) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            int start = 0;
            while (start + diff <= this.length) {
                float totR;
                float totL;
                float rS;
                float lS;
                int split;
                int max2;
                int min;
                int max;
                float oS;
                Comparable<UnaryRule>[] rules;
                int s;
                int end = start + diff;
                for (s = 0; s < this.numStates; ++s) {
                    float oS2 = this.oScore[start][end][s];
                    if (oS2 == Float.NEGATIVE_INFINITY) continue;
                    rules = this.ug.closedRulesByParent(s);
                    for (Comparable<UnaryRule> ur : rules) {
                        float pS = ((UnaryRule)ur).score;
                        float tot = oS2 + pS;
                        if (!(tot > this.oScore[start][end][((UnaryRule)ur).child]) || !(this.iScore[start][end][((UnaryRule)ur).child] > Float.NEGATIVE_INFINITY)) continue;
                        this.oScore[start][end][((UnaryRule)ur).child] = tot;
                    }
                }
                for (s = 0; s < this.numStates; ++s) {
                    int min1 = this.narrowRExtent[start][s];
                    if (end < min1) continue;
                    rules = this.bg.splitRulesWithLC(s);
                    for (Comparable<UnaryRule> br : rules) {
                        int max1;
                        oS = this.oScore[start][end][((BinaryRule)br).parent];
                        if (oS == Float.NEGATIVE_INFINITY || (max1 = this.narrowLExtent[end][((BinaryRule)br).rightChild]) < min1) continue;
                        max = max1;
                        min = min1;
                        if (max - min > 2) {
                            int min2 = this.wideLExtent[end][((BinaryRule)br).rightChild];
                            int n = min = min1 > min2 ? min1 : min2;
                            if (max1 < min) continue;
                            max2 = this.wideRExtent[start][((BinaryRule)br).leftChild];
                            int n2 = max = max1 < max2 ? max1 : max2;
                            if (max < min) continue;
                        }
                        float pS = ((BinaryRule)br).score;
                        for (split = min; split <= max; ++split) {
                            lS = this.iScore[start][split][((BinaryRule)br).leftChild];
                            if (lS == Float.NEGATIVE_INFINITY || (rS = this.iScore[split][end][((BinaryRule)br).rightChild]) == Float.NEGATIVE_INFINITY) continue;
                            totL = pS + rS + oS;
                            if (totL > this.oScore[start][split][((BinaryRule)br).leftChild]) {
                                this.oScore[start][split][((BinaryRule)br).leftChild] = totL;
                            }
                            if (!((totR = pS + lS + oS) > this.oScore[split][end][((BinaryRule)br).rightChild])) continue;
                            this.oScore[split][end][((BinaryRule)br).rightChild] = totR;
                        }
                    }
                }
                for (s = 0; s < this.numStates; ++s) {
                    int max1 = this.narrowLExtent[end][s];
                    if (max1 < start) continue;
                    rules = this.bg.splitRulesWithRC(s);
                    for (Comparable<UnaryRule> br : rules) {
                        int min1;
                        oS = this.oScore[start][end][((BinaryRule)br).parent];
                        if (oS == Float.NEGATIVE_INFINITY || max1 < (min1 = this.narrowRExtent[start][((BinaryRule)br).leftChild])) continue;
                        max = max1;
                        min = min1;
                        if (max - min > 2) {
                            int min2 = this.wideLExtent[end][((BinaryRule)br).rightChild];
                            int n = min = min1 > min2 ? min1 : min2;
                            if (max1 < min) continue;
                            max2 = this.wideRExtent[start][((BinaryRule)br).leftChild];
                            int n3 = max = max1 < max2 ? max1 : max2;
                            if (max < min) continue;
                        }
                        float pS = ((BinaryRule)br).score;
                        for (split = min; split <= max; ++split) {
                            lS = this.iScore[start][split][((BinaryRule)br).leftChild];
                            if (lS == Float.NEGATIVE_INFINITY || (rS = this.iScore[split][end][((BinaryRule)br).rightChild]) == Float.NEGATIVE_INFINITY) continue;
                            totL = pS + rS + oS;
                            if (totL > this.oScore[start][split][((BinaryRule)br).leftChild]) {
                                this.oScore[start][split][((BinaryRule)br).leftChild] = totL;
                            }
                            if (!((totR = pS + lS + oS) > this.oScore[split][end][((BinaryRule)br).rightChild])) continue;
                            this.oScore[split][end][((BinaryRule)br).rightChild] = totR;
                        }
                    }
                }
                ++start;
            }
        }
    }

    void doInsideScores() {
        for (int diff = 2; diff <= this.length; ++diff) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            for (int start = 0; start < (diff == this.length ? 1 : this.length - diff); ++start) {
                this.doInsideChartCell(diff, start);
            }
        }
    }

    private void doInsideChartCell(int diff, int start) {
        int newWordsInSpan;
        float tot;
        float normTot;
        int bestWordsInSpan;
        boolean foundBetter;
        int split;
        float bestIScore;
        float oldIScore;
        int parentState;
        float pS;
        int max;
        int max1;
        int min;
        int min2;
        boolean lengthNormalization = this.op.testOptions.lengthNormalization;
        int end = start + diff;
        List<ParserConstraint> constraints = this.getConstraints();
        if (constraints != null) {
            for (ParserConstraint c : constraints) {
                if ((start <= c.start || start >= c.end || end <= c.end) && (end <= c.start || end >= c.end || start >= c.start)) continue;
                return;
            }
        }
        int[] narrowRExtent_start = this.narrowRExtent[start];
        int[] wideRExtent_start = this.wideRExtent[start];
        int[] narrowLExtent_end = this.narrowLExtent[end];
        int[] wideLExtent_end = this.wideLExtent[end];
        float[][] iScore_start = this.iScore[start];
        float[] iScore_start_end = iScore_start[end];
        for (int leftState = 0; leftState < this.numStates; ++leftState) {
            int narrowR = narrowRExtent_start[leftState];
            if (narrowR >= end) continue;
            BinaryRule[] leftRules = this.bg.splitRulesWithLC(leftState);
            for (BinaryRule binaryRule : leftRules) {
                int rightChild = binaryRule.rightChild;
                int narrowL = narrowLExtent_end[rightChild];
                if (narrowL < narrowR) continue;
                min2 = wideLExtent_end[rightChild];
                min = narrowR > min2 ? narrowR : min2;
                max1 = wideRExtent_start[leftState];
                int n = max = max1 < narrowL ? max1 : narrowL;
                if (min > max) continue;
                pS = binaryRule.score;
                parentState = binaryRule.parent;
                bestIScore = oldIScore = iScore_start_end[parentState];
                if (!lengthNormalization) {
                    for (split = min; split <= max; ++split) {
                        float tot2;
                        float rS;
                        float lS;
                        if (constraints != null) {
                            boolean skip = false;
                            for (ParserConstraint c : constraints) {
                                String tag;
                                Matcher m;
                                if ((start < c.start && end >= c.end || start <= c.start && end > c.end) && split > c.start && split < c.end) {
                                    skip = true;
                                    break;
                                }
                                if (start == c.start && split == c.end && !(m = c.state.matcher(tag = this.stateIndex.get(leftState))).matches()) {
                                    skip = true;
                                    break;
                                }
                                if (split != c.start || end != c.end || (m = c.state.matcher(tag = this.stateIndex.get(rightChild))).matches()) continue;
                                skip = true;
                                break;
                            }
                            if (skip) continue;
                        }
                        if ((lS = iScore_start[split][leftState]) == Float.NEGATIVE_INFINITY || (rS = this.iScore[split][end][rightChild]) == Float.NEGATIVE_INFINITY || !((tot2 = pS + lS + rS) > bestIScore)) continue;
                        bestIScore = tot2;
                    }
                    foundBetter = bestIScore > oldIScore;
                } else {
                    float oldNormIScore;
                    bestWordsInSpan = this.wordsInSpan[start][end][parentState];
                    float bestNormIScore = oldNormIScore = oldIScore / (float)bestWordsInSpan;
                    for (int split2 = min; split2 <= max; ++split2) {
                        float rS;
                        float lS = iScore_start[split2][leftState];
                        if (lS == Float.NEGATIVE_INFINITY || (rS = this.iScore[split2][end][rightChild]) == Float.NEGATIVE_INFINITY || !((normTot = (tot = pS + lS + rS) / (float)(newWordsInSpan = this.wordsInSpan[start][split2][leftState] + this.wordsInSpan[split2][end][rightChild])) > bestNormIScore)) continue;
                        bestIScore = tot;
                        bestNormIScore = normTot;
                        bestWordsInSpan = newWordsInSpan;
                    }
                    boolean bl = foundBetter = bestNormIScore > oldNormIScore;
                    if (foundBetter) {
                        this.wordsInSpan[start][end][parentState] = bestWordsInSpan;
                    }
                }
                if (!foundBetter) continue;
                iScore_start_end[parentState] = bestIScore;
                if (oldIScore != Float.NEGATIVE_INFINITY) continue;
                if (start > narrowLExtent_end[parentState]) {
                    narrowLExtent_end[parentState] = wideLExtent_end[parentState] = start;
                } else if (start < wideLExtent_end[parentState]) {
                    wideLExtent_end[parentState] = start;
                }
                if (end < narrowRExtent_start[parentState]) {
                    narrowRExtent_start[parentState] = wideRExtent_start[parentState] = end;
                    continue;
                }
                if (end <= wideRExtent_start[parentState]) continue;
                wideRExtent_start[parentState] = end;
            }
        }
        for (int rightState = 0; rightState < this.numStates; ++rightState) {
            int narrowL = narrowLExtent_end[rightState];
            if (narrowL <= start) continue;
            BinaryRule[] rightRules = this.bg.splitRulesWithRC(rightState);
            for (Comparable<BinaryRule> comparable : rightRules) {
                int leftChild = ((BinaryRule)comparable).leftChild;
                int narrowR = narrowRExtent_start[leftChild];
                if (narrowR > narrowL) continue;
                min2 = wideLExtent_end[rightState];
                min = narrowR > min2 ? narrowR : min2;
                max1 = wideRExtent_start[leftChild];
                int n = max = max1 < narrowL ? max1 : narrowL;
                if (min > max) continue;
                pS = ((BinaryRule)comparable).score;
                parentState = ((BinaryRule)comparable).parent;
                bestIScore = oldIScore = iScore_start_end[parentState];
                if (!lengthNormalization) {
                    for (split = min; split <= max; ++split) {
                        float tot3;
                        float rS;
                        float lS;
                        if (constraints != null) {
                            boolean skip = false;
                            for (ParserConstraint c : constraints) {
                                String tag;
                                Matcher m;
                                if ((start < c.start && end >= c.end || start <= c.start && end > c.end) && split > c.start && split < c.end) {
                                    skip = true;
                                    break;
                                }
                                if (start == c.start && split == c.end && !(m = c.state.matcher(tag = this.stateIndex.get(leftChild))).matches()) {
                                    skip = true;
                                    break;
                                }
                                if (split != c.start || end != c.end || (m = c.state.matcher(tag = this.stateIndex.get(rightState))).matches()) continue;
                                skip = true;
                                break;
                            }
                            if (skip) continue;
                        }
                        if ((lS = iScore_start[split][leftChild]) == Float.NEGATIVE_INFINITY || (rS = this.iScore[split][end][rightState]) == Float.NEGATIVE_INFINITY || !((tot3 = pS + lS + rS) > bestIScore)) continue;
                        bestIScore = tot3;
                    }
                    foundBetter = bestIScore > oldIScore;
                } else {
                    float oldNormIScore;
                    bestWordsInSpan = this.wordsInSpan[start][end][parentState];
                    float bestNormIScore = oldNormIScore = oldIScore / (float)bestWordsInSpan;
                    for (int split3 = min; split3 <= max; ++split3) {
                        float rS;
                        float lS = iScore_start[split3][leftChild];
                        if (lS == Float.NEGATIVE_INFINITY || (rS = this.iScore[split3][end][rightState]) == Float.NEGATIVE_INFINITY || !((normTot = (tot = pS + lS + rS) / (float)(newWordsInSpan = this.wordsInSpan[start][split3][leftChild] + this.wordsInSpan[split3][end][rightState])) > bestNormIScore)) continue;
                        bestIScore = tot;
                        bestNormIScore = normTot;
                        bestWordsInSpan = newWordsInSpan;
                    }
                    boolean bl = foundBetter = bestNormIScore > oldNormIScore;
                    if (foundBetter) {
                        this.wordsInSpan[start][end][parentState] = bestWordsInSpan;
                    }
                }
                if (!foundBetter) continue;
                iScore_start_end[parentState] = bestIScore;
                if (oldIScore != Float.NEGATIVE_INFINITY) continue;
                if (start > narrowLExtent_end[parentState]) {
                    narrowLExtent_end[parentState] = wideLExtent_end[parentState] = start;
                } else if (start < wideLExtent_end[parentState]) {
                    wideLExtent_end[parentState] = start;
                }
                if (end < narrowRExtent_start[parentState]) {
                    narrowRExtent_start[parentState] = wideRExtent_start[parentState] = end;
                    continue;
                }
                if (end <= wideRExtent_start[parentState]) continue;
                wideRExtent_start[parentState] = end;
            }
        }
        for (int state = 0; state < this.numStates; ++state) {
            float iS = iScore_start_end[state];
            if (iS == Float.NEGATIVE_INFINITY) continue;
            UnaryRule[] unaries = this.ug.closedRulesByChild(state);
            for (Comparable<BinaryRule> comparable : unaries) {
                boolean foundBetter2;
                if (constraints != null) {
                    boolean skip = false;
                    for (ParserConstraint c : constraints) {
                        String tag;
                        Matcher m;
                        if (start != c.start || end != c.end || (m = c.state.matcher(tag = this.stateIndex.get(((UnaryRule)comparable).parent))).matches()) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                int parentState2 = ((UnaryRule)comparable).parent;
                float pS2 = ((UnaryRule)comparable).score;
                float tot4 = iS + pS2;
                float cur = iScore_start_end[parentState2];
                if (lengthNormalization) {
                    boolean foundBetter3;
                    int totWordsInSpan = this.wordsInSpan[start][end][state];
                    float normTot2 = tot4 / (float)totWordsInSpan;
                    int curWordsInSpan = this.wordsInSpan[start][end][parentState2];
                    float normCur = cur / (float)curWordsInSpan;
                    boolean bl = foundBetter3 = normTot2 > normCur;
                    if (foundBetter3) {
                        this.wordsInSpan[start][end][parentState2] = this.wordsInSpan[start][end][state];
                    }
                } else {
                    boolean bl = foundBetter2 = tot4 > cur;
                }
                if (!foundBetter2) continue;
                iScore_start_end[parentState2] = tot4;
                if (cur != Float.NEGATIVE_INFINITY) continue;
                if (start > narrowLExtent_end[parentState2]) {
                    narrowLExtent_end[parentState2] = wideLExtent_end[parentState2] = start;
                } else if (start < wideLExtent_end[parentState2]) {
                    wideLExtent_end[parentState2] = start;
                }
                if (end < narrowRExtent_start[parentState2]) {
                    narrowRExtent_start[parentState2] = wideRExtent_start[parentState2] = end;
                    continue;
                }
                if (end <= wideRExtent_start[parentState2]) continue;
                wideRExtent_start[parentState2] = end;
            }
        }
    }

    private void initializeChart(Lattice lr) {
        for (LatticeEdge edge : lr) {
            int state;
            int start = edge.start;
            int end = edge.end;
            String word = edge.word;
            for (state = 0; state < this.numStates; ++state) {
                IntTaggedWord itw;
                float newScore;
                if (!this.isTag[state] || !((newScore = this.lex.score(itw = new IntTaggedWord(word, this.stateIndex.get(state), this.wordIndex, this.tagIndex), start, word, null) + (float)edge.weight) > this.iScore[start][end][state])) continue;
                this.iScore[start][end][state] = newScore;
                this.narrowRExtent[start][state] = Math.min(end, this.narrowRExtent[start][state]);
                this.narrowLExtent[end][state] = Math.max(start, this.narrowLExtent[end][state]);
                this.wideRExtent[start][state] = Math.max(end, this.wideRExtent[start][state]);
                this.wideLExtent[end][state] = Math.min(start, this.wideLExtent[end][state]);
            }
            if (this.floodTags && !this.op.testOptions.noRecoveryTagging) {
                for (state = 0; state < this.numStates; ++state) {
                    float iS = this.iScore[start][end][state];
                    if (!this.isTag[state] || iS != Float.NEGATIVE_INFINITY) continue;
                    this.iScore[start][end][state] = -1000.0f + (float)edge.weight;
                    this.narrowRExtent[start][state] = end;
                    this.narrowLExtent[end][state] = start;
                    this.wideRExtent[start][state] = end;
                    this.wideLExtent[end][state] = start;
                }
            }
            for (state = 0; state < this.numStates; ++state) {
                UnaryRule[] unaries;
                float iS = this.iScore[start][end][state];
                if (iS == Float.NEGATIVE_INFINITY) continue;
                for (UnaryRule ur : unaries = this.ug.closedRulesByChild(state)) {
                    float pS = ur.score;
                    float tot = iS + pS;
                    int parentState = ur.parent;
                    if (!(tot > this.iScore[start][end][parentState])) continue;
                    this.iScore[start][end][parentState] = tot;
                    this.narrowRExtent[start][parentState] = Math.min(end, this.narrowRExtent[start][parentState]);
                    this.narrowLExtent[end][parentState] = Math.max(start, this.narrowLExtent[end][parentState]);
                    this.wideRExtent[start][parentState] = Math.max(end, this.wideRExtent[start][parentState]);
                    this.wideLExtent[end][parentState] = Math.min(start, this.wideLExtent[end][parentState]);
                }
            }
        }
    }

    private void initializeChart(List<? extends HasWord> sentence) {
        int boundary = this.wordIndex.indexOf(".$.");
        for (int start = 0; start < this.length; ++start) {
            if (this.op.testOptions.maxSpanForTags > 1) {
                for (int end = start + 1; end < this.length - 1 && end - start <= this.op.testOptions.maxSpanForTags || start + 1 == end; ++end) {
                    StringBuilder word = new StringBuilder();
                    for (int i = start; i < end; ++i) {
                        if (sentence.get(i) instanceof HasWord) {
                            HasWord cl = sentence.get(i);
                            word.append(cl.word());
                            continue;
                        }
                        word.append(sentence.get(i).toString());
                    }
                    for (int state = 0; state < this.numStates; ++state) {
                        float iS = this.iScore[start][end][state];
                        if (iS != Float.NEGATIVE_INFINITY || !this.isTag[state]) continue;
                        IntTaggedWord itw = new IntTaggedWord(word.toString(), this.stateIndex.get(state), this.wordIndex, this.tagIndex);
                        this.iScore[start][end][state] = this.lex.score(itw, start, word.toString(), null);
                        if (!(this.iScore[start][end][state] > Float.NEGATIVE_INFINITY)) continue;
                        this.narrowRExtent[start][state] = start + 1;
                        this.narrowLExtent[end][state] = end - 1;
                        this.wideRExtent[start][state] = start + 1;
                        this.wideLExtent[end][state] = end - 1;
                    }
                }
                continue;
            }
            int word = this.words[start];
            int end = start + 1;
            Arrays.fill(this.tags[start], false);
            float[] iScore_start_end = this.iScore[start][end];
            int[] narrowRExtent_start = this.narrowRExtent[start];
            int[] narrowLExtent_end = this.narrowLExtent[end];
            int[] wideRExtent_start = this.wideRExtent[start];
            int[] wideLExtent_end = this.wideLExtent[end];
            String trueTagStr = null;
            if (sentence.get(start) instanceof HasTag && "".equals(trueTagStr = ((HasTag)((Object)sentence.get(start))).tag())) {
                trueTagStr = null;
            }
            String candidateTagRegex = null;
            if (sentence.get(start) instanceof CoreLabel && "".equals(candidateTagRegex = (String)((CoreLabel)sentence.get(start)).get(ParserAnnotations.CandidatePartOfSpeechAnnotation.class))) {
                candidateTagRegex = null;
            }
            String wordContextStr = null;
            if (sentence.get(start) instanceof HasContext && "".equals(wordContextStr = ((HasContext)((Object)sentence.get(start))).originalText())) {
                wordContextStr = null;
            }
            boolean assignedSomeTag = false;
            if (!this.floodTags || word == boundary) {
                Iterator<IntTaggedWord> taggingI = this.lex.ruleIteratorByWord(word, start, wordContextStr);
                while (taggingI.hasNext()) {
                    IntTaggedWord tagging = taggingI.next();
                    int state = this.stateIndex.indexOf(this.tagIndex.get(tagging.tag));
                    if (trueTagStr != null && (!this.op.testOptions.forceTagBeginnings && !this.tlp.basicCategory(tagging.tagString(this.tagIndex)).equals(trueTagStr) || this.op.testOptions.forceTagBeginnings && !tagging.tagString(this.tagIndex).startsWith(trueTagStr)) || candidateTagRegex != null && (!this.op.testOptions.forceTagBeginnings && !this.tlp.basicCategory(tagging.tagString(this.tagIndex)).matches(candidateTagRegex) || this.op.testOptions.forceTagBeginnings && !tagging.tagString(this.tagIndex).matches(candidateTagRegex))) continue;
                    float lexScore = this.lex.score(tagging, start, this.wordIndex.get(tagging.word), wordContextStr);
                    if (lexScore > Float.NEGATIVE_INFINITY) {
                        assignedSomeTag = true;
                        iScore_start_end[state] = lexScore;
                        narrowRExtent_start[state] = end;
                        narrowLExtent_end[state] = start;
                        wideRExtent_start[state] = end;
                        wideLExtent_end[state] = start;
                    }
                    short tag = tagging.tag;
                    this.tags[start][tag] = true;
                }
            }
            if (!assignedSomeTag) {
                for (int state = 0; state < this.numStates; ++state) {
                    String tagString;
                    String tagString2;
                    if (!this.isTag[state] || iScore_start_end[state] != Float.NEGATIVE_INFINITY || trueTagStr != null && !this.tlp.basicCategory(tagString2 = this.stateIndex.get(state)).equals(trueTagStr)) continue;
                    float lexScore = this.lex.score(new IntTaggedWord(word, this.tagIndex.indexOf(this.stateIndex.get(state))), start, this.wordIndex.get(word), wordContextStr);
                    if (candidateTagRegex != null && !this.tlp.basicCategory(tagString = this.stateIndex.get(state)).matches(candidateTagRegex) || !(lexScore > Float.NEGATIVE_INFINITY)) continue;
                    iScore_start_end[state] = lexScore;
                    narrowRExtent_start[state] = end;
                    narrowLExtent_end[state] = start;
                    wideRExtent_start[state] = end;
                    wideLExtent_end[state] = start;
                }
            }
            if (this.op.dcTags) {
                for (int state = 0; state < this.numStates; ++state) {
                    if (!this.isTag[state]) continue;
                    int n = state;
                    iScore_start_end[n] = (float)((double)iScore_start_end[n] * (1.0 + this.op.testOptions.depWeight));
                }
            }
            if (this.floodTags && !this.op.testOptions.noRecoveryTagging && word != boundary) {
                for (int state = 0; state < this.numStates; ++state) {
                    if (!this.isTag[state] || iScore_start_end[state] != Float.NEGATIVE_INFINITY) continue;
                    iScore_start_end[state] = -1000.0f;
                    narrowRExtent_start[state] = end;
                    narrowLExtent_end[state] = start;
                    wideRExtent_start[state] = end;
                    wideLExtent_end[state] = start;
                }
            }
            for (int state = 0; state < this.numStates; ++state) {
                UnaryRule[] unaries;
                float iS = iScore_start_end[state];
                if (iS == Float.NEGATIVE_INFINITY) continue;
                for (UnaryRule ur : unaries = this.ug.closedRulesByChild(state)) {
                    float pS = ur.score;
                    float tot = iS + pS;
                    int parentState = ur.parent;
                    if (!(tot > iScore_start_end[parentState])) continue;
                    iScore_start_end[parentState] = tot;
                    narrowRExtent_start[parentState] = end;
                    narrowLExtent_end[parentState] = start;
                    wideRExtent_start[parentState] = end;
                    wideLExtent_end[parentState] = start;
                }
            }
        }
    }

    @Override
    public boolean hasParse() {
        return this.getBestScore() > Double.NEGATIVE_INFINITY;
    }

    protected static boolean matches(double x, double y) {
        return Math.abs(x - y) / (Math.abs(x) + Math.abs(y) + 1.0E-10) < 1.0E-5;
    }

    @Override
    public double getBestScore() {
        return this.getBestScore(this.goalStr);
    }

    public double getBestScore(String stateName) {
        if (this.length > this.arraySize) {
            return Double.NEGATIVE_INFINITY;
        }
        if (!this.stateIndex.contains(stateName)) {
            return Double.NEGATIVE_INFINITY;
        }
        int goal = this.stateIndex.indexOf(stateName);
        if (this.iScore == null || this.iScore.length == 0 || this.iScore[0].length <= this.length || this.iScore[0][this.length].length <= goal) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.iScore[0][this.length][goal];
    }

    @Override
    public Tree getBestParse() {
        Tree internalTree = this.extractBestParse(this.goalStr, 0, this.length);
        if (internalTree == null) {
            log.info("Warning: no parse found in ExhaustivePCFGParser.extractBestParse");
        }
        return internalTree;
    }

    protected Tree extractBestParse(String goalStr, int start, int end) {
        return this.extractBestParse(this.stateIndex.indexOf(goalStr), start, end);
    }

    private Tree extractBestParse(int goal, int start, int end) {
        double bestScore = this.iScore[start][end][goal];
        double normBestScore = this.op.testOptions.lengthNormalization ? bestScore / (double)this.wordsInSpan[start][end][goal] : bestScore;
        String goalStr = this.stateIndex.get(goal);
        if (end - start <= this.op.testOptions.maxSpanForTags && this.tagIndex.contains(goalStr)) {
            if (this.op.testOptions.maxSpanForTags > 1) {
                Tree wordNode = null;
                if (this.sentence != null) {
                    StringBuilder word = new StringBuilder();
                    for (int i = start; i < end; ++i) {
                        if (this.sentence.get(i) instanceof HasWord) {
                            HasWord cl = (HasWord)this.sentence.get(i);
                            word.append(cl.word());
                            continue;
                        }
                        word.append(this.sentence.get(i).toString());
                    }
                    wordNode = this.tf.newLeaf(word.toString());
                } else if (this.lr != null) {
                    List<LatticeEdge> latticeEdges = this.lr.getEdgesOverSpan(start, end);
                    for (LatticeEdge edge : latticeEdges) {
                        IntTaggedWord itw = new IntTaggedWord(edge.word, this.stateIndex.get(goal), this.wordIndex, this.tagIndex);
                        float tagScore = this.floodTags ? -1000.0f : this.lex.score(itw, start, edge.word, null);
                        if (!ExhaustivePCFGParser.matches(bestScore, tagScore + (float)edge.weight)) continue;
                        wordNode = this.tf.newLeaf(edge.word);
                        if (!(wordNode.label() instanceof CoreLabel)) break;
                        CoreLabel cl = (CoreLabel)wordNode.label();
                        cl.setBeginPosition(start);
                        cl.setEndPosition(end);
                        break;
                    }
                    if (wordNode == null) {
                        throw new RuntimeException("could not find matching word from lattice in parse reconstruction");
                    }
                } else {
                    throw new RuntimeException("attempt to get word when sentence and lattice are null!");
                }
                Tree tagNode = this.tf.newTreeNode(goalStr, Collections.singletonList(wordNode));
                tagNode.setScore(bestScore);
                if (this.originalTags[start] != null) {
                    tagNode.label().setValue(this.originalTags[start].tag());
                }
                return tagNode;
            }
            IntTaggedWord tagging = new IntTaggedWord(this.words[start], this.tagIndex.indexOf(goalStr));
            String contextStr = this.getCoreLabel(start).originalText();
            float tagScore = this.lex.score(tagging, start, this.wordIndex.get(this.words[start]), contextStr);
            if (tagScore > Float.NEGATIVE_INFINITY || this.floodTags) {
                CoreLabel terminalLabel = this.getCoreLabel(start);
                Tree wordNode = this.tf.newLeaf(terminalLabel);
                Tree tagNode = this.tf.newTreeNode(goalStr, Collections.singletonList(wordNode));
                tagNode.setScore(bestScore);
                if (terminalLabel.tag() != null) {
                    tagNode.label().setValue(terminalLabel.tag());
                }
                if (tagNode.label() instanceof HasTag) {
                    ((HasTag)((Object)tagNode.label())).setTag(tagNode.label().value());
                }
                return tagNode;
            }
        }
        for (int split = start + 1; split < end; ++split) {
            Iterator<BinaryRule> binaryI = this.bg.ruleIteratorByParent(goal);
            while (binaryI.hasNext()) {
                boolean matches;
                BinaryRule br = binaryI.next();
                double score = br.score + this.iScore[start][split][br.leftChild] + this.iScore[split][end][br.rightChild];
                if (this.op.testOptions.lengthNormalization) {
                    double normScore = score / (double)(this.wordsInSpan[start][split][br.leftChild] + this.wordsInSpan[split][end][br.rightChild]);
                    matches = ExhaustivePCFGParser.matches(normScore, normBestScore);
                } else {
                    matches = ExhaustivePCFGParser.matches(score, bestScore);
                }
                if (!matches) continue;
                Tree leftChildTree = this.extractBestParse(br.leftChild, start, split);
                Tree rightChildTree = this.extractBestParse(br.rightChild, split, end);
                ArrayList<Tree> children = new ArrayList<Tree>();
                children.add(leftChildTree);
                children.add(rightChildTree);
                Tree result = this.tf.newTreeNode(goalStr, children);
                result.setScore(score);
                return result;
            }
        }
        Iterator<UnaryRule> unaryI = this.ug.ruleIteratorByParent(goal);
        while (unaryI.hasNext()) {
            boolean matches;
            UnaryRule ur = unaryI.next();
            double score = ur.score + this.iScore[start][end][ur.child];
            if (this.op.testOptions.lengthNormalization) {
                double normScore = score / (double)this.wordsInSpan[start][end][ur.child];
                matches = ExhaustivePCFGParser.matches(normScore, normBestScore);
            } else {
                matches = ExhaustivePCFGParser.matches(score, bestScore);
            }
            if (ur.child == ur.parent || !matches) continue;
            Tree childTree = this.extractBestParse(ur.child, start, end);
            Tree result = this.tf.newTreeNode(goalStr, Collections.singletonList(childTree));
            result.setScore(score);
            return result;
        }
        log.info("Warning: no parse found in ExhaustivePCFGParser.extractBestParse: failing on: [" + start + ", " + end + "] looking for " + goalStr);
        return null;
    }

    protected List<Tree> extractBestParses(int goal, int start, int end) {
        double bestScore = this.iScore[start][end][goal];
        String goalStr = this.stateIndex.get(goal);
        if (end - start == 1 && this.tagIndex.contains(goalStr)) {
            IntTaggedWord tagging = new IntTaggedWord(this.words[start], this.tagIndex.indexOf(goalStr));
            String contextStr = this.getCoreLabel(start).originalText();
            float tagScore = this.lex.score(tagging, start, this.wordIndex.get(this.words[start]), contextStr);
            if (tagScore > Float.NEGATIVE_INFINITY || this.floodTags) {
                String wordStr = this.wordIndex.get(this.words[start]);
                Tree wordNode = this.tf.newLeaf(wordStr);
                Tree tagNode = this.tf.newTreeNode(goalStr, Collections.singletonList(wordNode));
                if (this.originalTags[start] != null) {
                    tagNode.label().setValue(this.originalTags[start].tag());
                }
                return Collections.singletonList(tagNode);
            }
        }
        ArrayList<Tree> bestTrees = new ArrayList<Tree>();
        for (int split = start + 1; split < end; ++split) {
            Iterator<BinaryRule> binaryI = this.bg.ruleIteratorByParent(goal);
            while (binaryI.hasNext()) {
                BinaryRule br = binaryI.next();
                double score = br.score + this.iScore[start][split][br.leftChild] + this.iScore[split][end][br.rightChild];
                if (!ExhaustivePCFGParser.matches(score, bestScore)) continue;
                List<Tree> leftChildTrees = this.extractBestParses(br.leftChild, start, split);
                List<Tree> rightChildTrees = this.extractBestParses(br.rightChild, split, end);
                for (Tree leftChildTree : leftChildTrees) {
                    for (Tree rightChildTree : rightChildTrees) {
                        ArrayList<Tree> children = new ArrayList<Tree>();
                        children.add(leftChildTree);
                        children.add(rightChildTree);
                        Tree result = this.tf.newTreeNode(goalStr, children);
                        bestTrees.add(result);
                    }
                }
            }
        }
        Iterator<UnaryRule> unaryI = this.ug.ruleIteratorByParent(goal);
        while (unaryI.hasNext()) {
            UnaryRule ur = unaryI.next();
            double score = ur.score + this.iScore[start][end][ur.child];
            if (ur.child == ur.parent || !ExhaustivePCFGParser.matches(score, bestScore)) continue;
            List<Tree> childTrees = this.extractBestParses(ur.child, start, end);
            for (Tree childTree : childTrees) {
                Tree result = this.tf.newTreeNode(goalStr, Collections.singletonList(childTree));
                bestTrees.add(result);
            }
        }
        if (bestTrees.isEmpty()) {
            log.info("Warning: no parse found in ExhaustivePCFGParser.extractBestParse: failing on: [" + start + ", " + end + "] looking for " + goalStr);
        }
        return bestTrees;
    }

    @Override
    public List<ScoredObject<Tree>> getKGoodParses(int k) {
        return this.getKBestParses(k);
    }

    @Override
    public List<ScoredObject<Tree>> getKSampledParses(int k) {
        throw new UnsupportedOperationException("ExhaustivePCFGParser doesn't sample.");
    }

    @Override
    public List<ScoredObject<Tree>> getKBestParses(int k) {
        Tree internalTree;
        this.cand = Generics.newHashMap();
        this.dHat = Generics.newHashMap();
        int start = 0;
        int end = this.length;
        int goal = this.stateIndex.indexOf(this.goalStr);
        Vertex v = new Vertex(goal, start, end);
        ArrayList<ScoredObject<Tree>> kBestTrees = new ArrayList<ScoredObject<Tree>>();
        for (int i = 1; i <= k && (internalTree = this.getTree(v, i, k)) != null; ++i) {
            kBestTrees.add(new ScoredObject<Tree>(internalTree, this.dHat.get((Object)v).get((int)(i - 1)).score));
        }
        return kBestTrees;
    }

    private Tree getTree(Vertex v, int k, int kPrime) {
        this.lazyKthBest(v, k, kPrime);
        String goalStr = this.stateIndex.get(v.goal);
        int start = v.start;
        List dHatV = this.dHat.get(v);
        if (this.isTag[v.goal] && v.start + 1 == v.end) {
            IntTaggedWord tagging = new IntTaggedWord(this.words[start], this.tagIndex.indexOf(goalStr));
            String contextStr = this.getCoreLabel(start).originalText();
            float tagScore = this.lex.score(tagging, start, this.wordIndex.get(this.words[start]), contextStr);
            if (tagScore > Float.NEGATIVE_INFINITY || this.floodTags) {
                CoreLabel terminalLabel = this.getCoreLabel(start);
                Tree wordNode = this.tf.newLeaf(terminalLabel);
                Tree tagNode = this.tf.newTreeNode(goalStr, Collections.singletonList(wordNode));
                if (this.originalTags[start] != null) {
                    tagNode.label().setValue(this.originalTags[start].tag());
                }
                if (tagNode.label() instanceof HasTag) {
                    ((HasTag)((Object)tagNode.label())).setTag(tagNode.label().value());
                }
                return tagNode;
            }
            assert (false);
        }
        if (k - 1 >= dHatV.size()) {
            return null;
        }
        Derivation d = (Derivation)dHatV.get(k - 1);
        ArrayList<Tree> children = new ArrayList<Tree>();
        for (int i = 0; i < d.arc.size(); ++i) {
            Vertex child = d.arc.tails.get(i);
            Tree t = this.getTree(child, d.j.get(i), kPrime);
            assert (t != null);
            children.add(t);
        }
        return this.tf.newTreeNode(goalStr, children);
    }

    private List<Arc> getBackwardsStar(Vertex v) {
        ArrayList<Arc> bs = new ArrayList<Arc>();
        if (this.isTag[v.goal] && v.start + 1 == v.end) {
            ArrayList<Vertex> tails = new ArrayList<Vertex>();
            double score = this.iScore[v.start][v.end][v.goal];
            Arc arc = new Arc(tails, v, score);
            bs.add(arc);
        }
        for (int split = v.start + 1; split < v.end; ++split) {
            for (BinaryRule br : this.bg.ruleListByParent(v.goal)) {
                Vertex lChild = new Vertex(br.leftChild, v.start, split);
                Vertex rChild = new Vertex(br.rightChild, split, v.end);
                ArrayList<Vertex> tails = new ArrayList<Vertex>();
                tails.add(lChild);
                tails.add(rChild);
                Arc arc = new Arc(tails, v, br.score);
                bs.add(arc);
            }
        }
        for (UnaryRule ur : this.ug.rulesByParent(v.goal)) {
            Vertex child = new Vertex(ur.child, v.start, v.end);
            ArrayList<Vertex> tails = new ArrayList<Vertex>();
            tails.add(child);
            Arc arc = new Arc(tails, v, ur.score);
            bs.add(arc);
        }
        return bs;
    }

    private PriorityQueue<Derivation> getCandidates(Vertex v, int k) {
        PriorityQueue<Derivation> candV = this.cand.get(v);
        if (candV == null) {
            candV = new BinaryHeapPriorityQueue<Derivation>();
            List<Arc> bsV = this.getBackwardsStar(v);
            for (Arc arc : bsV) {
                int size = arc.size();
                double score = arc.ruleScore;
                ArrayList<Double> childrenScores = new ArrayList<Double>();
                for (int i = 0; i < size; ++i) {
                    Vertex child = arc.tails.get(i);
                    double s = this.iScore[child.start][child.end][child.goal];
                    childrenScores.add(s);
                    score += s;
                }
                if (score == Double.NEGATIVE_INFINITY) continue;
                ArrayList<Integer> j = new ArrayList<Integer>();
                for (int i = 0; i < size; ++i) {
                    j.add(1);
                }
                Derivation d = new Derivation(arc, j, score, childrenScores);
                candV.add(d, score);
            }
            BinaryHeapPriorityQueue<Derivation> tmp = new BinaryHeapPriorityQueue<Derivation>();
            for (int i = 0; i < k && !candV.isEmpty(); ++i) {
                Derivation d = candV.removeFirst();
                tmp.add(d, d.score);
            }
            candV = tmp;
            this.cand.put(v, candV);
        }
        return candV;
    }

    private void lazyKthBest(Vertex v, int k, int kPrime) {
        PriorityQueue<Derivation> candV = this.getCandidates(v, kPrime);
        LinkedList<Derivation> dHatV = this.dHat.get(v);
        if (dHatV == null) {
            dHatV = new LinkedList();
            this.dHat.put(v, dHatV);
        }
        while (dHatV.size() < k) {
            if (!dHatV.isEmpty()) {
                Derivation derivation = dHatV.getLast();
                this.lazyNext(candV, derivation, kPrime);
            }
            if (candV.isEmpty()) break;
            Derivation d = candV.removeFirst();
            dHatV.add(d);
        }
    }

    private void lazyNext(PriorityQueue<Derivation> candV, Derivation derivation, int kPrime) {
        List<Vertex> tails = derivation.arc.tails;
        int sz = derivation.arc.size();
        for (int i = 0; i < sz; ++i) {
            ArrayList<Integer> j = new ArrayList<Integer>(derivation.j);
            j.set(i, (Integer)j.get(i) + 1);
            Vertex Ti = tails.get(i);
            this.lazyKthBest(Ti, (Integer)j.get(i), kPrime);
            LinkedList<Derivation> dHatTi = this.dHat.get(Ti);
            if ((Integer)j.get(i) - 1 >= dHatTi.size()) continue;
            Derivation d = dHatTi.get((Integer)j.get(i) - 1);
            double newScore = derivation.score - derivation.childrenScores.get(i) + d.score;
            ArrayList<Double> childrenScores = new ArrayList<Double>(derivation.childrenScores);
            childrenScores.set(i, d.score);
            Derivation newDerivation = new Derivation(derivation.arc, j, newScore, childrenScores);
            if (candV.contains(newDerivation) || !(newScore > Double.NEGATIVE_INFINITY)) continue;
            candV.add(newDerivation, newScore);
        }
    }

    @Override
    public List<ScoredObject<Tree>> getBestParses() {
        int start = 0;
        int end = this.length;
        int goal = this.stateIndex.indexOf(this.goalStr);
        double bestScore = this.iScore[start][end][goal];
        List<Tree> internalTrees = this.extractBestParses(goal, start, end);
        ArrayList<ScoredObject<Tree>> scoredTrees = new ArrayList<ScoredObject<Tree>>(internalTrees.size());
        for (Tree tr : internalTrees) {
            scoredTrees.add(new ScoredObject<Tree>(tr, bestScore));
        }
        return scoredTrees;
    }

    protected List<ParserConstraint> getConstraints() {
        return this.constraints;
    }

    void setConstraints(List<ParserConstraint> constraints) {
        this.constraints = constraints == null ? Collections.emptyList() : constraints;
    }

    public ExhaustivePCFGParser(BinaryGrammar bg, UnaryGrammar ug, Lexicon lex, Options op, Index<String> stateIndex, Index<String> wordIndex, Index<String> tagIndex) {
        this.bg = bg;
        this.ug = ug;
        this.lex = lex;
        this.op = op;
        this.tlp = op.langpack();
        this.goalStr = this.tlp.startSymbol();
        this.stateIndex = stateIndex;
        this.wordIndex = wordIndex;
        this.tagIndex = tagIndex;
        this.tf = new LabeledScoredTreeFactory();
        this.numStates = stateIndex.size();
        this.isTag = new boolean[this.numStates];
        for (String tag : tagIndex.objectsList()) {
            int state = stateIndex.indexOf(tag);
            if (state < 0) continue;
            this.isTag[state] = true;
        }
    }

    public void nudgeDownArraySize() {
        try {
            if (this.arraySize > 2) {
                this.considerCreatingArrays(this.arraySize - 2);
            }
        }
        catch (OutOfMemoryError oome) {
            oome.printStackTrace();
        }
    }

    private void considerCreatingArrays(int length) {
        if (length > this.op.testOptions.maxLength + 1 || length >= this.myMaxLength) {
            throw new OutOfMemoryError("Refusal to create such large arrays.");
        }
        try {
            this.createArrays(length + 1);
        }
        catch (OutOfMemoryError e) {
            this.myMaxLength = length;
            if (this.arraySize > 0) {
                try {
                    this.createArrays(this.arraySize);
                }
                catch (OutOfMemoryError e2) {
                    throw new RuntimeException("CANNOT EVEN CREATE ARRAYS OF ORIGINAL SIZE!!");
                }
            }
            throw e;
        }
        this.arraySize = length + 1;
        if (this.op.testOptions.verbose) {
            log.info("Created PCFG parser arrays of size " + this.arraySize);
        }
    }

    protected void createArrays(int length) {
        int end;
        int start;
        this.clearArrays();
        int numTags = this.tagIndex.size();
        this.iScore = new float[length][length + 1][];
        for (start = 0; start < length; ++start) {
            for (end = start + 1; end <= length; ++end) {
                this.iScore[start][end] = new float[this.numStates];
            }
        }
        if (this.op.doDep && !this.op.testOptions.useFastFactored) {
            this.oScore = new float[length][length + 1][];
            for (start = 0; start < length; ++start) {
                for (end = start + 1; end <= length; ++end) {
                    this.oScore[start][end] = new float[this.numStates];
                }
            }
        }
        this.narrowRExtent = new int[length][this.numStates];
        this.wideRExtent = new int[length][this.numStates];
        this.narrowLExtent = new int[length + 1][this.numStates];
        this.wideLExtent = new int[length + 1][this.numStates];
        if (this.op.doDep && !this.op.testOptions.useFastFactored) {
            this.iPossibleByL = new boolean[length][this.numStates];
            this.iPossibleByR = new boolean[length + 1][this.numStates];
            this.oPossibleByL = new boolean[length][this.numStates];
            this.oPossibleByR = new boolean[length + 1][this.numStates];
        }
        this.tags = new boolean[length][numTags];
        if (this.op.testOptions.lengthNormalization) {
            this.wordsInSpan = new int[length][length + 1][];
            for (start = 0; start < length; ++start) {
                for (end = start + 1; end <= length; ++end) {
                    this.wordsInSpan[start][end] = new int[this.numStates];
                }
            }
        }
    }

    private void clearArrays() {
        this.oScore = null;
        this.iScore = this.oScore;
        this.oPossibleByR = null;
        this.oPossibleByL = this.oPossibleByR;
        this.iPossibleByR = this.oPossibleByR;
        this.iPossibleByL = this.oPossibleByR;
        this.oFilteredStart = null;
        this.oFilteredEnd = this.oFilteredStart;
        this.tags = null;
        this.wideLExtent = null;
        this.narrowLExtent = this.wideLExtent;
        this.wideRExtent = this.wideLExtent;
        this.narrowRExtent = this.wideLExtent;
    }

    private static class Derivation {
        public final Arc arc;
        public final List<Integer> j;
        public final double score;
        public final List<Double> childrenScores;
        private int hc = -1;

        public Derivation(Arc arc, List<Integer> j, double score, List<Double> childrenScores) {
            this.arc = arc;
            this.j = Collections.unmodifiableList(j);
            this.score = score;
            this.childrenScores = Collections.unmodifiableList(childrenScores);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Derivation)) {
                return false;
            }
            Derivation d = (Derivation)o;
            if (this.arc == null && d.arc != null || this.arc != null && d.arc == null) {
                return false;
            }
            return (this.arc == null && d.arc == null || d.arc.equals(this.arc)) && d.j.equals(this.j);
        }

        public int hashCode() {
            if (this.hc == -1) {
                this.hc = (this.arc == null ? 0 : this.arc.hashCode()) + 17 * this.j.hashCode();
            }
            return this.hc;
        }
    }

    private static class Arc {
        public final List<Vertex> tails;
        public final Vertex head;
        public final double ruleScore;
        private int hc = -1;

        public Arc(List<Vertex> tails, Vertex head, double ruleScore) {
            this.tails = Collections.unmodifiableList(tails);
            this.head = head;
            this.ruleScore = ruleScore;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Arc)) {
                return false;
            }
            Arc a = (Arc)o;
            return a.head.equals(this.head) && a.tails.equals(this.tails);
        }

        public int hashCode() {
            if (this.hc == -1) {
                this.hc = this.head.hashCode() + 17 * this.tails.hashCode();
            }
            return this.hc;
        }

        public int size() {
            return this.tails.size();
        }
    }

    private static class Vertex {
        public final int goal;
        public final int start;
        public final int end;
        private int hc = -1;

        public Vertex(int goal, int start, int end) {
            this.goal = goal;
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Vertex)) {
                return false;
            }
            Vertex v = (Vertex)o;
            return v.goal == this.goal && v.start == this.start && v.end == this.end;
        }

        public int hashCode() {
            if (this.hc == -1) {
                this.hc = this.goal + 17 * (this.start + 17 * this.end);
            }
            return this.hc;
        }

        public String toString() {
            return this.goal + "[" + this.start + "," + this.end + "]";
        }
    }
}

