/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.AnnotationLookup;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.CoreMapAttributeAggregator;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.CoreTokenFactory;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.Interval;
import edu.stanford.nlp.util.logging.Redwood;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChunkAnnotationUtils {
    private static final Redwood.RedwoodChannels logger = Redwood.channels(ChunkAnnotationUtils.class);
    private static final CoreLabelTokenFactory tokenFactory = new CoreLabelTokenFactory(true);

    private ChunkAnnotationUtils() {
    }

    public static boolean checkOffsets(CoreMap docAnnotation) {
        boolean okay = true;
        String docText = (String)docAnnotation.get(CoreAnnotations.TextAnnotation.class);
        String docId = (String)docAnnotation.get(CoreAnnotations.DocIDAnnotation.class);
        List docTokens = (List)docAnnotation.get(CoreAnnotations.TokensAnnotation.class);
        List sentences = (List)docAnnotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sentence : sentences) {
            String sentText = (String)sentence.get(CoreAnnotations.TextAnnotation.class);
            List sentTokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            int sentBeginChar = (Integer)sentence.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            int sentEndChar = (Integer)sentence.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            int sentBeginToken = (Integer)sentence.get(CoreAnnotations.TokenBeginAnnotation.class);
            int sentEndToken = (Integer)sentence.get(CoreAnnotations.TokenEndAnnotation.class);
            String docTextSpan = docText.substring(sentBeginChar, sentEndChar);
            ArrayList docTokenSpan = new ArrayList(docTokens.subList(sentBeginToken, sentEndToken));
            logger.debug("Checking Document " + docId + " span (" + sentBeginChar + "," + sentEndChar + ") ");
            if (!docTextSpan.equals(sentText)) {
                okay = false;
                logger.debug("WARNING: Document " + docId + " span does not match sentence");
                logger.debug("DocSpanText: " + docTextSpan);
                logger.debug("SentenceText: " + sentText);
            }
            String sentTokenStr = ChunkAnnotationUtils.getTokenText(sentTokens, CoreAnnotations.TextAnnotation.class);
            String docTokenStr = ChunkAnnotationUtils.getTokenText(docTokenSpan, CoreAnnotations.TextAnnotation.class);
            if (docTokenStr.equals(sentTokenStr)) continue;
            okay = false;
            logger.debug("WARNING: Document " + docId + " tokens does not match sentence");
            logger.debug("DocSpanTokens: " + docTokenStr);
            logger.debug("SentenceTokens: " + sentTokenStr);
        }
        return okay;
    }

    public static boolean fixTokenOffsets(CoreMap docAnnotation) {
        List docTokens = (List)docAnnotation.get(CoreAnnotations.TokensAnnotation.class);
        List sentences = (List)docAnnotation.get(CoreAnnotations.SentencesAnnotation.class);
        int i = 0;
        CoreLabel curDocToken = (CoreLabel)docTokens.get(0);
        for (CoreMap sentence : sentences) {
            List sentTokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            CoreLabel sentTokenFirst = (CoreLabel)sentTokens.get(0);
            while (curDocToken != sentTokenFirst) {
                if (++i >= docTokens.size()) {
                    return false;
                }
                curDocToken = (CoreLabel)docTokens.get(i);
            }
            int sentTokenBegin = i;
            CoreLabel sentTokenLast = (CoreLabel)sentTokens.get(sentTokens.size() - 1);
            while (curDocToken != sentTokenLast) {
                if (++i >= docTokens.size()) {
                    return false;
                }
                curDocToken = (CoreLabel)docTokens.get(i);
            }
            int sentTokenEnd = i + 1;
            sentence.set(CoreAnnotations.TokenBeginAnnotation.class, sentTokenBegin);
            sentence.set(CoreAnnotations.TokenEndAnnotation.class, sentTokenEnd);
        }
        return true;
    }

    public static void copyUnsetAnnotations(CoreMap src, CoreMap dest) {
        for (Class<?> key : src.keySet()) {
            if (dest.containsKey(key)) continue;
            dest.set(key, src.get(key));
        }
    }

    public static boolean fixChunkTokenBoundaries(CoreMap docAnnotation, List<IntPair> chunkCharOffsets) {
        String text = (String)docAnnotation.get(CoreAnnotations.TextAnnotation.class);
        List tokens = (List)docAnnotation.get(CoreAnnotations.TokensAnnotation.class);
        ArrayList<CoreLabel> output = new ArrayList<CoreLabel>(tokens.size());
        int i = 0;
        CoreLabel token = (CoreLabel)tokens.get(i);
        for (IntPair offsets : chunkCharOffsets) {
            assert (token.beginPosition() >= 0);
            assert (token.endPosition() >= 0);
            int offsetBegin = offsets.getSource();
            int offsetEnd = offsets.getTarget();
            while (offsetBegin < (Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) || offsetBegin >= (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
                output.add(token);
                if (++i >= tokens.size()) {
                    return false;
                }
                token = (CoreLabel)tokens.get(i);
            }
            while (offsetEnd > (Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)) {
                if (offsetBegin > (Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)) {
                    if (offsetEnd < (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
                        output.add(tokenFactory.makeToken(text.substring(token.beginPosition(), offsetBegin), token.beginPosition(), offsetBegin - token.beginPosition()));
                        output.add(tokenFactory.makeToken(text.substring(offsetBegin, offsetEnd), offsetBegin, offsetEnd - offsetBegin));
                        output.add(tokenFactory.makeToken(text.substring(offsetEnd, token.endPosition()), offsetEnd, token.endPosition() - offsetEnd));
                    } else {
                        output.add(tokenFactory.makeToken(text.substring(token.beginPosition(), offsetBegin), token.beginPosition(), offsetBegin - token.beginPosition()));
                        output.add(tokenFactory.makeToken(text.substring(offsetBegin, token.endPosition()), offsetBegin, token.endPosition() - offsetBegin));
                    }
                } else if (offsetEnd < (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
                    output.add(tokenFactory.makeToken(text.substring(token.beginPosition(), offsetEnd), token.beginPosition(), offsetEnd - token.beginPosition()));
                    output.add(tokenFactory.makeToken(text.substring(offsetEnd, token.endPosition()), offsetEnd, token.endPosition() - offsetEnd));
                } else {
                    output.add(token);
                }
                if (++i >= tokens.size()) {
                    return false;
                }
                token = (CoreLabel)tokens.get(i);
            }
        }
        while (i < tokens.size()) {
            token = (CoreLabel)tokens.get(i);
            output.add(token);
            ++i;
        }
        docAnnotation.set(CoreAnnotations.TokensAnnotation.class, output);
        return true;
    }

    public static CoreMap getMergedChunk(List<? extends CoreMap> chunkList, String origText, int chunkIndexStart, int chunkIndexEnd, CoreLabelTokenFactory tokenFactory) {
        CoreMap firstChunk = chunkList.get(chunkIndexStart);
        CoreMap lastChunk = chunkList.get(chunkIndexEnd - 1);
        int firstCharOffset = (Integer)firstChunk.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        int lastCharOffset = (Integer)lastChunk.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        int firstTokenIndex = (Integer)firstChunk.get(CoreAnnotations.TokenBeginAnnotation.class);
        int lastTokenIndex = (Integer)lastChunk.get(CoreAnnotations.TokenEndAnnotation.class);
        String chunkText = origText.substring(firstCharOffset, lastCharOffset);
        ArrayCoreMap newChunk = tokenFactory != null ? tokenFactory.makeToken(chunkText, firstCharOffset, lastCharOffset) : new Annotation(chunkText);
        newChunk.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, firstCharOffset);
        newChunk.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, lastCharOffset);
        newChunk.set(CoreAnnotations.TokenBeginAnnotation.class, firstTokenIndex);
        newChunk.set(CoreAnnotations.TokenEndAnnotation.class, lastTokenIndex);
        ArrayList tokens = new ArrayList(lastTokenIndex - firstTokenIndex);
        for (int i = chunkIndexStart; i < chunkIndexEnd; ++i) {
            CoreMap chunk = chunkList.get(i);
            tokens.addAll((Collection)chunk.get(CoreAnnotations.TokensAnnotation.class));
        }
        newChunk.set(CoreAnnotations.TokensAnnotation.class, tokens);
        return newChunk;
    }

    public static CoreMap getMergedChunk(List<? extends CoreMap> chunkList, int chunkIndexStart, int chunkIndexEnd, Map<Class, CoreMapAttributeAggregator> aggregators, CoreLabelTokenFactory tokenFactory) {
        ArrayCoreMap newChunk = tokenFactory != null ? tokenFactory.makeToken() : new Annotation("");
        for (Map.Entry<Class, CoreMapAttributeAggregator> entry : aggregators.entrySet()) {
            if (chunkIndexEnd > chunkList.size()) assert (false);
            Object value = entry.getValue().aggregate(entry.getKey(), chunkList.subList(chunkIndexStart, chunkIndexEnd));
            newChunk.set(entry.getKey(), value);
        }
        if (newChunk instanceof CoreLabel) {
            ArrayCoreMap cl = newChunk;
            ((CoreLabel)cl).setValue(((CoreLabel)cl).word());
            ((CoreLabel)cl).setOriginalText(((CoreLabel)cl).word());
        }
        return newChunk;
    }

    public static Interval<Integer> getChunkOffsetsUsingCharOffsets(List<? extends CoreMap> chunkList, int charStart, int charEnd) {
        int start;
        int chunkStart = 0;
        int chunkEnd = chunkList.size();
        int i = 0;
        while (i < chunkList.size() && (start = ((Integer)chunkList.get(i).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)).intValue()) <= charStart) {
            chunkStart = i++;
        }
        for (i = chunkStart; i < chunkList.size(); ++i) {
            start = (Integer)chunkList.get(i).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            if (start < charEnd) continue;
            chunkEnd = i;
            break;
        }
        return Interval.toInterval(chunkStart, chunkEnd, 2);
    }

    public static void mergeChunks(List<CoreMap> chunkList, String origText, int chunkIndexStart, int chunkIndexEnd) {
        CoreMap newChunk = ChunkAnnotationUtils.getMergedChunk(chunkList, origText, chunkIndexStart, chunkIndexEnd, null);
        int nChunksToRemove = chunkIndexEnd - chunkIndexStart - 1;
        for (int i = 0; i < nChunksToRemove; ++i) {
            chunkList.remove(chunkIndexStart);
        }
        chunkList.set(chunkIndexStart, newChunk);
    }

    private static Character getFirstNonWsChar(CoreMap sent) {
        String sentText = (String)sent.get(CoreAnnotations.TextAnnotation.class);
        for (int j = 0; j < sentText.length(); ++j) {
            char c = sentText.charAt(j);
            if (Character.isWhitespace(c)) continue;
            return Character.valueOf(c);
        }
        return null;
    }

    private static Integer getFirstNonWsCharOffset(CoreMap sent, boolean relative) {
        String sentText = (String)sent.get(CoreAnnotations.TextAnnotation.class);
        for (int j = 0; j < sentText.length(); ++j) {
            char c = sentText.charAt(j);
            if (Character.isWhitespace(c)) continue;
            if (relative) {
                return j;
            }
            return j + (Integer)sent.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        }
        return null;
    }

    private static String getTrimmedText(CoreMap sent) {
        String sentText = (String)sent.get(CoreAnnotations.TextAnnotation.class);
        return sentText.trim();
    }

    public static boolean fixChunkSentenceBoundaries(CoreMap docAnnotation, List<IntPair> chunkCharOffsets) {
        return ChunkAnnotationUtils.fixChunkSentenceBoundaries(docAnnotation, chunkCharOffsets, false, false, false);
    }

    public static boolean fixChunkSentenceBoundaries(CoreMap docAnnotation, List<IntPair> chunkCharOffsets, boolean offsetsAreNotSorted, boolean extendedFixSentence, boolean moreExtendedFixSentence) {
        CoreMap sentence;
        int i;
        String text = (String)docAnnotation.get(CoreAnnotations.TextAnnotation.class);
        List sentences = (List)docAnnotation.get(CoreAnnotations.SentencesAnnotation.class);
        if (sentences == null || sentences.size() == 0) {
            return true;
        }
        if (chunkCharOffsets != null) {
            i = 0;
            sentence = (CoreMap)sentences.get(i);
            for (IntPair offsets : chunkCharOffsets) {
                int offsetBegin = offsets.getSource();
                int offsetEnd = offsets.getTarget();
                while (offsetBegin < (Integer)sentence.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) || offsetBegin >= (Integer)sentence.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
                    if (++i >= sentences.size()) {
                        return false;
                    }
                    sentence = (CoreMap)sentences.get(i);
                }
                if ((Integer)sentence.get(CoreAnnotations.CharacterOffsetEndAnnotation.class) < offsetEnd) {
                    int startSentIndex = i;
                    while (offsetEnd > (Integer)sentence.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
                        if (++i >= sentences.size()) {
                            return false;
                        }
                        sentence = (CoreMap)sentences.get(i);
                    }
                    Integer firstNonWsCharOffset = ChunkAnnotationUtils.getFirstNonWsCharOffset(sentence, false);
                    if (firstNonWsCharOffset != null && firstNonWsCharOffset >= offsetEnd) {
                        sentence = (CoreMap)sentences.get(--i);
                    }
                    ChunkAnnotationUtils.mergeChunks(sentences, text, startSentIndex, i + 1);
                    i = startSentIndex;
                    sentence = (CoreMap)sentences.get(i);
                }
                if (extendedFixSentence && i + 1 < sentences.size()) {
                    int offsetEndInSentText;
                    boolean entityAtSentEnd = true;
                    int sentCharBegin = (Integer)sentence.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                    String sentText = (String)sentence.get(CoreAnnotations.TextAnnotation.class);
                    for (int j = offsetEndInSentText = offsetEnd - sentCharBegin; j < sentText.length(); ++j) {
                        char c = sentText.charAt(j);
                        if (Character.isWhitespace(c)) continue;
                        entityAtSentEnd = false;
                        break;
                    }
                    boolean doMerge = false;
                    if (entityAtSentEnd) {
                        CoreMap nextSentence = (CoreMap)sentences.get(i + 1);
                        Character c = ChunkAnnotationUtils.getFirstNonWsChar(nextSentence);
                        if (c != null) {
                            boolean bl = doMerge = !Character.isUpperCase(c.charValue());
                            if (!doMerge) {
                                logger.debug("No merge: c is '" + c + "'");
                            }
                        } else {
                            logger.debug("No merge: no char");
                        }
                    } else {
                        logger.debug("No merge: entity not at end");
                    }
                    if (doMerge) {
                        logger.debug("Merge chunks");
                        ChunkAnnotationUtils.mergeChunks(sentences, text, i, i + 2);
                    }
                }
                if (offsetsAreNotSorted) {
                    i = 0;
                }
                sentence = (CoreMap)sentences.get(i);
            }
        }
        if (moreExtendedFixSentence) {
            i = 0;
            while (i + 1 < sentences.size()) {
                boolean doMerge = false;
                CoreMap sentence2 = (CoreMap)sentences.get(i);
                CoreMap nextSentence = (CoreMap)sentences.get(i + 1);
                String sentTrimmedText = ChunkAnnotationUtils.getTrimmedText(sentence2);
                String nextSentTrimmedText = ChunkAnnotationUtils.getTrimmedText(nextSentence);
                if (sentTrimmedText.length() <= 1 || nextSentTrimmedText.length() <= 1) {
                    doMerge = true;
                } else {
                    Character c = ChunkAnnotationUtils.getFirstNonWsChar(nextSentence);
                    if (c != null && !Character.isUpperCase(c.charValue()) && (c.charValue() == ',' || Character.isLowerCase(c.charValue()))) {
                        doMerge = true;
                    }
                }
                if (doMerge) {
                    ChunkAnnotationUtils.mergeChunks(sentences, text, i, i + 2);
                    continue;
                }
                ++i;
            }
        }
        for (i = 0; i < sentences.size(); ++i) {
            sentence = (CoreMap)sentences.get(i);
            sentence.set(CoreAnnotations.SentenceIndexAnnotation.class, i);
        }
        return true;
    }

    public static void annotateChunk(CoreMap chunk, List<CoreLabel> tokens, int tokenStartIndex, int tokenEndIndex, int totalTokenOffset) {
        ArrayList<CoreLabel> chunkTokens = new ArrayList<CoreLabel>(tokens.subList(tokenStartIndex, tokenEndIndex));
        chunk.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, ((CoreLabel)chunkTokens.get(0)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class));
        chunk.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, ((CoreLabel)chunkTokens.get(chunkTokens.size() - 1)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
        chunk.set(CoreAnnotations.TokensAnnotation.class, chunkTokens);
        chunk.set(CoreAnnotations.TokenBeginAnnotation.class, tokenStartIndex + totalTokenOffset);
        chunk.set(CoreAnnotations.TokenEndAnnotation.class, tokenEndIndex + totalTokenOffset);
    }

    public static String getTokenText(List<? extends CoreMap> tokens, Class tokenTextKey) {
        return ChunkAnnotationUtils.getTokenText(tokens, tokenTextKey, " ");
    }

    public static String getTokenText(List<? extends CoreMap> tokens, Class tokenTextKey, String delimiter) {
        StringBuilder sb = new StringBuilder();
        int prevEndIndex = -1;
        for (CoreMap coreMap : tokens) {
            boolean includeDelimiter;
            Object obj = coreMap.get(tokenTextKey);
            boolean bl = includeDelimiter = sb.length() > 0;
            if (coreMap.containsKey(CoreAnnotations.CharacterOffsetBeginAnnotation.class) && coreMap.containsKey(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
                int beginIndex = (Integer)coreMap.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                int endIndex = (Integer)coreMap.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                if (prevEndIndex == beginIndex) {
                    includeDelimiter = false;
                }
                prevEndIndex = endIndex;
            }
            if (obj == null) continue;
            if (includeDelimiter) {
                sb.append(delimiter);
            }
            sb.append(obj);
        }
        return sb.toString();
    }

    public static void annotateChunkText(CoreMap chunk, Class tokenTextKey) {
        List chunkTokens = (List)chunk.get(CoreAnnotations.TokensAnnotation.class);
        String text = ChunkAnnotationUtils.getTokenText(chunkTokens, tokenTextKey);
        chunk.set(CoreAnnotations.TextAnnotation.class, text);
    }

    public static boolean hasCharacterOffsets(CoreMap chunk) {
        return chunk.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) != null && chunk.get(CoreAnnotations.CharacterOffsetEndAnnotation.class) != null;
    }

    public static boolean annotateChunkText(CoreMap chunk, CoreMap origAnnotation) {
        String annoText = (String)origAnnotation.get(CoreAnnotations.TextAnnotation.class);
        if (annoText == null) {
            return false;
        }
        if (!ChunkAnnotationUtils.hasCharacterOffsets(chunk)) {
            return false;
        }
        Integer annoBeginCharOffset = (Integer)origAnnotation.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        if (annoBeginCharOffset == null) {
            annoBeginCharOffset = 0;
        }
        int chunkBeginCharOffset = (Integer)chunk.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) - annoBeginCharOffset;
        int chunkEndCharOffset = (Integer)chunk.get(CoreAnnotations.CharacterOffsetEndAnnotation.class) - annoBeginCharOffset;
        if (chunkBeginCharOffset < 0) {
            logger.debug("Adjusting begin char offset from " + chunkBeginCharOffset + " to 0");
            logger.debug("Chunk begin offset: " + chunk.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) + ", Source text begin offset " + annoBeginCharOffset);
            chunkBeginCharOffset = 0;
        }
        if (chunkBeginCharOffset > annoText.length()) {
            logger.debug("Adjusting begin char offset from " + chunkBeginCharOffset + " to " + annoText.length());
            logger.debug("Chunk begin offset: " + chunk.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) + ", Source text begin offset " + annoBeginCharOffset);
            chunkBeginCharOffset = annoText.length();
        }
        if (chunkEndCharOffset < 0) {
            logger.debug("Adjusting end char offset from " + chunkEndCharOffset + " to 0");
            logger.debug("Chunk end offset: " + chunk.get(CoreAnnotations.CharacterOffsetEndAnnotation.class) + ", Source text begin offset " + annoBeginCharOffset);
            chunkEndCharOffset = 0;
        }
        if (chunkEndCharOffset > annoText.length()) {
            logger.debug("Adjusting end char offset from " + chunkEndCharOffset + " to " + annoText.length());
            logger.debug("Chunk end offset: " + chunk.get(CoreAnnotations.CharacterOffsetEndAnnotation.class) + ", Source text begin offset " + annoBeginCharOffset);
            chunkEndCharOffset = annoText.length();
        }
        if (chunkEndCharOffset < chunkBeginCharOffset) {
            logger.debug("Adjusting end char offset from " + chunkEndCharOffset + " to " + chunkBeginCharOffset);
            logger.debug("Chunk end offset: " + chunk.get(CoreAnnotations.CharacterOffsetEndAnnotation.class) + ", Source text begin offset " + annoBeginCharOffset);
            chunkEndCharOffset = chunkBeginCharOffset;
        }
        String chunkText = annoText.substring(chunkBeginCharOffset, chunkEndCharOffset);
        chunk.set(CoreAnnotations.TextAnnotation.class, chunkText);
        return true;
    }

    public static void annotateChunkTokens(CoreMap chunk, Class tokenChunkKey, Class tokenLabelKey) {
        List chunkTokens = (List)chunk.get(CoreAnnotations.TokensAnnotation.class);
        if (tokenLabelKey != null) {
            String text = (String)chunk.get(CoreAnnotations.TextAnnotation.class);
            for (CoreLabel t : chunkTokens) {
                t.set(tokenLabelKey, text);
            }
        }
        if (tokenChunkKey != null) {
            for (CoreLabel t : chunkTokens) {
                t.set(tokenChunkKey, chunk);
            }
        }
    }

    public static Annotation getAnnotatedChunk(List<CoreLabel> tokens, int tokenStartIndex, int tokenEndIndex, int totalTokenOffset) {
        Annotation chunk = new Annotation("");
        ChunkAnnotationUtils.annotateChunk(chunk, tokens, tokenStartIndex, tokenEndIndex, totalTokenOffset);
        return chunk;
    }

    public static Annotation getAnnotatedChunk(List<CoreLabel> tokens, int tokenStartIndex, int tokenEndIndex, int totalTokenOffset, Class tokenChunkKey, Class tokenTextKey, Class tokenLabelKey) {
        Annotation chunk = ChunkAnnotationUtils.getAnnotatedChunk(tokens, tokenStartIndex, tokenEndIndex, totalTokenOffset);
        ChunkAnnotationUtils.annotateChunkText((CoreMap)chunk, tokenTextKey);
        ChunkAnnotationUtils.annotateChunkTokens(chunk, tokenChunkKey, tokenLabelKey);
        return chunk;
    }

    public static Annotation getAnnotatedChunk(CoreMap annotation, int tokenStartIndex, int tokenEndIndex) {
        List tokens;
        Annotation chunk;
        boolean annotatedTextFromCharOffsets;
        Integer annoTokenBegin = (Integer)annotation.get(CoreAnnotations.TokenBeginAnnotation.class);
        if (annoTokenBegin == null) {
            annoTokenBegin = 0;
        }
        if (!(annotatedTextFromCharOffsets = ChunkAnnotationUtils.annotateChunkText((CoreMap)(chunk = ChunkAnnotationUtils.getAnnotatedChunk(tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class), tokenStartIndex, tokenEndIndex, annoTokenBegin)), annotation))) {
            ChunkAnnotationUtils.annotateChunkText((CoreMap)chunk, CoreAnnotations.TextAnnotation.class);
        }
        return chunk;
    }

    public static Annotation getAnnotatedChunk(CoreMap annotation, int tokenStartIndex, int tokenEndIndex, Class tokenChunkKey, Class tokenLabelKey) {
        Annotation chunk = ChunkAnnotationUtils.getAnnotatedChunk(annotation, tokenStartIndex, tokenEndIndex);
        ChunkAnnotationUtils.annotateChunkTokens(chunk, tokenChunkKey, tokenLabelKey);
        return chunk;
    }

    public static CoreMap getAnnotatedChunkUsingCharOffsets(CoreMap annotation, int charOffsetStart, int charOffsetEnd) {
        List<CoreMap> cm = ChunkAnnotationUtils.getAnnotatedChunksUsingSortedCharOffsets(annotation, CollectionUtils.makeList(new IntPair(charOffsetStart, charOffsetEnd)));
        if (!cm.isEmpty()) {
            return cm.get(0);
        }
        return null;
    }

    public static List<CoreMap> getAnnotatedChunksUsingSortedCharOffsets(CoreMap annotation, List<IntPair> charOffsets) {
        return ChunkAnnotationUtils.getAnnotatedChunksUsingSortedCharOffsets(annotation, charOffsets, true, null, null, true);
    }

    public static List<CoreMap> getAnnotatedChunksUsingSortedCharOffsets(CoreMap annotation, List<IntPair> charOffsets, boolean charOffsetIsRelative, Class tokenChunkKey, Class tokenLabelKey, boolean allowPartialTokens) {
        Integer annoTokenBegin;
        String annoText = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        ArrayList<CoreMap> chunks = new ArrayList<CoreMap>(charOffsets.size());
        List annoTokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        Integer annoCharBegin = (Integer)annotation.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        if (annoCharBegin == null) {
            annoCharBegin = 0;
        }
        if ((annoTokenBegin = (Integer)annotation.get(CoreAnnotations.TokenBeginAnnotation.class)) == null) {
            annoTokenBegin = 0;
        }
        int i = 0;
        for (IntPair p : charOffsets) {
            int j;
            int beginRelCharOffset = charOffsetIsRelative ? p.getSource() : p.getSource() - annoCharBegin;
            int endRelCharOffset = charOffsetIsRelative ? p.getTarget() : p.getTarget() - annoCharBegin;
            int beginCharOffset = beginRelCharOffset + annoCharBegin;
            int endCharOffset = endRelCharOffset + annoCharBegin;
            if (beginRelCharOffset >= annoText.length()) break;
            if (endRelCharOffset > annoText.length()) {
                endRelCharOffset = annoText.length();
            }
            if (allowPartialTokens) {
                while (i < annoTokens.size() && ((CoreLabel)annoTokens.get(i)).endPosition() <= beginCharOffset) {
                    ++i;
                }
            } else {
                while (i < annoTokens.size() && ((CoreLabel)annoTokens.get(i)).beginPosition() < beginCharOffset) {
                    ++i;
                }
            }
            if (i >= annoTokens.size()) break;
            int tokenBegin = i;
            if (allowPartialTokens) {
                for (j = i; j < annoTokens.size() && ((CoreLabel)annoTokens.get(j)).beginPosition() < endCharOffset; ++j) {
                }
            } else {
                while (j < annoTokens.size() && ((CoreLabel)annoTokens.get(j)).endPosition() <= endCharOffset) {
                    assert (((CoreLabel)annoTokens.get(j)).beginPosition() >= beginCharOffset);
                    ++j;
                }
            }
            int tokenEnd = j;
            ArrayList chunkTokens = new ArrayList(annoTokens.subList(tokenBegin, tokenEnd));
            String chunkText = annoText.substring(beginRelCharOffset, endRelCharOffset);
            Annotation chunk = new Annotation(chunkText);
            chunk.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, beginCharOffset);
            chunk.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, endCharOffset);
            chunk.set(CoreAnnotations.TokensAnnotation.class, chunkTokens);
            chunk.set(CoreAnnotations.TokenBeginAnnotation.class, tokenBegin + annoTokenBegin);
            chunk.set(CoreAnnotations.TokenEndAnnotation.class, tokenEnd + annoTokenBegin);
            ChunkAnnotationUtils.annotateChunkTokens(chunk, tokenChunkKey, tokenLabelKey);
            chunks.add(chunk);
            if (j < annoTokens.size()) continue;
            break;
        }
        if (chunks.size() != charOffsets.size()) {
            logger.warning("WARNING: Only " + chunks.size() + "/" + charOffsets.size() + " chunks found.  Check if offsets are sorted/nonoverlapping");
        }
        return chunks;
    }

    public static void annotateChunk(CoreMap annotation, Class newAnnotationKey, Class aggrKey, CoreMapAttributeAggregator aggregator) {
        Object v = aggregator.aggregate(aggrKey, (List)annotation.get(CoreAnnotations.TokensAnnotation.class));
        annotation.set(newAnnotationKey, v);
    }

    public static void annotateChunk(CoreMap chunk, Map<String, String> attributes) {
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Class<? extends CoreAnnotation<?>> coreKeyClass = AnnotationLookup.toCoreKey(key);
            if (key != null) {
                if (value != null) {
                    try {
                        Class<?> valueClass = AnnotationLookup.getValueType(coreKeyClass);
                        if (valueClass == String.class) {
                            chunk.set(coreKeyClass, value);
                            continue;
                        }
                        Method valueOfMethod = valueClass.getMethod("valueOf", String.class);
                        if (valueOfMethod == null) continue;
                        chunk.set(coreKeyClass, valueOfMethod.invoke(valueClass, value));
                        continue;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Unable to annotate attribute " + key, ex);
                    }
                }
                chunk.set(coreKeyClass, null);
                continue;
            }
            throw new UnsupportedOperationException("Unknown null attribute.");
        }
    }

    public static void annotateChunks(List<? extends CoreMap> chunks, int start, int end, Map<String, String> attributes) {
        for (int i = start; i < end; ++i) {
            ChunkAnnotationUtils.annotateChunk(chunks.get(i), attributes);
        }
    }

    public static void annotateChunks(List<? extends CoreMap> chunks, Map<String, String> attributes) {
        for (CoreMap coreMap : chunks) {
            ChunkAnnotationUtils.annotateChunk(coreMap, attributes);
        }
    }

    public static <T extends CoreMap> T createCoreMap(CoreMap cm, String text, int start, int end, CoreTokenFactory<T> factory) {
        if (end > start) {
            T token = factory.makeToken();
            Integer cmCharStart = (Integer)cm.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            if (cmCharStart == null) {
                cmCharStart = 0;
            }
            String tokenText = text.substring(start, end);
            token.set(CoreAnnotations.TextAnnotation.class, (String)tokenText);
            if (token instanceof CoreLabel) {
                token.set(CoreAnnotations.ValueAnnotation.class, (String)tokenText);
            }
            token.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, cmCharStart + start);
            token.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, cmCharStart + end);
            return token;
        }
        return null;
    }

    public static <T extends CoreMap> void appendCoreMap(List<T> res, CoreMap cm, String text, int start, int end, CoreTokenFactory<T> factory) {
        T scm = ChunkAnnotationUtils.createCoreMap(cm, text, start, end, factory);
        if (scm != null) {
            res.add(scm);
        }
    }

    public static <T extends CoreMap> List<T> splitCoreMap(Pattern p, boolean includeMatched, CoreMap cm, CoreTokenFactory<T> factory) {
        ArrayList res = new ArrayList();
        String text = (String)cm.get(CoreAnnotations.TextAnnotation.class);
        Matcher m = p.matcher(text);
        int index = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            ChunkAnnotationUtils.appendCoreMap(res, cm, text, index, start, factory);
            if (includeMatched) {
                ChunkAnnotationUtils.appendCoreMap(res, cm, text, start, end, factory);
            }
            index = end;
        }
        ChunkAnnotationUtils.appendCoreMap(res, cm, text, index, text.length(), factory);
        return res;
    }
}

