/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.pipeline.CoreMapAttributeAggregator;
import edu.stanford.nlp.pipeline.LabeledChunkIdentifier;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.util.AcronymMatcher;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PropertiesUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;

public class EntityMentionsAnnotator
implements Annotator {
    private final LabeledChunkIdentifier chunkIdentifier = new LabeledChunkIdentifier();
    private final boolean doAcronyms;
    public static PropertiesUtils.Property[] SUPPORTED_PROPERTIES = new PropertiesUtils.Property[0];
    private static final Function<Pair<CoreLabel, CoreLabel>, Boolean> IS_TOKENS_COMPATIBLE = in -> {
        Number n2;
        Number n1;
        String v2;
        CoreLabel cur = (CoreLabel)in.first;
        CoreLabel prev = (CoreLabel)in.second;
        if (cur == null || prev == null) {
            return false;
        }
        String v1 = (String)cur.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
        if (!EntityMentionsAnnotator.checkStrings(v1, v2 = (String)prev.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class))) {
            return false;
        }
        String nerTag = (String)cur.get(CoreAnnotations.NamedEntityTagAnnotation.class);
        if (("NUMBER".equals(nerTag) || "ORDINAL".equals(nerTag)) && !EntityMentionsAnnotator.checkNumbers(n1 = (Number)cur.get(CoreAnnotations.NumericCompositeValueAnnotation.class), n2 = (Number)prev.get(CoreAnnotations.NumericCompositeValueAnnotation.class))) {
            return false;
        }
        if ("TIME".equals(nerTag) || "SET".equals(nerTag) || "DATE".equals(nerTag) || "DURATION".equals(nerTag)) {
            String tid2;
            Timex timex1 = (Timex)cur.get(TimeAnnotations.TimexAnnotation.class);
            Timex timex2 = (Timex)prev.get(TimeAnnotations.TimexAnnotation.class);
            String tid1 = timex1 != null ? timex1.tid() : null;
            String string = tid2 = timex2 != null ? timex2.tid() : null;
            if (!EntityMentionsAnnotator.checkStrings(tid1, tid2)) {
                return false;
            }
        }
        return true;
    };

    public EntityMentionsAnnotator() {
        this.doAcronyms = false;
    }

    public EntityMentionsAnnotator(String name, Properties props) {
        this.doAcronyms = Boolean.parseBoolean(props.getProperty(name + ".acronyms", props.getProperty("acronyms", "false")));
    }

    private static boolean checkStrings(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return Objects.equals(s1, s2);
        }
        return s1.equals(s2);
    }

    private static boolean checkNumbers(Number n1, Number n2) {
        if (n1 == null || n2 == null) {
            return Objects.equals(n1, n2);
        }
        return n1.equals(n2);
    }

    @Override
    public void annotate(Annotation annotation) {
        ArrayList<CoreMap> allMentions = new ArrayList<CoreMap>();
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        int sentenceIndex = 0;
        for (CoreMap sentence : sentences) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            Integer annoTokenBegin = (Integer)sentence.get(CoreAnnotations.TokenBeginAnnotation.class);
            if (annoTokenBegin == null) {
                annoTokenBegin = 0;
            }
            List<CoreMap> chunks = this.chunkIdentifier.getAnnotatedChunks(tokens, annoTokenBegin, CoreAnnotations.TextAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class, IS_TOKENS_COMPATIBLE);
            sentence.set(CoreAnnotations.MentionsAnnotation.class, chunks);
            List mentions = (List)sentence.get(CoreAnnotations.MentionsAnnotation.class);
            if (mentions != null) {
                for (CoreMap mention : mentions) {
                    List mentionTokens = (List)mention.get(CoreAnnotations.TokensAnnotation.class);
                    String name = (String)CoreMapAttributeAggregator.FIRST_NON_NIL.aggregate(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, mentionTokens);
                    if (name == null) {
                        name = (String)mention.get(CoreAnnotations.TextAnnotation.class);
                    } else {
                        mention.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, name);
                    }
                    String type = (String)mention.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                    mention.set(CoreAnnotations.EntityTypeAnnotation.class, type);
                    mention.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIndex);
                    Timex timex = (Timex)CoreMapAttributeAggregator.FIRST_NON_NIL.aggregate(TimeAnnotations.TimexAnnotation.class, mentionTokens);
                    if (timex != null) {
                        mention.set(TimeAnnotations.TimexAnnotation.class, timex);
                    }
                    if (mention.get(CoreAnnotations.WikipediaEntityAnnotation.class) != null) continue;
                    for (CoreLabel token : mentionTokens) {
                        if (mention.get(CoreAnnotations.WikipediaEntityAnnotation.class) != null && !"O".equals(mention.get(CoreAnnotations.WikipediaEntityAnnotation.class)) || token.get(CoreAnnotations.WikipediaEntityAnnotation.class) == null || "O".equals(token.get(CoreAnnotations.WikipediaEntityAnnotation.class))) continue;
                        mention.set(CoreAnnotations.WikipediaEntityAnnotation.class, token.get(CoreAnnotations.WikipediaEntityAnnotation.class));
                    }
                }
            }
            if (mentions != null) {
                allMentions.addAll(mentions);
            }
            ++sentenceIndex;
        }
        if (this.doAcronyms) {
            EntityMentionsAnnotator.addAcronyms(annotation, allMentions);
        }
        annotation.set(CoreAnnotations.MentionsAnnotation.class, allMentions);
    }

    private static void addAcronyms(Annotation ann, List<CoreMap> mentions) {
        ArrayList organizations = new ArrayList();
        for (CoreMap mention : mentions) {
            if (!"ORGANIZATION".equals(mention.get(CoreAnnotations.NamedEntityTagAnnotation.class))) continue;
            organizations.add(mention.get(CoreAnnotations.TokensAnnotation.class));
        }
        if (organizations.size() > 100) {
            return;
        }
        for (CoreMap sentence : (List)ann.get(CoreAnnotations.SentencesAnnotation.class)) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            Integer totalTokensOffset = (Integer)sentence.get(CoreAnnotations.TokenBeginAnnotation.class);
            for (int i = 0; i < tokens.size(); ++i) {
                CoreLabel token = (CoreLabel)tokens.get(i);
                if (!"O".equals(token.ner()) || !token.word().toUpperCase().equals(token.word()) || token.word().length() < 3) continue;
                for (List org : organizations) {
                    if (!AcronymMatcher.isAcronym(token.word(), org)) continue;
                    token.setNER("ORGANIZATION");
                    Annotation chunk = ChunkAnnotationUtils.getAnnotatedChunk(tokens, i, i + 1, totalTokensOffset, null, null, null);
                    chunk.set(CoreAnnotations.NamedEntityTagAnnotation.class, "ORGANIZATION");
                    mentions.add(chunk);
                }
            }
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(CoreAnnotations.MentionsAnnotation.class);
    }
}

