/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.FileSequentialCollection;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.CoNLLOutputter;
import edu.stanford.nlp.pipeline.JSONOutputter;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.pipeline.TextOutputter;
import edu.stanford.nlp.pipeline.XMLOutputter;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.StanfordRedwoodConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StanfordCoreNLPClient
extends AnnotationPipeline {
    private static final Redwood.RedwoodChannels log = Redwood.channels(StanfordCoreNLPClient.class);
    private static final Pattern URL_PATTERN = Pattern.compile("(?:(https?)://)?([^:]+):([0-9]+)?");
    private final String path = "";
    private final Properties properties;
    private final String propsAsJSON;
    private final String apiKey;
    private final String apiSecret;
    private final BackendScheduler scheduler;
    private final ProtobufAnnotationSerializer serializer = new ProtobufAnnotationSerializer(true);

    private StanfordCoreNLPClient(Properties properties, List<Backend> backends, String apiKey, String apiSecret) {
        this.properties = properties;
        Properties serverProperties = new Properties();
        for (String key2 : properties.stringPropertyNames()) {
            serverProperties.setProperty(key2, properties.getProperty(key2));
        }
        Collections.shuffle(backends, new Random(System.currentTimeMillis()));
        this.scheduler = new BackendScheduler(backends);
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        serverProperties.setProperty("inputFormat", "serialized");
        serverProperties.setProperty("outputFormat", "serialized");
        serverProperties.setProperty("inputSerializer", ProtobufAnnotationSerializer.class.getName());
        serverProperties.setProperty("outputSerializer", ProtobufAnnotationSerializer.class.getName());
        List jsonProperties = serverProperties.stringPropertyNames().stream().map(key -> '\"' + JSONOutputter.cleanJSON(key) + "\": \"" + JSONOutputter.cleanJSON(serverProperties.getProperty((String)key)) + '\"').collect(Collectors.toList());
        this.propsAsJSON = "{ " + StringUtils.join(jsonProperties, ", ") + " }";
        this.scheduler.start();
    }

    private StanfordCoreNLPClient(Properties properties, List<Backend> backends) {
        this(properties, backends, null, null);
    }

    public StanfordCoreNLPClient(Properties properties) throws IllegalStateException {
        this(properties, Optional.ofNullable(System.getenv("CORENLP_HOST")).orElseThrow(() -> new IllegalStateException("Environment variable CORENLP_HOST not specified")), Optional.ofNullable(System.getenv("CORENLP_HOST")).map(x -> x.startsWith("http://") ? 80 : 443).orElse(443), 1, Optional.ofNullable(System.getenv("CORENLP_KEY")).orElse(null), Optional.ofNullable(System.getenv("CORENLP_SECRET")).orElse(null));
    }

    public StanfordCoreNLPClient(Properties properties, String host, int port) {
        this(properties, host, port, 1);
    }

    public StanfordCoreNLPClient(Properties properties, String host, int port, String apiKey, String apiSecret) {
        this(properties, host, port, 1, apiKey, apiSecret);
    }

    public StanfordCoreNLPClient(Properties properties, String host, String apiKey, String apiSecret) {
        this(properties, host, host.startsWith("http://") ? 80 : 443, 1, apiKey, apiSecret);
    }

    public StanfordCoreNLPClient(Properties properties, String host, int port, int threads) {
        this(properties, host, port, threads, null, null);
    }

    public StanfordCoreNLPClient(Properties properties, final String host, final int port, final int threads, String apiKey, String apiSecret) {
        this(properties, (List<Backend>)new ArrayList<Backend>(){
            {
                for (int i = 0; i < threads; ++i) {
                    this.add(new Backend(host.startsWith("http://") ? "http" : "https", host.startsWith("http://") ? host.substring("http://".length()) : (host.startsWith("https://") ? host.substring("https://".length()) : host), port));
                }
            }
        }, apiKey, apiSecret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void annotate(Annotation annotation) {
        ReentrantLock lock = new ReentrantLock();
        Condition annotationDone = lock.newCondition();
        this.annotate(Collections.singleton(annotation), 1, annInput -> {
            try {
                lock.lock();
                annotationDone.signal();
            }
            finally {
                lock.unlock();
            }
        });
        try {
            lock.lock();
            annotationDone.await();
        }
        catch (InterruptedException e) {
            log.info("Interrupt while waiting for annotation to return");
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void annotate(Iterable<Annotation> annotations, int numThreads, Consumer<Annotation> callback) {
        for (Annotation annotation : annotations) {
            this.annotate(annotation, callback);
        }
    }

    public void annotate(Annotation annotation, Consumer<Annotation> callback) {
        this.scheduler.schedule((backend, isFinishedCallback) -> new Thread(() -> {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.serializer.write(annotation, os);
                os.close();
                byte[] message = os.toByteArray();
                String queryParams = String.format("properties=%s", URLEncoder.encode(this.propsAsJSON, "utf-8"));
                URL serverURL = new URL(backend.protocol, backend.host, backend.port, this.path + '?' + queryParams);
                this.doAnnotation(annotation, (Backend)backend, serverURL, message, 0);
            }
            catch (Throwable t) {
                log.warn("Could not annotate via server! Trying to annotate locally...", t);
                StanfordCoreNLP corenlp = new StanfordCoreNLP(this.properties);
                corenlp.annotate(annotation);
            }
            finally {
                callback.accept(annotation);
                isFinishedCallback.accept(backend);
            }
        }).start());
    }

    private void doAnnotation(Annotation annotation, Backend backend, URL serverURL, byte[] message, int tries) {
        try {
            URLConnection connection = serverURL.openConnection();
            if (this.apiKey != null && this.apiSecret != null) {
                String userpass = this.apiKey + ":" + this.apiSecret;
                String basicAuth = "Basic " + new String(Base64.getEncoder().encode(userpass.getBytes()));
                connection.setRequestProperty("Authorization", basicAuth);
            }
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-protobuf");
            connection.setRequestProperty("Content-Length", Integer.toString(message.length));
            connection.setRequestProperty("Accept-Charset", "utf-8");
            connection.setRequestProperty("User-Agent", StanfordCoreNLPClient.class.getName());
            switch (backend.protocol) {
                case "https": 
                case "http": {
                    ((HttpURLConnection)connection).setRequestMethod("POST");
                    break;
                }
                default: {
                    throw new IllegalStateException("Haven't implemented protocol: " + backend.protocol);
                }
            }
            connection.connect();
            connection.getOutputStream().write(message);
            connection.getOutputStream().flush();
            Annotation response = (Annotation)this.serializer.read((InputStream)connection.getInputStream()).first;
            for (Class<?> key : response.keySet()) {
                annotation.set(key, response.get(key));
            }
        }
        catch (Throwable t) {
            if (tries < 3) {
                log.warn(t);
                this.doAnnotation(annotation, backend, serverURL, message, tries + 1);
            }
            throw new RuntimeException(t);
        }
    }

    public Annotation process(String text) {
        Annotation annotation = new Annotation(text);
        this.annotate(annotation);
        return annotation;
    }

    private static void shell(StanfordCoreNLPClient pipeline) throws IOException {
        log.info("Entering interactive shell. Type q RETURN or EOF to quit.");
        StanfordCoreNLP.OutputFormat outputFormat = StanfordCoreNLP.OutputFormat.valueOf(pipeline.properties.getProperty("outputFormat", "text").toUpperCase());
        IOUtils.console("NLP> ", line -> {
            if (!line.isEmpty()) {
                Annotation anno = pipeline.process((String)line);
                try {
                    switch (outputFormat) {
                        case XML: {
                            new XMLOutputter().print(anno, System.out);
                            break;
                        }
                        case JSON: {
                            new JSONOutputter().print(anno, System.out);
                            System.out.println();
                            break;
                        }
                        case CONLL: {
                            new CoNLLOutputter().print(anno, System.out);
                            System.out.println();
                            break;
                        }
                        case TEXT: {
                            new TextOutputter().print(anno, System.out);
                            break;
                        }
                        case SERIALIZED: {
                            Redwood.Util.warn("You probably cannot read the serialized output, so printing in text instead");
                            new TextOutputter().print(anno, System.out);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Cannot output in format " + (Object)((Object)outputFormat) + " from the interactive shell");
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        });
    }

    public void run() throws IOException {
        StanfordRedwoodConfiguration.minimalSetup();
        StanfordCoreNLP.OutputFormat outputFormat = StanfordCoreNLP.OutputFormat.valueOf(this.properties.getProperty("outputFormat", "text").toUpperCase());
        if (this.properties.containsKey("file") || this.properties.containsKey("textFile")) {
            String fileName = this.properties.getProperty("file");
            if (fileName == null) {
                fileName = this.properties.getProperty("textFile");
            }
            FileSequentialCollection files = new FileSequentialCollection(new File(fileName), this.properties.getProperty("extension"), true);
            StanfordCoreNLP.processFiles(null, files, 1, this.properties, this::annotate, StanfordCoreNLP.createOutputter(this.properties, new AnnotationOutputter.Options()), outputFormat);
        } else if (this.properties.containsKey("filelist")) {
            String fileName = this.properties.getProperty("filelist");
            Collection<File> inputFiles = StanfordCoreNLP.readFileList(fileName);
            ArrayList<File> files = new ArrayList<File>(inputFiles.size());
            for (File file : inputFiles) {
                if (file.isDirectory()) {
                    files.addAll(new FileSequentialCollection(new File(fileName), this.properties.getProperty("extension"), true));
                    continue;
                }
                files.add(file);
            }
            StanfordCoreNLP.processFiles(null, files, 1, this.properties, this::annotate, StanfordCoreNLP.createOutputter(this.properties, new AnnotationOutputter.Options()), outputFormat);
        } else {
            StanfordCoreNLPClient.shell(this);
        }
    }

    public void shutdown() throws InterruptedException {
        this.scheduler.stateLock.lock();
        try {
            while (!this.scheduler.queue.isEmpty() || this.scheduler.freeAnnotators.size() != this.scheduler.backends.size()) {
                this.scheduler.shouldShutdown.await(5L, TimeUnit.SECONDS);
            }
            this.scheduler.doRun = false;
            this.scheduler.enqueued.signalAll();
        }
        finally {
            this.scheduler.stateLock.unlock();
        }
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Properties props = StringUtils.argsToProperties(args);
        boolean hasH = props.containsKey("h");
        boolean hasHelp = props.containsKey("help");
        if (hasH || hasHelp) {
            String helpValue = hasH ? props.getProperty("h") : props.getProperty("help");
            StanfordCoreNLP.printHelp(System.err, helpValue);
            return;
        }
        ArrayList<Backend> backends = new ArrayList<Backend>();
        Object defaultBack = "http://localhost:9000";
        String backStr = props.getProperty("backends");
        if (backStr == null) {
            String[] host = props.getProperty("host");
            String port = props.getProperty("port");
            if (host != null) {
                defaultBack = port != null ? (String)host + ':' + port : host;
            }
        }
        for (String spec : props.getProperty("backends", (String)defaultBack).split(",")) {
            Matcher matcher = URL_PATTERN.matcher(spec.trim());
            if (!matcher.matches()) continue;
            String protocol = matcher.group(1);
            if (protocol == null) {
                protocol = "http";
            }
            String host = matcher.group(2);
            int port = 80;
            String portStr = matcher.group(3);
            if (portStr != null) {
                port = Integer.parseInt(portStr);
            }
            backends.add(new Backend(protocol, host, port));
        }
        log.info("Using backends: " + backends);
        StanfordCoreNLPClient client = new StanfordCoreNLPClient(props, backends);
        client.run();
        try {
            client.shutdown();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class BackendScheduler
    extends Thread {
        public final List<Backend> backends;
        private final Queue<BiConsumer<Backend, Consumer<Backend>>> queue;
        private final Lock stateLock = new ReentrantLock();
        private final Condition enqueued = this.stateLock.newCondition();
        public final Condition shouldShutdown = this.stateLock.newCondition();
        private final Queue<Backend> freeAnnotators;
        private final Condition newlyFree = this.stateLock.newCondition();
        private boolean doRun = true;

        public BackendScheduler(List<Backend> backends) {
            this.setDaemon(true);
            this.backends = backends;
            this.freeAnnotators = new LinkedList<Backend>(backends);
            this.queue = new LinkedList<BiConsumer<Backend, Consumer<Backend>>>();
        }

        @Override
        public void run() {
            try {
                while (this.doRun) {
                    Backend annotator;
                    BiConsumer<Backend, Consumer<Backend>> request;
                    this.stateLock.lock();
                    try {
                        while (this.queue.isEmpty()) {
                            this.enqueued.await();
                            if (this.doRun) continue;
                            return;
                        }
                        request = this.queue.poll();
                        while (this.freeAnnotators.isEmpty()) {
                            this.newlyFree.await();
                        }
                        annotator = this.freeAnnotators.poll();
                    }
                    finally {
                        this.stateLock.unlock();
                    }
                    request.accept(annotator, freedAnnotator -> {
                        this.stateLock.lock();
                        try {
                            this.freeAnnotators.add((Backend)freedAnnotator);
                            if (this.queue.isEmpty() && this.freeAnnotators.size() == this.backends.size()) {
                                log.info("All annotations completed. Signaling for shutdown");
                                this.shouldShutdown.signalAll();
                            }
                            this.newlyFree.signal();
                        }
                        finally {
                            this.stateLock.unlock();
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void schedule(BiConsumer<Backend, Consumer<Backend>> annotate) {
            this.stateLock.lock();
            try {
                this.queue.add(annotate);
                this.enqueued.signal();
            }
            finally {
                this.stateLock.unlock();
            }
        }
    }

    private static class Backend {
        public final String protocol;
        public final String host;
        public final int port;

        public Backend(String protocol, String host, int port) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Backend)) {
                return false;
            }
            Backend backend = (Backend)o;
            return this.port == backend.port && this.protocol.equals(backend.protocol) && this.host.equals(backend.host);
        }

        public int hashCode() {
            throw new IllegalStateException("Hashing backends is dangerous!");
        }

        public String toString() {
            return this.protocol + "://" + this.host + ":" + this.port;
        }
    }
}

