/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import com.sun.net.httpserver.BasicAuthenticator;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.TokenSequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.AnnotatorImplementations;
import edu.stanford.nlp.pipeline.AnnotatorPool;
import edu.stanford.nlp.pipeline.JSONOutputter;
import edu.stanford.nlp.pipeline.LanguageInfo;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class StanfordCoreNLPServer
implements Runnable {
    protected HttpServer server;
    @ArgumentParser.Option(name="port", gloss="The port to run the server on")
    protected int serverPort;
    @ArgumentParser.Option(name="status_port", gloss="The port to serve the status check endpoints on. If different from the server port, this will run in a separate thread.")
    protected int statusPort;
    @ArgumentParser.Option(name="timeout", gloss="The default timeout, in milliseconds")
    protected int timeoutMilliseconds;
    @ArgumentParser.Option(name="strict", gloss="If true, obey strict HTTP standards (e.g., with encoding)")
    protected boolean strict;
    @ArgumentParser.Option(name="quiet", gloss="If true, don't print to stdout")
    protected boolean quiet;
    @ArgumentParser.Option(name="ssl", gloss="If true, start the server with an [insecure!] SSL connection")
    protected boolean ssl;
    @ArgumentParser.Option(name="key", gloss="The *.jks key file to load, if -ssl is enabled. By default, it'll load the dummy key from the jar (but this is, of course, insecure!)")
    protected static String key = "edu/stanford/nlp/pipeline/corenlp.jks";
    @ArgumentParser.Option(name="username", gloss="The username component of a username/password basic auth credential")
    protected String username;
    @ArgumentParser.Option(name="password", gloss="The password component of a username/password basic auth credential")
    protected String password;
    @ArgumentParser.Option(name="annotators", gloss="The default annotators to run over a given sentence.")
    protected static String defaultAnnotators = "tokenize,ssplit,pos,lemma,ner,parse,depparse,mention,coref,natlog,openie,regexner,kbp";
    @ArgumentParser.Option(name="preload", gloss="Cache the following annotators on startup")
    protected static String preloadedAnnotators = "";
    @ArgumentParser.Option(name="serverProperties", gloss="Default properties file for server's StanfordCoreNLP instance")
    protected static String serverPropertiesPath = null;
    protected final String shutdownKey;
    public static int MAX_CHAR_LENGTH = 100000;
    public final Properties defaultProps;
    private final ExecutorService serverExecutor;
    private final WeakHashMap<Properties, StanfordCoreNLP> pipelineCache;
    private final ExecutorService corenlpExecutor;

    public StanfordCoreNLPServer(int port, int timeout, boolean strict) throws IOException {
        this();
        this.serverPort = port;
        this.timeoutMilliseconds = timeout;
        this.strict = strict;
    }

    public StanfordCoreNLPServer() throws IOException {
        String defaultParserPath;
        this.statusPort = this.serverPort = 9000;
        this.timeoutMilliseconds = 15000;
        this.strict = false;
        this.quiet = false;
        this.ssl = false;
        this.username = null;
        this.password = null;
        this.pipelineCache = new WeakHashMap();
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL srResource = classLoader.getResource("edu/stanford/nlp/models/srparser/englishSR.ser.gz");
        Redwood.Util.log("setting default constituency parser");
        if (srResource != null) {
            defaultParserPath = "edu/stanford/nlp/models/srparser/englishSR.ser.gz";
            Redwood.Util.log("using SR parser: edu/stanford/nlp/models/srparser/englishSR.ser.gz");
        } else {
            defaultParserPath = "edu/stanford/nlp/models/lexparser/englishPCFG.ser.gz";
            Redwood.Util.log("warning: cannot find edu/stanford/nlp/models/srparser/englishSR.ser.gz");
            Redwood.Util.log("using: edu/stanford/nlp/models/lexparser/englishPCFG.ser.gz instead");
            Redwood.Util.log("to use shift reduce parser download English models jar from:");
            Redwood.Util.log("http://stanfordnlp.github.io/CoreNLP/download.html");
        }
        this.defaultProps = PropertiesUtils.asProperties("annotators", defaultAnnotators, "mention.type", "dep", "coref.mode", "statistical", "coref.language", "en", "inputFormat", "text", "outputFormat", "json", "prettyPrint", "false", "parse.model", defaultParserPath, "parse.binaryTrees", "true", "openie.strip_entailments", "true");
        if (serverPropertiesPath != null) {
            Properties serverProperties = StringUtils.argsToProperties("-props", serverPropertiesPath);
            PropertiesUtils.overWriteProperties(this.defaultProps, serverProperties);
        }
        this.serverExecutor = Executors.newFixedThreadPool(ArgumentParser.threads);
        this.corenlpExecutor = Executors.newFixedThreadPool(ArgumentParser.threads);
        String tmpDir = System.getProperty("java.io.tmpdir");
        File tmpFile = new File(tmpDir + File.separator + "corenlp.shutdown");
        tmpFile.deleteOnExit();
        if (tmpFile.exists() && !tmpFile.delete()) {
            throw new IllegalStateException("Could not delete shutdown key file");
        }
        this.shutdownKey = new BigInteger(130, new Random()).toString(32);
        IOUtils.writeStringToFile(this.shutdownKey, tmpFile.getPath(), "utf-8");
    }

    private static Map<String, String> getURLParams(URI uri) throws UnsupportedEncodingException {
        if (uri.getQuery() != null) {
            String[] queryFields;
            HashMap<String, String> urlParams = new HashMap<String, String>();
            String query = uri.getQuery();
            for (String queryField : queryFields = query.replaceAll("\\\\&", "___AMP___").replaceAll("\\\\+", "___PLUS___").split("&")) {
                int firstEq = queryField.indexOf(61);
                String key = URLDecoder.decode(queryField.substring(0, firstEq), "utf8").replaceAll("___AMP___", "&").replaceAll("___PLUS___", "+");
                String value = URLDecoder.decode(queryField.substring(firstEq + 1), "utf8").replaceAll("___AMP___", "&").replaceAll("___PLUS___", "+");
                urlParams.put(key, value);
            }
            return urlParams;
        }
        return Collections.emptyMap();
    }

    private Annotation getDocument(Properties props, HttpExchange httpExchange) throws IOException, ClassNotFoundException {
        String inputFormat = props.getProperty("inputFormat", "text");
        String date = props.getProperty("date");
        switch (inputFormat) {
            case "text": {
                String[] charsetPair;
                String defaultEncoding = this.strict ? "ISO-8859-1" : "UTF-8";
                Headers h = httpExchange.getRequestHeaders();
                String encoding = h.containsKey("Content-type") ? ((charsetPair = Arrays.stream(h.getFirst("Content-type").split(";")).map(x -> x.split("=")).filter(x -> ((String[])x).length > 0 && "charset".equals(x[0])).findFirst().orElse(new String[]{"charset", defaultEncoding})).length == 2 ? charsetPair[1] : defaultEncoding) : defaultEncoding;
                String text = IOUtils.slurpReader(IOUtils.encodedInputStreamReader(httpExchange.getRequestBody(), encoding));
                text = text.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
                text = text.replaceAll("\\+", "%2B");
                text = URLDecoder.decode(text, encoding).trim();
                Annotation annotation = new Annotation(text);
                if (date != null) {
                    annotation.set(CoreAnnotations.DocDateAnnotation.class, date);
                }
                return annotation;
            }
            case "serialized": {
                String inputSerializerName = props.getProperty("inputSerializer", ProtobufAnnotationSerializer.class.getName());
                AnnotationSerializer serializer = (AnnotationSerializer)MetaClass.create(inputSerializerName).createInstance(new Object[0]);
                Pair<Annotation, InputStream> pair = serializer.read(httpExchange.getRequestBody());
                return (Annotation)pair.first;
            }
        }
        throw new IOException("Could not parse input format: " + inputFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StanfordCoreNLP mkStanfordCoreNLP(Properties props) {
        StanfordCoreNLP impl;
        WeakHashMap<Properties, StanfordCoreNLP> weakHashMap = this.pipelineCache;
        synchronized (weakHashMap) {
            impl = this.pipelineCache.get(props);
            if (impl == null) {
                AnnotatorPool pool = StanfordCoreNLP.constructAnnotatorPool(props, new AnnotatorImplementations());
                impl = new StanfordCoreNLP(props, pool);
                this.pipelineCache.put(props, impl);
            }
        }
        return impl;
    }

    private static void respondError(String response, HttpExchange httpExchange) throws IOException {
        httpExchange.getResponseHeaders().add("Content-type", "text/plain");
        httpExchange.sendResponseHeaders(500, response.length());
        httpExchange.getResponseBody().write(response.getBytes());
        httpExchange.close();
    }

    private static void respondBadInput(String response, HttpExchange httpExchange) throws IOException {
        httpExchange.getResponseHeaders().add("Content-type", "text/plain");
        httpExchange.sendResponseHeaders(400, response.length());
        httpExchange.getResponseBody().write(response.getBytes());
        httpExchange.close();
    }

    private static void respondUnauthorized(HttpExchange httpExchange) throws IOException {
        httpExchange.getResponseHeaders().add("Content-type", "application/javascript");
        byte[] content = "{\"message\": \"Unauthorized API request\"}".getBytes("utf-8");
        httpExchange.sendResponseHeaders(401, content.length);
        httpExchange.getResponseBody().write(content);
        httpExchange.close();
    }

    private static void sendAndGetResponse(HttpExchange httpExchange, byte[] response) throws IOException {
        if (response.length > 0) {
            httpExchange.getResponseHeaders().add("Content-type", "application/json");
            httpExchange.getResponseHeaders().add("Content-length", Integer.toString(response.length));
            httpExchange.sendResponseHeaders(200, response.length);
            httpExchange.getResponseBody().write(response);
            httpExchange.close();
        }
    }

    private static HttpsServer addSSLContext(HttpsServer server) {
        Redwood.Util.log("Adding SSL context to server; key=" + key);
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            if (key == null || !IOUtils.existsInClasspathOrFileSystem(key)) {
                throw new IllegalArgumentException("Could not find SSL keystore at " + key);
            }
            ks.load(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(key), "corenlp".toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, "corenlp".toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), null, null);
            server.setHttpsConfigurator(new HttpsConfigurator(sslContext){

                @Override
                public void configure(HttpsParameters params) {
                    SSLContext context = this.getSSLContext();
                    SSLEngine engine = context.createSSLEngine();
                    params.setNeedClientAuth(false);
                    params.setCipherSuites(engine.getEnabledCipherSuites());
                    params.setProtocols(engine.getEnabledProtocols());
                    params.setSSLParameters(context.getDefaultSSLParameters());
                }
            });
            return server;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private void livenessServer(AtomicBoolean live) {
        if (this.serverPort != this.statusPort) {
            try {
                this.server = this.ssl ? StanfordCoreNLPServer.addSSLContext(HttpsServer.create(new InetSocketAddress(this.statusPort), 0)) : HttpServer.create(new InetSocketAddress(this.statusPort), 0);
                this.withAuth(this.server.createContext("/live", new LiveHandler()), Optional.empty());
                this.withAuth(this.server.createContext("/ready", new ReadyHandler(live)), Optional.empty());
                this.server.start();
                Redwood.Util.log("Liveness server started at " + this.server.getAddress());
            }
            catch (IOException e) {
                Redwood.Util.err("Could not start liveness server. This will probably result in very bad things happening soon.", e);
            }
        }
    }

    public Optional<HttpServer> getServer() {
        return Optional.ofNullable(this.server);
    }

    @Override
    public void run() {
        try {
            AtomicBoolean live = new AtomicBoolean(false);
            this.livenessServer(live);
            FileHandler homepage = new FileHandler("edu/stanford/nlp/pipeline/demo/corenlp-brat.html");
            this.run(Optional.empty(), req -> true, obj -> {}, homepage, false, live);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void withAuth(HttpContext context, Optional<Pair<String, String>> credentials) {
        credentials.ifPresent(c -> context.setAuthenticator(new BasicAuthenticator("corenlp", (Pair)c){
            final /* synthetic */ Pair val$c;
            {
                this.val$c = pair;
                super(x0);
            }

            @Override
            public boolean checkCredentials(String user, String pwd) {
                return user.equals(this.val$c.first) && pwd.equals(this.val$c.second);
            }
        }));
    }

    public void run(Optional<Pair<String, String>> basicAuth, Predicate<Properties> authenticator, Consumer<FinishedRequest> callback, FileHandler homepage, boolean https, AtomicBoolean live) {
        try {
            this.server = https ? StanfordCoreNLPServer.addSSLContext(HttpsServer.create(new InetSocketAddress(this.serverPort), 0)) : HttpServer.create(new InetSocketAddress(this.serverPort), 0);
            this.withAuth(this.server.createContext("/", new CoreNLPHandler(this.defaultProps, authenticator, callback, homepage)), basicAuth);
            this.withAuth(this.server.createContext("/tokensregex", new TokensRegexHandler(authenticator, callback)), basicAuth);
            this.withAuth(this.server.createContext("/semgrex", new SemgrexHandler(authenticator, callback)), basicAuth);
            this.withAuth(this.server.createContext("/tregex", new TregexHandler(authenticator, callback)), basicAuth);
            this.withAuth(this.server.createContext("/corenlp-brat.js", new FileHandler("edu/stanford/nlp/pipeline/demo/corenlp-brat.js", "application/javascript")), basicAuth);
            this.withAuth(this.server.createContext("/corenlp-brat.cs", new FileHandler("edu/stanford/nlp/pipeline/demo/corenlp-brat.css", "text/css")), basicAuth);
            this.withAuth(this.server.createContext("/corenlp-parseviewer.js", new FileHandler("edu/stanford/nlp/pipeline/demo/corenlp-parseviewer.js", "application/javascript")), basicAuth);
            this.withAuth(this.server.createContext("/ping", new PingHandler()), Optional.empty());
            this.withAuth(this.server.createContext("/shutdown", new ShutdownHandler()), basicAuth);
            if (this.serverPort == this.statusPort) {
                this.withAuth(this.server.createContext("/live", new LiveHandler()), Optional.empty());
                this.withAuth(this.server.createContext("/ready", new ReadyHandler(live)), Optional.empty());
            }
            this.server.setExecutor(this.serverExecutor);
            this.server.start();
            live.set(true);
            Redwood.Util.log("StanfordCoreNLPServer listening at " + this.server.getAddress());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        FileHandler homepage;
        Redwood.Util.log("--- " + StanfordCoreNLPServer.class.getSimpleName() + "#main() called ---");
        String build = System.getenv("BUILD");
        if (build != null) {
            Redwood.Util.log("    Build: " + build);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Redwood.Util.log("CoreNLP Server is shutting down.")));
        ArgumentParser.fillOptions(StanfordCoreNLPServer.class, args);
        StanfordCoreNLPServer server = new StanfordCoreNLPServer();
        ArgumentParser.fillOptions((Object)server, args);
        Redwood.Util.log("    Threads: " + ArgumentParser.threads);
        AtomicBoolean live = new AtomicBoolean(false);
        server.livenessServer(live);
        try {
            homepage = new FileHandler("edu/stanford/nlp/pipeline/demo/corenlp-brat.html");
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        if (preloadedAnnotators != null && !"".equals(preloadedAnnotators.trim())) {
            Properties props = new Properties();
            server.defaultProps.entrySet().forEach(entry -> props.setProperty(entry.getKey().toString(), entry.getValue().toString()));
            props.setProperty("annotators", preloadedAnnotators);
            try {
                new StanfordCoreNLP(props);
            }
            catch (Throwable ignored) {
                Redwood.Util.err("Could not pre-load annotators in server; encountered exception:");
                ignored.printStackTrace();
            }
        }
        Optional<Pair<String, String>> credentials = Optional.empty();
        if (server.username != null && server.password != null) {
            credentials = Optional.of(Pair.makePair(server.username, server.password));
        }
        Redwood.Util.log("Starting server...");
        if (server.ssl) {
            server.run(credentials, req -> true, res -> {}, homepage, true, live);
        } else {
            server.run(credentials, req -> true, res -> {}, homepage, false, live);
        }
    }

    protected class TregexHandler
    implements HttpHandler {
        private final Consumer<FinishedRequest> callback;
        private final Predicate<Properties> authenticator;

        public TregexHandler(Predicate<Properties> authenticator, Consumer<FinishedRequest> callback) {
            this.callback = callback;
            this.authenticator = authenticator;
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
            Properties props = PropertiesUtils.asProperties("annotators", "tokenize,ssplit,parse");
            if (this.authenticator != null && !this.authenticator.test(props)) {
                StanfordCoreNLPServer.respondUnauthorized(httpExchange);
                return;
            }
            Map params = StanfordCoreNLPServer.getURLParams(httpExchange.getRequestURI());
            Future<Pair> response = StanfordCoreNLPServer.this.corenlpExecutor.submit(() -> {
                try {
                    Annotation doc = StanfordCoreNLPServer.this.getDocument(props, httpExchange);
                    if (!doc.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
                        StanfordCoreNLP pipeline = StanfordCoreNLPServer.this.mkStanfordCoreNLP(props);
                        pipeline.annotate(doc);
                    }
                    if (!params.containsKey("pattern")) {
                        StanfordCoreNLPServer.respondBadInput("Missing required parameter 'pattern'", httpExchange);
                        return Pair.makePair("", null);
                    }
                    String pattern = (String)params.get("pattern");
                    TregexPattern p = TregexPattern.compile(pattern);
                    return Pair.makePair(JSONOutputter.JSONWriter.objectToJSON(docWriter -> docWriter.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> sentWriter -> {
                        Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
                        TregexMatcher matcher = p.matcher(tree);
                        int i = 0;
                        while (matcher.find()) {
                            sentWriter.set(Integer.toString(i++), matchWriter -> {
                                matchWriter.set("match", matcher.getMatch().pennString());
                                matchWriter.set("namedNodes", matcher.getNodeNames().stream().map(nodeName -> namedNodeWriter -> namedNodeWriter.set((String)nodeName, matcher.getNode((String)nodeName).pennString())));
                            });
                        }
                    }))), doc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        StanfordCoreNLPServer.respondError(e.getClass().getName() + ": " + e.getMessage(), httpExchange);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return Pair.makePair("", null);
                }
            });
            try {
                Pair pair = response.get(5L, TimeUnit.SECONDS);
                Annotation completedAnnotation = (Annotation)pair.second;
                byte[] content = ((String)pair.first).getBytes();
                StanfordCoreNLPServer.sendAndGetResponse(httpExchange, content);
                if (completedAnnotation != null && !StringUtils.isNullOrEmpty(props.getProperty("annotators"))) {
                    this.callback.accept(new FinishedRequest(props, completedAnnotation, (String)params.get("pattern"), null));
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                StanfordCoreNLPServer.respondError("Timeout when executing Tregex query", httpExchange);
            }
        }
    }

    protected class SemgrexHandler
    implements HttpHandler {
        private final Consumer<FinishedRequest> callback;
        private final Predicate<Properties> authenticator;

        public SemgrexHandler(Predicate<Properties> authenticator, Consumer<FinishedRequest> callback) {
            this.callback = callback;
            this.authenticator = authenticator;
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
            Properties props = PropertiesUtils.asProperties("annotators", "tokenize,ssplit,pos,lemma,ner,depparse");
            if (this.authenticator != null && !this.authenticator.test(props)) {
                StanfordCoreNLPServer.respondUnauthorized(httpExchange);
                return;
            }
            Map params = StanfordCoreNLPServer.getURLParams(httpExchange.getRequestURI());
            Future<Pair> response = StanfordCoreNLPServer.this.corenlpExecutor.submit(() -> {
                try {
                    Annotation doc = StanfordCoreNLPServer.this.getDocument(props, httpExchange);
                    if (!doc.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
                        StanfordCoreNLP pipeline = StanfordCoreNLPServer.this.mkStanfordCoreNLP(props);
                        pipeline.annotate(doc);
                    }
                    if (!params.containsKey("pattern")) {
                        StanfordCoreNLPServer.respondBadInput("Missing required parameter 'pattern'", httpExchange);
                        return Pair.makePair("", null);
                    }
                    String pattern = (String)params.get("pattern");
                    String filterStr = params.getOrDefault("filter", "false");
                    boolean filter = filterStr.trim().isEmpty() || "true".equalsIgnoreCase(filterStr.toLowerCase());
                    SemgrexPattern regex = SemgrexPattern.compile(pattern);
                    return Pair.makePair(JSONOutputter.JSONWriter.objectToJSON(docWriter -> {
                        if (filter) {
                            docWriter.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> regex.matcher((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class)).matches()).collect(Collectors.toList()));
                        } else {
                            docWriter.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> sentWriter -> {
                                SemgrexMatcher matcher = regex.matcher((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class));
                                int i = 0;
                                while (matcher.find()) {
                                    sentWriter.set(Integer.toString(i), matchWriter -> {
                                        IndexedWord match = matcher.getMatch();
                                        matchWriter.set("text", match.word());
                                        matchWriter.set("begin", match.index() - 1);
                                        matchWriter.set("end", match.index());
                                        for (String capture : matcher.getNodeNames()) {
                                            matchWriter.set("$" + capture, groupWriter -> {
                                                IndexedWord node = matcher.getNode(capture);
                                                groupWriter.set("text", node.word());
                                                groupWriter.set("begin", node.index() - 1);
                                                groupWriter.set("end", node.index());
                                            });
                                        }
                                    });
                                    ++i;
                                }
                                sentWriter.set("length", i);
                            }));
                        }
                    }), doc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        StanfordCoreNLPServer.respondError(e.getClass().getName() + ": " + e.getMessage(), httpExchange);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return Pair.makePair("", null);
                }
            });
            try {
                Pair pair = response.get(5L, TimeUnit.SECONDS);
                Annotation completedAnnotation = (Annotation)pair.second;
                byte[] content = ((String)pair.first).getBytes();
                StanfordCoreNLPServer.sendAndGetResponse(httpExchange, content);
                if (completedAnnotation != null && props.getProperty("annotators") != null && !"".equals(props.getProperty("annotators"))) {
                    this.callback.accept(new FinishedRequest(props, completedAnnotation, (String)params.get("pattern"), null));
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                StanfordCoreNLPServer.respondError("Timeout when executing Semgrex query", httpExchange);
            }
        }
    }

    protected class TokensRegexHandler
    implements HttpHandler {
        private final Consumer<FinishedRequest> callback;
        private final Predicate<Properties> authenticator;

        public TokensRegexHandler(Predicate<Properties> authenticator, Consumer<FinishedRequest> callback) {
            this.callback = callback;
            this.authenticator = authenticator;
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
            Properties props = PropertiesUtils.asProperties("annotators", "tokenize,ssplit,pos,lemma,ner");
            if (this.authenticator != null && !this.authenticator.test(props)) {
                StanfordCoreNLPServer.respondUnauthorized(httpExchange);
                return;
            }
            Map params = StanfordCoreNLPServer.getURLParams(httpExchange.getRequestURI());
            Future<Pair> future = StanfordCoreNLPServer.this.corenlpExecutor.submit(() -> {
                try {
                    Annotation doc = StanfordCoreNLPServer.this.getDocument(props, httpExchange);
                    if (!doc.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
                        StanfordCoreNLP pipeline = StanfordCoreNLPServer.this.mkStanfordCoreNLP(props);
                        pipeline.annotate(doc);
                    }
                    if (!params.containsKey("pattern")) {
                        StanfordCoreNLPServer.respondBadInput("Missing required parameter 'pattern'", httpExchange);
                        return new Pair<String, Object>("", null);
                    }
                    String pattern = (String)params.get("pattern");
                    String filterStr = params.getOrDefault("filter", "false");
                    boolean filter = filterStr.trim().isEmpty() || "true".equalsIgnoreCase(filterStr.toLowerCase());
                    TokenSequencePattern regex = TokenSequencePattern.compile(pattern);
                    return new Pair<String, Annotation>(JSONOutputter.JSONWriter.objectToJSON(docWriter -> {
                        if (filter) {
                            docWriter.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> regex.matcher((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).matches()).collect(Collectors.toList()));
                        } else {
                            docWriter.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> sentWriter -> {
                                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                                TokenSequenceMatcher matcher = regex.matcher(tokens);
                                int i = 0;
                                while (matcher.find()) {
                                    sentWriter.set(Integer.toString(i), matchWriter -> {
                                        matchWriter.set("text", matcher.group());
                                        matchWriter.set("begin", matcher.start());
                                        matchWriter.set("end", matcher.end());
                                        for (int groupI = 0; groupI < matcher.groupCount(); ++groupI) {
                                            SequenceMatchResult.MatchedGroupInfo info = matcher.groupInfo(groupI + 1);
                                            matchWriter.set(info.varName == null ? Integer.toString(groupI + 1) : info.varName, groupWriter -> {
                                                groupWriter.set("text", info.text);
                                                if (info.nodes.size() > 0) {
                                                    groupWriter.set("begin", (Integer)((CoreMap)info.nodes.get(0)).get(CoreAnnotations.IndexAnnotation.class) - 1);
                                                    groupWriter.set("end", ((CoreMap)info.nodes.get(info.nodes.size() - 1)).get(CoreAnnotations.IndexAnnotation.class));
                                                }
                                            });
                                        }
                                    });
                                    ++i;
                                }
                                sentWriter.set("length", i);
                            }));
                        }
                    }), doc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        StanfordCoreNLPServer.respondError(e.getClass().getName() + ": " + e.getMessage(), httpExchange);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return new Pair<String, Object>("", null);
                }
            });
            try {
                Pair response = future.get(5L, TimeUnit.SECONDS);
                byte[] content = ((String)response.first).getBytes();
                Annotation completedAnnotation = (Annotation)response.second;
                StanfordCoreNLPServer.sendAndGetResponse(httpExchange, content);
                if (completedAnnotation != null && props.getProperty("annotators") != null && !"".equals(props.getProperty("annotators"))) {
                    this.callback.accept(new FinishedRequest(props, completedAnnotation, (String)params.get("pattern"), null));
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                StanfordCoreNLPServer.respondError("Timeout when executing TokensRegex query", httpExchange);
            }
        }
    }

    protected class CoreNLPHandler
    implements HttpHandler {
        public final Properties defaultProps;
        private final Predicate<Properties> authenticator;
        private final Consumer<FinishedRequest> callback;
        private final FileHandler homepage;

        public CoreNLPHandler(Properties props, Predicate<Properties> authenticator, Consumer<FinishedRequest> callback, FileHandler homepage) {
            this.defaultProps = props;
            this.callback = callback;
            this.authenticator = authenticator;
            this.homepage = homepage;
        }

        public String getContentType(Properties props, StanfordCoreNLP.OutputFormat of) {
            switch (of) {
                case JSON: {
                    return "application/json";
                }
                case TEXT: 
                case CONLL: {
                    return "text/plain";
                }
                case XML: {
                    return "text/xml";
                }
                case SERIALIZED: {
                    String outputSerializerName = props.getProperty("outputSerializer");
                    if (outputSerializerName == null || !outputSerializerName.equals(ProtobufAnnotationSerializer.class.getName())) break;
                    return "application/x-protobuf";
                }
            }
            return "application/octet-stream";
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            block15: {
                StanfordCoreNLP.OutputFormat of;
                Annotation ann;
                Properties props;
                httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
                try {
                    props = this.getProperties(httpExchange);
                    if ("GET".equalsIgnoreCase(httpExchange.getRequestMethod())) {
                        this.homepage.handle(httpExchange);
                        return;
                    }
                    if (this.authenticator != null && !this.authenticator.test(props)) {
                        StanfordCoreNLPServer.respondUnauthorized(httpExchange);
                        return;
                    }
                    Redwood.Util.log("[" + httpExchange.getRemoteAddress() + "] API call w/annotators " + props.getProperty("annotators", "<unknown>"));
                    ann = StanfordCoreNLPServer.this.getDocument(props, httpExchange);
                    of = StanfordCoreNLP.OutputFormat.valueOf(props.getProperty("outputFormat", "json").toUpperCase());
                    String text = ((String)ann.get(CoreAnnotations.TextAnnotation.class)).replace('\n', ' ');
                    if (!StanfordCoreNLPServer.this.quiet) {
                        System.out.println(text);
                    }
                    if (text.length() > MAX_CHAR_LENGTH) {
                        StanfordCoreNLPServer.respondBadInput("Request is too long to be handled by server: " + text.length() + " characters. Max length is " + MAX_CHAR_LENGTH + " characters.", httpExchange);
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StanfordCoreNLPServer.respondError("Could not handle incoming annotation", httpExchange);
                    return;
                }
                Future<Annotation> completedAnnotationFuture = null;
                try {
                    Annotation completedAnnotation;
                    StanfordCoreNLP pipeline = StanfordCoreNLPServer.this.mkStanfordCoreNLP(props);
                    completedAnnotationFuture = StanfordCoreNLPServer.this.corenlpExecutor.submit(() -> {
                        pipeline.annotate(ann);
                        return ann;
                    });
                    try {
                        int timeoutMilliseconds = Integer.parseInt(props.getProperty("timeout", Integer.toString(StanfordCoreNLPServer.this.timeoutMilliseconds)));
                        if (timeoutMilliseconds > 15000 && "corenlp.stanford.edu".equals(InetAddress.getLocalHost().getHostName()) && !httpExchange.getRemoteAddress().getHostName().toLowerCase().endsWith("stanford.edu")) {
                            timeoutMilliseconds = 15000;
                        }
                        completedAnnotation = completedAnnotationFuture.get(timeoutMilliseconds, TimeUnit.MILLISECONDS);
                    }
                    catch (NumberFormatException e) {
                        completedAnnotation = completedAnnotationFuture.get(StanfordCoreNLPServer.this.timeoutMilliseconds, TimeUnit.MILLISECONDS);
                    }
                    completedAnnotationFuture = null;
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    AnnotationOutputter.Options options = AnnotationOutputter.getOptions(pipeline);
                    StanfordCoreNLP.createOutputter(props, options).accept(completedAnnotation, os);
                    os.close();
                    byte[] response = os.toByteArray();
                    String contentType = this.getContentType(props, of);
                    if (contentType.equals("application/json") || contentType.startsWith("text/")) {
                        contentType = contentType + ";charset=" + options.encoding;
                    }
                    httpExchange.getResponseHeaders().add("Content-type", contentType);
                    httpExchange.getResponseHeaders().add("Content-length", Integer.toString(response.length));
                    httpExchange.sendResponseHeaders(200, response.length);
                    httpExchange.getResponseBody().write(response);
                    httpExchange.close();
                    if (completedAnnotation != null && props.getProperty("annotators") != null && !"".equals(props.getProperty("annotators"))) {
                        this.callback.accept(new FinishedRequest(props, completedAnnotation));
                    }
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                    StanfordCoreNLPServer.respondError("CoreNLP request timed out. Your document may be too long.", httpExchange);
                    if (completedAnnotationFuture != null) {
                        completedAnnotationFuture.cancel(true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StanfordCoreNLPServer.respondError(e.getClass().getName() + ": " + e.getMessage(), httpExchange);
                    if (completedAnnotationFuture == null) break block15;
                    completedAnnotationFuture.cancel(true);
                }
            }
        }

        private Properties getProperties(HttpExchange httpExchange) throws UnsupportedEncodingException {
            Map urlParams = StanfordCoreNLPServer.getURLParams(httpExchange.getRequestURI());
            Properties props = new Properties();
            this.defaultProps.entrySet().forEach(entry -> props.setProperty(entry.getKey().toString(), entry.getValue().toString()));
            urlParams.entrySet().stream().filter(entry -> !"properties".equalsIgnoreCase((String)entry.getKey()) && !"props".equalsIgnoreCase((String)entry.getKey())).forEach(entry -> props.setProperty((String)entry.getKey(), (String)entry.getValue()));
            Map<Object, Object> urlProperties = new HashMap();
            if (urlParams.containsKey("properties")) {
                urlProperties = StringUtils.decodeMap(URLDecoder.decode((String)urlParams.get("properties"), "UTF-8"));
            } else if (urlParams.containsKey("props")) {
                urlProperties = StringUtils.decodeMap(URLDecoder.decode((String)urlParams.get("props"), "UTF-8"));
            }
            String language = urlParams.getOrDefault("pipelineLanguage", urlProperties.getOrDefault("pipelineLanguage", "default"));
            if (language != null && !"default".equals(language)) {
                String languagePropertiesFile = LanguageInfo.getLanguagePropertiesFile(language);
                if (languagePropertiesFile != null) {
                    Properties languageSpecificProperties = new Properties();
                    try {
                        languageSpecificProperties.load(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(languagePropertiesFile));
                        PropertiesUtils.overWriteProperties(props, languageSpecificProperties);
                    }
                    catch (IOException e) {
                        Redwood.Util.err("Failure to load language specific properties.");
                    }
                } else {
                    try {
                        StanfordCoreNLPServer.respondError("Invalid language: '" + language + "'", httpExchange);
                    }
                    catch (IOException e) {
                        Redwood.Util.warn(e);
                    }
                    return new Properties();
                }
            }
            if (!props.containsKey("mention.type")) {
                props.setProperty("mention.type", "dep");
                if (urlProperties.containsKey("annotators") && urlProperties.get("annotators") != null && ArrayUtils.contains(((String)urlProperties.get("annotators")).split(","), "parse")) {
                    props.remove("mention.type");
                }
            }
            urlProperties.entrySet().forEach(entry -> props.setProperty((String)entry.getKey(), (String)entry.getValue()));
            String annotators = props.getProperty("annotators");
            if (PropertiesUtils.getBool(props, "enforceRequirements", true)) {
                annotators = StanfordCoreNLP.ensurePrerequisiteAnnotators(props.getProperty("annotators").split("[, \t]+"), props);
            }
            props.setProperty("annotators", annotators);
            return props;
        }
    }

    public static class FileHandler
    implements HttpHandler {
        private final String content;
        private final String contentType;

        public FileHandler(String fileOrClasspath) throws IOException {
            this(fileOrClasspath, "text/html");
        }

        public FileHandler(String fileOrClasspath, String contentType) throws IOException {
            this.content = IOUtils.slurpReader(IOUtils.readerFromString(fileOrClasspath, "utf-8"));
            this.contentType = contentType + "; charset=utf-8";
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            httpExchange.getResponseHeaders().set("Content-type", this.contentType);
            ByteBuffer buffer = Charset.forName("UTF-8").encode(this.content);
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            httpExchange.sendResponseHeaders(200, bytes.length);
            httpExchange.getResponseBody().write(bytes);
            httpExchange.close();
        }
    }

    protected class ShutdownHandler
    implements HttpHandler {
        protected ShutdownHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            Map urlParams = StanfordCoreNLPServer.getURLParams(httpExchange.getRequestURI());
            httpExchange.getResponseHeaders().set("Content-type", "text/plain");
            boolean doExit = false;
            String response = "Invalid shutdown key\n";
            if (urlParams.containsKey("key") && ((String)urlParams.get("key")).equals(StanfordCoreNLPServer.this.shutdownKey)) {
                response = "Shutdown successful!\n";
                doExit = true;
            }
            httpExchange.sendResponseHeaders(200, response.getBytes().length);
            httpExchange.getResponseBody().write(response.getBytes());
            httpExchange.close();
            if (doExit) {
                System.exit(0);
            }
        }
    }

    protected static class LiveHandler
    implements HttpHandler {
        protected LiveHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            httpExchange.getResponseHeaders().set("Content-type", "text/plain");
            String response = "live\n";
            httpExchange.sendResponseHeaders(200, response.getBytes().length);
            httpExchange.getResponseBody().write(response.getBytes());
            httpExchange.close();
        }
    }

    protected static class ReadyHandler
    implements HttpHandler {
        public final AtomicBoolean serverReady;
        public final long startTime;

        public ReadyHandler(AtomicBoolean serverReady) {
            this.serverReady = serverReady;
            this.startTime = System.currentTimeMillis();
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            int status;
            String response;
            httpExchange.getResponseHeaders().set("Content-type", "text/plain");
            if (this.serverReady.get()) {
                response = "ready\n";
                status = 200;
            } else {
                response = "server is not ready yet. uptime=" + Redwood.formatTimeDifference(System.currentTimeMillis() - this.startTime) + "\n";
                status = 503;
            }
            httpExchange.sendResponseHeaders(status, response.getBytes().length);
            httpExchange.getResponseBody().write(response.getBytes());
            httpExchange.close();
        }
    }

    protected static class PingHandler
    implements HttpHandler {
        protected PingHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            httpExchange.getResponseHeaders().set("Content-type", "text/plain");
            String response = "pong\n";
            httpExchange.sendResponseHeaders(200, response.getBytes().length);
            httpExchange.getResponseBody().write(response.getBytes());
            httpExchange.close();
        }
    }

    public static class FinishedRequest {
        public final Properties props;
        public final Annotation document;
        public final Optional<String> tokensregex;
        public final Optional<String> semgrex;

        public FinishedRequest(Properties props, Annotation document) {
            this.props = props;
            this.document = document;
            this.tokensregex = Optional.empty();
            this.semgrex = Optional.empty();
        }

        public FinishedRequest(Properties props, Annotation document, String tokensregex, String semgrex) {
            this.props = props;
            this.document = document;
            this.tokensregex = Optional.ofNullable(tokensregex);
            this.semgrex = Optional.ofNullable(semgrex);
        }
    }
}

