/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.time.XMLUtils;
import edu.stanford.nlp.util.Pair;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class Timex
implements Serializable {
    private static final long serialVersionUID = 385847729549981302L;
    private String xml;
    private String val;
    private String altVal;
    private String text;
    private String type;
    private String tid;
    private int beginPoint;
    private int endPoint;
    private Range range;

    public String value() {
        return this.val;
    }

    public String altVal() {
        return this.altVal;
    }

    public String text() {
        return this.text;
    }

    public String timexType() {
        return this.type;
    }

    public String tid() {
        return this.tid;
    }

    public Range range() {
        return this.range;
    }

    public Timex() {
    }

    public Timex(Element element) {
        this.val = null;
        this.beginPoint = -1;
        this.endPoint = -1;
        this.init(element);
    }

    public Timex(String val) {
        this(null, val);
    }

    public Timex(String type, String val) {
        this.val = val;
        this.type = type;
        this.beginPoint = -1;
        this.endPoint = -1;
        this.xml = val == null ? "<TIMEX3/>" : String.format("<TIMEX3 VAL=\"%s\" TYPE=\"%s\"/>", this.val, this.type);
    }

    public Timex(String type, String val, String altVal, String tid, String text, int beginPoint, int endPoint) {
        this.type = type;
        this.val = val;
        this.altVal = altVal;
        this.tid = tid;
        this.text = text;
        this.beginPoint = beginPoint;
        this.endPoint = endPoint;
    }

    private void init(Element element) {
        this.init(XMLUtils.nodeToString(element, false), element);
    }

    private void init(String xml, Element element) {
        String beginPoint;
        this.xml = xml;
        this.text = element.getTextContent();
        this.tid = XMLUtils.getAttribute(element, "tid");
        this.val = XMLUtils.getAttribute(element, "VAL");
        if (this.val == null) {
            this.val = XMLUtils.getAttribute(element, "value");
        }
        this.altVal = XMLUtils.getAttribute(element, "alt_value");
        this.type = XMLUtils.getAttribute(element, "type");
        if (this.type == null) {
            this.type = XMLUtils.getAttribute(element, "TYPE");
        }
        this.beginPoint = (beginPoint = XMLUtils.getAttribute(element, "beginPoint")) == null || beginPoint.length() == 0 ? -1 : Integer.parseInt(beginPoint.substring(1));
        String endPoint = XMLUtils.getAttribute(element, "endPoint");
        this.endPoint = endPoint == null || endPoint.length() == 0 ? -1 : Integer.parseInt(endPoint.substring(1));
        String rangeStr = XMLUtils.getAttribute(element, "range");
        if (rangeStr != null) {
            String[] parts;
            if (rangeStr.startsWith("(") && rangeStr.endsWith(")")) {
                rangeStr = rangeStr.substring(1, rangeStr.length() - 1);
            }
            this.range = new Range((parts = rangeStr.split(",")).length > 0 ? parts[0] : "", parts.length > 1 ? parts[1] : "", parts.length > 2 ? parts[2] : "");
        }
    }

    public int beginPoint() {
        return this.beginPoint;
    }

    public int endPoint() {
        return this.endPoint;
    }

    public String toString() {
        return this.xml;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timex timex = (Timex)o;
        if (this.beginPoint != timex.beginPoint) {
            return false;
        }
        if (this.endPoint != timex.endPoint) {
            return false;
        }
        if (this.type != null ? !this.type.equals(timex.type) : timex.type != null) {
            return false;
        }
        return !(this.val != null ? !this.val.equals(timex.val) : timex.val != null);
    }

    public int hashCode() {
        int result = this.val != null ? this.val.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + this.beginPoint;
        result = 31 * result + this.endPoint;
        return result;
    }

    public Element toXmlElement() {
        Element element = XMLUtils.createElement("TIMEX3");
        if (this.tid != null) {
            element.setAttribute("tid", this.tid);
        }
        if (this.value() != null) {
            element.setAttribute("value", this.val);
        }
        if (this.altVal != null) {
            element.setAttribute("altVal", this.altVal);
        }
        if (this.type != null) {
            element.setAttribute("type", this.type);
        }
        if (this.beginPoint != -1) {
            element.setAttribute("beginPoint", "t" + String.valueOf(this.beginPoint));
        }
        if (this.endPoint != -1) {
            element.setAttribute("endPoint", "t" + String.valueOf(this.endPoint));
        }
        if (this.text != null) {
            element.setTextContent(this.text);
        }
        return element;
    }

    public static Timex fromXml(String xml) {
        Element element = XMLUtils.parseElement(xml);
        if ("TIMEX3".equals(element.getNodeName())) {
            Timex t = new Timex();
            t.init(element);
            return t;
        }
        throw new IllegalArgumentException("Invalid timex xml: " + xml);
    }

    public static Timex fromMap(String text, Map<String, String> map) {
        try {
            Element element = XMLUtils.createElement("TIMEX3");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                element.setAttribute(entry.getKey(), entry.getValue());
            }
            element.setTextContent(text);
            return new Timex(element);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Calendar getDate() {
        if (Pattern.matches("\\d\\d\\d\\d-\\d\\d-\\d\\d", this.val)) {
            int year = Integer.parseInt(this.val.substring(0, 4));
            int month = Integer.parseInt(this.val.substring(5, 7));
            int day = Integer.parseInt(this.val.substring(8, 10));
            return Timex.makeCalendar(year, month, day);
        }
        if (Pattern.matches("\\d\\d\\d\\d\\d\\d\\d\\d", this.val)) {
            int year = Integer.parseInt(this.val.substring(0, 4));
            int month = Integer.parseInt(this.val.substring(4, 6));
            int day = Integer.parseInt(this.val.substring(6, 8));
            return Timex.makeCalendar(year, month, day);
        }
        throw new UnsupportedOperationException(String.format("%s is not a fully specified date", this));
    }

    public Pair<Calendar, Calendar> getRange() {
        return this.getRange(null);
    }

    public Pair<Calendar, Calendar> getRange(Timex documentTime) {
        if (this.val == null) {
            throw new UnsupportedOperationException("no value specified for " + this);
        }
        if (this.val.length() >= 8 && Pattern.matches("\\d\\d\\d\\d\\d\\d\\d\\d", this.val.substring(0, 8))) {
            int year = Integer.parseInt(this.val.substring(0, 4));
            int month = Integer.parseInt(this.val.substring(4, 6));
            int day = Integer.parseInt(this.val.substring(6, 8));
            return new Pair<Calendar, Calendar>(Timex.makeCalendar(year, month, day), Timex.makeCalendar(year, month, day));
        }
        if (this.val.length() >= 10 && Pattern.matches("\\d\\d\\d\\d-\\d\\d-\\d\\d", this.val.substring(0, 10))) {
            int year = Integer.parseInt(this.val.substring(0, 4));
            int month = Integer.parseInt(this.val.substring(5, 7));
            int day = Integer.parseInt(this.val.substring(8, 10));
            return new Pair<Calendar, Calendar>(Timex.makeCalendar(year, month, day), Timex.makeCalendar(year, month, day));
        }
        if (Pattern.matches("\\d\\d\\d\\d\\d\\d\\d\\d[A-Z]+", this.val)) {
            int year = Integer.parseInt(this.val.substring(0, 4));
            int month = Integer.parseInt(this.val.substring(4, 6));
            int day = Integer.parseInt(this.val.substring(6, 8));
            return new Pair<Calendar, Calendar>(Timex.makeCalendar(year, month, day), Timex.makeCalendar(year, month, day));
        }
        if (this.val.length() >= 6 && Pattern.matches("\\d\\d\\d\\d\\d\\d", this.val.substring(0, 6))) {
            int year = Integer.parseInt(this.val.substring(0, 4));
            int month = Integer.parseInt(this.val.substring(4, 6));
            Calendar begin = Timex.makeCalendar(year, month, 1);
            int lastDay = begin.getActualMaximum(5);
            Calendar end = Timex.makeCalendar(year, month, lastDay);
            return new Pair<Calendar, Calendar>(begin, end);
        }
        if (this.val.length() >= 7 && Pattern.matches("\\d\\d\\d\\d-\\d\\d", this.val.substring(0, 7))) {
            int year = Integer.parseInt(this.val.substring(0, 4));
            int month = Integer.parseInt(this.val.substring(5, 7));
            Calendar begin = Timex.makeCalendar(year, month, 1);
            int lastDay = begin.getActualMaximum(5);
            Calendar end = Timex.makeCalendar(year, month, lastDay);
            return new Pair<Calendar, Calendar>(begin, end);
        }
        if (this.val.length() >= 4 && Pattern.matches("\\d\\d\\d\\d", this.val.substring(0, 4))) {
            int year = Integer.parseInt(this.val.substring(0, 4));
            return new Pair<Calendar, Calendar>(Timex.makeCalendar(year, 1, 1), Timex.makeCalendar(year, 12, 31));
        }
        if (Pattern.matches("P\\d+Y", this.val) && documentTime != null) {
            Calendar rc = documentTime.getDate();
            int yearRange = Integer.parseInt(this.val.substring(1, this.val.length() - 1));
            if (this.beginPoint < this.endPoint) {
                Calendar start = Timex.copyCalendar(rc);
                Calendar end = Timex.copyCalendar(rc);
                end.add(1, yearRange);
                return new Pair<Calendar, Calendar>(start, end);
            }
            if (this.beginPoint > this.endPoint) {
                Calendar start = Timex.copyCalendar(rc);
                Calendar end = Timex.copyCalendar(rc);
                start.add(1, 0 - yearRange);
                return new Pair<Calendar, Calendar>(start, end);
            }
            throw new RuntimeException("begin and end are equal " + this);
        }
        if (Pattern.matches("P\\d+M", this.val) && documentTime != null) {
            Calendar rc = documentTime.getDate();
            int monthRange = Integer.parseInt(this.val.substring(1, this.val.length() - 1));
            if (this.beginPoint < this.endPoint) {
                Calendar start = Timex.copyCalendar(rc);
                Calendar end = Timex.copyCalendar(rc);
                end.add(2, monthRange);
                return new Pair<Calendar, Calendar>(start, end);
            }
            if (this.beginPoint > this.endPoint) {
                Calendar start = Timex.copyCalendar(rc);
                Calendar end = Timex.copyCalendar(rc);
                start.add(2, 0 - monthRange);
                return new Pair<Calendar, Calendar>(start, end);
            }
            throw new RuntimeException("begin and end are equal " + this);
        }
        if (Pattern.matches("P\\d+D", this.val) && documentTime != null) {
            Calendar rc = documentTime.getDate();
            int dayRange = Integer.parseInt(this.val.substring(1, this.val.length() - 1));
            if (this.beginPoint < this.endPoint) {
                Calendar start = Timex.copyCalendar(rc);
                Calendar end = Timex.copyCalendar(rc);
                end.add(5, dayRange);
                return new Pair<Calendar, Calendar>(start, end);
            }
            if (this.beginPoint > this.endPoint) {
                Calendar start = Timex.copyCalendar(rc);
                Calendar end = Timex.copyCalendar(rc);
                start.add(5, 0 - dayRange);
                return new Pair<Calendar, Calendar>(start, end);
            }
            throw new RuntimeException("begin and end are equal " + this);
        }
        if (Pattern.matches("\\d+SP", this.val)) {
            int year = Integer.parseInt(this.val.substring(0, 4));
            Calendar start = Timex.makeCalendar(year, 2, 1);
            Calendar end = Timex.makeCalendar(year, 4, 31);
            return new Pair<Calendar, Calendar>(start, end);
        }
        if (Pattern.matches("\\d+SU", this.val)) {
            int year = Integer.parseInt(this.val.substring(0, 4));
            Calendar start = Timex.makeCalendar(year, 5, 1);
            Calendar end = Timex.makeCalendar(year, 7, 31);
            return new Pair<Calendar, Calendar>(start, end);
        }
        if (Pattern.matches("\\d+FA", this.val)) {
            int year = Integer.parseInt(this.val.substring(0, 4));
            Calendar start = Timex.makeCalendar(year, 8, 1);
            Calendar end = Timex.makeCalendar(year, 10, 31);
            return new Pair<Calendar, Calendar>(start, end);
        }
        if (Pattern.matches("\\d+WI", this.val)) {
            int year = Integer.parseInt(this.val.substring(0, 4));
            Calendar start = Timex.makeCalendar(year, 11, 1);
            Calendar end = Timex.makeCalendar(year + 1, 1, 29);
            return new Pair<Calendar, Calendar>(start, end);
        }
        if (Pattern.matches("\\d\\d\\d\\dW\\d+", this.val)) {
            int year = Integer.parseInt(this.val.substring(0, 4));
            int week = Integer.parseInt(this.val.substring(5));
            int startDay = (week - 1) * 7;
            int endDay = startDay + 6;
            Calendar start = Timex.makeCalendar(year, startDay);
            Calendar end = Timex.makeCalendar(year, endDay);
            return new Pair<Calendar, Calendar>(start, end);
        }
        if (this.val.equals("PRESENT_REF")) {
            Calendar rc = documentTime.getDate();
            Calendar start = Timex.copyCalendar(rc);
            Calendar end = Timex.copyCalendar(rc);
            return new Pair<Calendar, Calendar>(start, end);
        }
        throw new RuntimeException(String.format("unknown value \"%s\" in %s", this.val, this));
    }

    private static Calendar makeCalendar(int year, int month, int day) {
        Calendar date = Calendar.getInstance();
        date.clear();
        date.set(year, month - 1, day, 0, 0, 0);
        return date;
    }

    private static Calendar makeCalendar(int year, int dayOfYear) {
        Calendar date = Calendar.getInstance();
        date.clear();
        date.set(1, year);
        date.set(6, dayOfYear);
        return date;
    }

    private static Calendar copyCalendar(Calendar c) {
        Calendar date = Calendar.getInstance();
        date.clear();
        date.set(c.get(1), c.get(2), c.get(5), c.get(11), c.get(12), c.get(13));
        return date;
    }

    public static class Range
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String begin;
        public String end;
        public String duration;

        public Range(String begin, String end, String duration) {
            this.begin = begin;
            this.end = end;
            this.duration = duration;
        }
    }
}

