/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.trees.EnglishGrammaticalStructure;
import edu.stanford.nlp.trees.HasParent;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeGraphNodeFactory;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.StringReader;
import java.util.List;

public class TreeGraphNode
extends Tree
implements HasParent {
    private static Redwood.RedwoodChannels log = Redwood.channels(TreeGraphNode.class);
    protected CoreLabel label;
    protected TreeGraphNode parent;
    protected TreeGraphNode[] children = ZERO_TGN_CHILDREN;
    private TreeGraphNode headWordNode;
    protected static final TreeGraphNode[] ZERO_TGN_CHILDREN = new TreeGraphNode[0];
    private static final LabelFactory mlf = CoreLabel.factory();
    private static final long serialVersionUID = 5080098143617475328L;

    public TreeGraphNode(Label label) {
        this.label = (CoreLabel)mlf.newLabel(label);
    }

    public TreeGraphNode(Label label, List<Tree> children) {
        this(label);
        this.setChildren(children);
    }

    protected TreeGraphNode(Tree t, TreeGraphNode parent) {
        this.parent = parent;
        Tree[] tKids = t.children();
        int numKids = tKids.length;
        this.children = new TreeGraphNode[numKids];
        for (int i = 0; i < numKids; ++i) {
            this.children[i] = new TreeGraphNode(tKids[i], this);
            if (!t.isPreTerminal()) continue;
            this.children[i].label.setTag(t.label().value());
        }
        this.label = (CoreLabel)mlf.newLabel(t.label());
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public CoreLabel label() {
        return this.label;
    }

    @Override
    public void setLabel(Label label) {
        if (label instanceof CoreLabel) {
            this.setLabel((CoreLabel)label);
        } else {
            this.setLabel((CoreLabel)mlf.newLabel(label));
        }
    }

    public void setLabel(CoreLabel label) {
        this.label = label;
    }

    public int index() {
        return this.label.index();
    }

    protected void setIndex(int index) {
        this.label.setIndex(index);
    }

    @Override
    public TreeGraphNode parent() {
        return this.parent;
    }

    public void setParent(TreeGraphNode parent) {
        this.parent = parent;
    }

    public TreeGraphNode[] children() {
        return this.children;
    }

    @Override
    public void setChildren(Tree[] children) {
        if (children == null || children.length == 0) {
            this.children = ZERO_TGN_CHILDREN;
        } else if (children instanceof TreeGraphNode[]) {
            for (TreeGraphNode child : this.children = (TreeGraphNode[])children) {
                child.setParent(this);
            }
        } else {
            this.children = new TreeGraphNode[children.length];
            for (int i = 0; i < children.length; ++i) {
                this.children[i] = (TreeGraphNode)children[i];
                this.children[i].setParent(this);
            }
        }
    }

    @Override
    public void setChildren(List<? extends Tree> childTreesList) {
        if (childTreesList == null || childTreesList.isEmpty()) {
            this.setChildren(ZERO_TGN_CHILDREN);
        } else {
            int leng = childTreesList.size();
            Tree[] childTrees = new TreeGraphNode[leng];
            childTreesList.toArray(childTrees);
            this.setChildren(childTrees);
        }
    }

    @Override
    public Tree setChild(int i, Tree t) {
        if (!(t instanceof TreeGraphNode)) {
            throw new IllegalArgumentException("Horrible error");
        }
        ((TreeGraphNode)t).setParent(this);
        return super.setChild(i, t);
    }

    @Override
    public void addChild(int i, Tree t) {
        if (!(t instanceof TreeGraphNode)) {
            throw new IllegalArgumentException("Horrible error");
        }
        ((TreeGraphNode)t).setParent(this);
        TreeGraphNode[] kids = this.children;
        TreeGraphNode[] newKids = new TreeGraphNode[kids.length + 1];
        if (i != 0) {
            System.arraycopy(kids, 0, newKids, 0, i);
        }
        newKids[i] = (TreeGraphNode)t;
        if (i != kids.length) {
            System.arraycopy(kids, i, newKids, i + 1, kids.length - i);
        }
        this.children = newKids;
    }

    @Override
    public Tree removeChild(int i) {
        TreeGraphNode[] kids = this.children();
        TreeGraphNode kid = kids[i];
        TreeGraphNode[] newKids = new TreeGraphNode[kids.length - 1];
        for (int j = 0; j < newKids.length; ++j) {
            newKids[j] = j < i ? kids[j] : kids[j + 1];
        }
        this.children = newKids;
        return kid;
    }

    @Override
    public void percolateHeads(HeadFinder hf) {
        if (this.isLeaf()) {
            TreeGraphNode hwn = this.headWordNode();
            if (hwn == null) {
                this.setHeadWordNode(this);
            }
        } else {
            for (TreeGraphNode child : this.children()) {
                ((Tree)child).percolateHeads(hf);
            }
            TreeGraphNode head = TreeGraphNode.safeCast(hf.determineHead(this, this.parent));
            if (head != null) {
                TreeGraphNode hwn = head.headWordNode();
                if (hwn == null && head.isLeaf()) {
                    this.setHeadWordNode(head);
                } else {
                    this.setHeadWordNode(hwn);
                }
            } else {
                log.info("Head is null: " + this);
            }
        }
    }

    public TreeGraphNode headWordNode() {
        return this.headWordNode;
    }

    private void setHeadWordNode(TreeGraphNode hwn) {
        this.headWordNode = hwn;
    }

    private static TreeGraphNode safeCast(Object t) {
        if (t == null || !(t instanceof TreeGraphNode)) {
            return null;
        }
        return (TreeGraphNode)t;
    }

    public TreeGraphNode highestNodeWithSameHead() {
        TreeGraphNode node = this;
        TreeGraphNode parent;
        while ((parent = TreeGraphNode.safeCast(node.parent())) != null && parent.headWordNode() == node.headWordNode()) {
            node = parent;
        }
        return node;
    }

    @Override
    public TreeFactory treeFactory() {
        LabelFactory lf = this.label() != null ? this.label().labelFactory() : CoreLabel.factory();
        return new TreeGraphNodeFactory(lf);
    }

    public static TreeFactory factory() {
        return TreeFactoryHolder.tgnf;
    }

    public static TreeFactory factory(LabelFactory lf) {
        return new TreeGraphNodeFactory(lf);
    }

    public String toPrettyString(int indentLevel) {
        StringBuilder buf = new StringBuilder("\n");
        for (int i = 0; i < indentLevel; ++i) {
            buf.append("  ");
        }
        if (this.children == null || this.children.length == 0) {
            buf.append(this.label.toString(CoreLabel.OutputFormat.VALUE_INDEX_MAP));
        } else {
            buf.append('(').append(this.label.toString(CoreLabel.OutputFormat.VALUE_INDEX_MAP));
            for (TreeGraphNode child : this.children) {
                buf.append(' ').append(child.toPrettyString(indentLevel + 1));
            }
            buf.append(')');
        }
        return buf.toString();
    }

    public String toOneLineString() {
        StringBuilder buf = new StringBuilder();
        if (this.children == null || this.children.length == 0) {
            buf.append(this.label);
        } else {
            buf.append('(').append(this.label);
            for (TreeGraphNode child : this.children) {
                buf.append(' ').append(child.toOneLineString());
            }
            buf.append(')');
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        return this.toString(CoreLabel.DEFAULT_FORMAT);
    }

    public String toString(CoreLabel.OutputFormat format) {
        return this.label.toString(format);
    }

    public static void main(String[] args) {
        try {
            PennTreeReader tr = new PennTreeReader(new StringReader("(S (NP (NNP Sam)) (VP (VBD died) (NP (NN today))))"), new LabeledScoredTreeFactory());
            Tree t = tr.readTree();
            System.out.println(t);
            TreeGraphNode tgn = new TreeGraphNode(t, (TreeGraphNode)null);
            System.out.println(tgn.toPrettyString(0));
            EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(tgn);
            System.out.println(tgn.toPrettyString(0));
            tgn.percolateHeads(new SemanticHeadFinder());
            System.out.println(tgn.toPrettyString(0));
        }
        catch (Exception e) {
            log.info("Horrible error: " + e);
            e.printStackTrace();
        }
    }

    private static class TreeFactoryHolder {
        static final TreeGraphNodeFactory tgnf = new TreeGraphNodeFactory();

        private TreeFactoryHolder() {
        }
    }
}

