/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.AdjoinNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.AuxiliaryTree;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import java.util.Map;

class AdjoinToHeadNode
extends AdjoinNode {
    public AdjoinToHeadNode(AuxiliaryTree t, TsurgeonPattern p) {
        super("adjoinH", t, p);
    }

    @Override
    public TsurgeonMatcher matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
        return new Matcher(newNodeNames, coindexer);
    }

    private class Matcher
    extends TsurgeonMatcher {
        public Matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
            super(AdjoinToHeadNode.this, newNodeNames, coindexer);
        }

        @Override
        public Tree evaluate(Tree tree, TregexMatcher tregex) {
            Tree targetNode = this.childMatcher[0].evaluate(tree, tregex);
            AuxiliaryTree ft = AdjoinToHeadNode.this.adjunctionTree().copy(this, tree.treeFactory(), tree.label().labelFactory());
            ft.foot.setChildren(targetNode.getChildrenAsList());
            targetNode.setChildren(ft.tree.getChildrenAsList());
            return tree;
        }
    }
}

