/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ConcatenationIterator;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.FilteredIterator;
import edu.stanford.nlp.util.MapFactory;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class DeltaMap<K, V>
extends AbstractMap<K, V> {
    private Map<K, V> originalMap;
    private Map<K, V> deltaMap;
    private static Object nullValue = new Object();
    private static Object removedValue = new Object();

    @Override
    public boolean containsKey(Object key) {
        V value = this.deltaMap.get(key);
        if (value == null) {
            return this.originalMap.containsKey(key);
        }
        return value != removedValue;
    }

    @Override
    public V get(Object key) {
        V deltaResult = this.deltaMap.get(key);
        if (deltaResult == null) {
            return this.originalMap.get(key);
        }
        if (deltaResult == nullValue) {
            return null;
        }
        if (deltaResult == removedValue) {
            return null;
        }
        return deltaResult;
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            return (V)this.put(key, nullValue);
        }
        V result = this.deltaMap.put(key, value);
        if (result == null) {
            return this.originalMap.get(key);
        }
        if (result == nullValue) {
            return null;
        }
        if (result == removedValue) {
            return null;
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        return (V)this.put(key, removedValue);
    }

    @Override
    public void clear() {
        for (K key : this.originalMap.keySet()) {
            this.deltaMap.put(key, removedValue);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                Predicate<Map.Entry> filter1 = e -> !DeltaMap.this.deltaMap.containsKey(e.getKey());
                FilteredIterator<Map.Entry> iter1 = new FilteredIterator<Map.Entry>(DeltaMap.this.originalMap.entrySet().iterator(), filter1);
                Predicate<Map.Entry> filter2 = e -> e.getValue() != removedValue;
                class NullingIterator<KK, VV>
                implements Iterator<Map.Entry<KK, VV>> {
                    private Iterator<Map.Entry<KK, VV>> i;

                    NullingIterator(Iterator<Map.Entry<KK, VV>> i) {
                        this.i = i;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<KK, VV> next() {
                        Map.Entry<KK, VV> e = this.i.next();
                        VV o = e.getValue();
                        if (o == nullValue) {
                            return new SimpleEntry<KK, Object>(e.getKey(), null);
                        }
                        return e;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                FilteredIterator<Map.Entry> iter2 = new FilteredIterator<Map.Entry>(new NullingIterator(DeltaMap.this.deltaMap.entrySet().iterator()), filter2);
                return new ConcatenationIterator(iter1, iter2);
            }

            @Override
            public int size() {
                int size = 0;
                for (Map.Entry kvEntry : this) {
                    ErasureUtils.noop(kvEntry);
                    ++size;
                }
                return size;
            }
        };
    }

    public DeltaMap(Map<K, V> originalMap, MapFactory<K, V> mf) {
        this.originalMap = Collections.unmodifiableMap(originalMap);
        this.deltaMap = mf.newMap();
    }

    public DeltaMap(Map<K, V> originalMap) {
        this(originalMap, MapFactory.hashMapFactory());
    }

    static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleEntry(Map.Entry<K, V> e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this.key, e.getKey()) && SimpleEntry.eq(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }
}

