/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.OutputHandler;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaUtilLoggingHandler
extends OutputHandler {
    @Override
    public void print(Object[] channel, String line) {
        Pair<String, Redwood.Flag> pair = JavaUtilLoggingHandler.getSourceStringAndLevel(channel);
        Logger impl = Logger.getLogger(pair.first());
        switch (pair.second()) {
            case ERROR: {
                impl.log(Level.SEVERE, line);
                break;
            }
            case WARN: {
                impl.log(Level.WARNING, line);
                break;
            }
            case DEBUG: {
                impl.log(Level.FINE, line);
                break;
            }
            case STDOUT: 
            case STDERR: {
                impl.info(line);
                break;
            }
            case FORCE: {
                throw new IllegalStateException("Should not reach this switch case");
            }
        }
    }
}

