/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.cas.TOP_Type;

public final class IntegerArray
extends TOP
implements IntArrayFS,
Iterable<Integer> {
    public static final int typeIndexID;
    public static final int type;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private IntegerArray() {
    }

    public IntegerArray(int addr, TOP_Type type) {
        super(addr, type);
    }

    public IntegerArray(JCas jcas, int length) {
        this(jcas.getLowLevelCas().ll_createArray(jcas.getType((int)IntegerArray.typeIndexID).casTypeCode, length), jcas.getType(typeIndexID));
        this.jcasType.casImpl.checkArrayPreconditions(length);
    }

    @Override
    public int get(int i) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        return this.jcasType.ll_cas.ll_getIntArrayValue(this.addr, i);
    }

    @Override
    public void set(int i, int v) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        this.jcasType.ll_cas.ll_setIntArrayValue(this.addr, i, v);
    }

    @Override
    public void copyFromArray(int[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setIntArrayValue(this.addr, i + destOffset, src[i + srcOffset]);
        }
    }

    @Override
    public void copyToArray(int srcOffset, int[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.jcasType.ll_cas.ll_getIntArrayValue(this.addr, i + srcOffset);
        }
    }

    @Override
    public int[] toArray() {
        int size = this.size();
        int[] outArray = new int[size];
        this.copyToArray(0, outArray, 0, size);
        return outArray;
    }

    @Override
    public int size() {
        return this.jcasType.casImpl.ll_getArraySize(this.addr);
    }

    @Override
    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Integer.toString(this.jcasType.ll_cas.ll_getIntArrayValue(this.addr, i + srcOffset));
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setIntArrayValue(this.addr, i + destOffset, Integer.parseInt(src[i + srcOffset]));
        }
    }

    @Override
    public String[] toStringArray() {
        int size = this.size();
        String[] strArray = new String[size];
        this.copyToArray(0, strArray, 0, size);
        return strArray;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < IntegerArray.this.size();
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return IntegerArray.this.get(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        type = typeIndexID = JCasRegistry.register(IntegerArray.class);
    }
}

