/*
 * Decompiled with CFR 0.152.
 */
package udf;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import udf.AbstractResultSet;

public class RssFeed {
    public static ResultSet rssFeed(String inURL) throws IOException, ParserConfigurationException, SAXException {
        Feed newsFeed = new Feed(inURL);
        return newsFeed;
    }

    private static class Feed
    extends AbstractResultSet {
        NodeList nl;
        Element element;
        int itemCount;
        int row;
        String[] tags = new String[]{"title", "description", "link", "guid", "pubDate"};

        Feed(String url) throws IOException, ParserConfigurationException, SAXException {
            URL rssUrl = new URL(url);
            URLConnection con = rssUrl.openConnection();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(con.getInputStream());
            this.nl = doc.getElementsByTagName("item");
            this.itemCount = this.nl.getLength();
            this.row = 0;
        }

        public boolean next() {
            if (this.nl == null || this.row == this.itemCount) {
                return false;
            }
            this.element = (Element)this.nl.item(this.row);
            ++this.row;
            return true;
        }

        public String getString(int column) {
            if (column < 1 && column > this.tags.length) {
                throw new IllegalArgumentException("Invalid column ordinal");
            }
            return this.element.getElementsByTagName(this.tags[column - 1]).item(0).getFirstChild().getNodeValue();
        }

        public String getObject(String column) {
            boolean notFound = true;
            int i = 0;
            while (i < this.tags.length) {
                if (this.tags[i].equals(column)) {
                    notFound = false;
                    break;
                }
                ++i;
            }
            if (notFound) {
                throw new IllegalArgumentException("Invalid column ordinal");
            }
            return this.element.getElementsByTagName(column).item(0).getFirstChild().getNodeValue();
        }

        public void close() {
            this.nl = null;
        }
    }
}

