/*
 * Decompiled with CFR 0.152.
 */
package udf;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import udf.GeometricMean;
import udf.RssFeed;
import udf.StringUtils;

public class Test {
    private static void testTabular() throws IOException, ParserConfigurationException, SAXException, SQLException {
        String[] feeds = new String[]{"http://feeds.bbci.co.uk/news/rss.xml", "http://rss.cnn.com/rss/edition_world.rss", "http://rss.cbc.ca/lineup/topstories.xml"};
        String[] tags = new String[]{"title", "description", "link", "guid", "pubDate"};
        System.out.println("Test table function");
        int f = 0;
        while (f < feeds.length) {
            System.out.println("Going go to ->" + feeds[f]);
            ResultSet rs = RssFeed.rssFeed(feeds[f]);
            while (rs.next()) {
                System.out.println("By ordinal");
                System.out.println("=====");
                int i = 1;
                while (i < 5) {
                    System.out.println(rs.getObject(i));
                    ++i;
                }
                System.out.println("By name");
                System.out.println("=====");
                i = 1;
                while (i < tags.length) {
                    System.out.println(rs.getObject(tags[i]));
                    ++i;
                }
            }
            rs.close();
            ++f;
        }
    }

    private static void testScalar() {
        System.out.println("Test scalar");
        System.out.println(StringUtils.positionN("ABC ABC ABC", "ABC", 1));
        System.out.println(StringUtils.positionN("ABC ABC ABC", "ABC", 2));
        System.out.println(StringUtils.positionN("ABC ABC ABC", "ABC", 3));
        System.out.println(StringUtils.positionN("ABC ABC ABC", "ABC", 4));
        System.out.println(StringUtils.positionLast("ABCABCABC", "C"));
        System.out.println(StringUtils.positionLast("ABCABCABC", "BC"));
        System.out.println(StringUtils.positionLast("ABCABCABC", "ABC"));
        System.out.println(StringUtils.nthWord("PRINTF HELLO WORLD", 1));
        System.out.println(StringUtils.nthWord("PRINTF HELLO WORLD", 2));
        System.out.println(StringUtils.nthWord("PRINTF HELLO WORLD", 3));
        System.out.println(StringUtils.nthWord("PRINTF HELLO WORLD", 4));
    }

    private static void testAggregate() {
        System.out.println("Test aggregate");
        GeometricMean.State s = GeometricMean.initialize();
        s.iterate(3);
        s.iterate(6);
        s.iterate(55);
        s.iterate(7);
        s.iterate(5);
        System.out.println(s.terminate());
        s = GeometricMean.initialize();
        Number n = null;
        s.iterate(n);
        System.out.println(s.terminate());
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException, SQLException {
        Test.testTabular();
        Test.testScalar();
        Test.testAggregate();
    }
}

