/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntryExtraInfo;

public class ZipEntry
implements ZipConstants,
Cloneable {
    int method = -1;
    String name;
    String comment;
    long csize = -1L;
    long crc = -1L;
    long size = -1L;
    FileTime mtime;
    FileTime atime;
    FileTime ctime;
    long xdostime = -1L;
    int flag;
    byte[] extra;
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    private static final long MICRO_SECONDS_DIFFERENCE_OF_NTFS_AND_JAVA = -11644473600000000L;

    public ZipEntry(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public long getCrc() {
        return this.crc;
    }

    public FileTime getCreationTime() {
        return this.ctime;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public FileTime getLastAccessTime() {
        return this.atime;
    }

    public FileTime getLastModifiedTime() {
        if (null != this.mtime) {
            return this.mtime;
        }
        long time = this.getTime();
        if (-1L != time) {
            return FileTime.fromMillis(time);
        }
        return null;
    }

    public int getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public long getTime() {
        return ZipEntry.dosTimeToMilliSeconds(this.xdostime);
    }

    public boolean isDirectory() {
        return this.name.charAt(this.name.length() - 1) == '/';
    }

    public void setComment(String string) {
        this.comment = string == null || string.length() <= 65535 ? string : string.substring(0, 65535);
    }

    public void setCompressedSize(long value) {
        this.csize = value;
    }

    public void setCrc(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this.crc = value;
    }

    public ZipEntry setCreationTime(FileTime time) {
        if (null == time) {
            throw new NullPointerException();
        }
        this.ctime = time;
        return this;
    }

    public void setExtra(byte[] data) {
        if (data != null && data.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = data;
    }

    private void parseExtra(byte[] data) {
        if (null == data) {
            this.mtime = null;
            this.atime = null;
            this.ctime = null;
            return;
        }
        int offset = 0;
        ZipEntryExtraInfo info = null;
        try {
            while ((info = ZipEntryExtraInfo.fromExtra(data, offset)) != null) {
                switch (info.headerId) {
                    case 21589: {
                        ZipEntry.handleExtraHavingExtendedTimestamp(this, info);
                        break;
                    }
                    case 10: {
                        ZipEntry.handleExtraHavingNTFSTime(this, info);
                        break;
                    }
                }
                offset += info.getTotalLength();
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public ZipEntry setLastAccessTime(FileTime time) {
        if (null == time) {
            throw new NullPointerException();
        }
        this.atime = time;
        return this;
    }

    public ZipEntry setLastModifiedTime(FileTime time) {
        if (null == time) {
            throw new NullPointerException();
        }
        this.mtime = time;
        return this;
    }

    public void setMethod(int value) {
        if (value != 0 && value != 8) {
            throw new IllegalArgumentException();
        }
        this.method = value;
    }

    public void setSize(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this.size = value;
    }

    public void setTime(long value) {
        this.xdostime = ZipEntry.milliSecondsToDosTime(value);
    }

    public String toString() {
        return this.name;
    }

    /*
     * Unable to fully structure code
     */
    ZipEntry(String name, byte[] encodedName, String comment, byte[] encodedComment, Charset charset, byte[] extra, int flag, long modTime, long size, long compressedSize, long crc, int compressionMethod, long modDate, long offset) {
        super();
        this.flag = flag;
        if (charset != null) {
            cb = null;
            bb = null;
            try {
                if (name == null) {
                    bb = ByteBuffer.wrap(encodedName);
                    cb = charset.newDecoder().decode(bb);
                    this.name = cb.toString();
                } else {
                    this.name = name;
                }
                if (encodedComment == null) ** GOTO lbl28
                bb = ByteBuffer.wrap(encodedComment);
                cb = charset.newDecoder().decode(bb);
                this.comment = cb.toString();
            }
            catch (CharacterCodingException e) {
                throw new IllegalArgumentException(e.toString(), e);
            }
        } else {
            this.name = name;
            if (comment != null) {
                this.comment = comment;
            }
        }
lbl28:
        // 5 sources

        this.extra = extra;
        this.parseExtra(extra);
        this.size = size;
        this.csize = compressedSize;
        this.method = compressionMethod;
        this.xdostime = (modDate << 16) + modTime;
        this.crc = crc;
    }

    public ZipEntry(ZipEntry ze) {
        this.name = ze.name;
        this.comment = ze.comment;
        this.size = ze.size;
        this.csize = ze.csize;
        this.method = ze.method;
        this.crc = ze.crc;
        this.extra = ze.extra;
        this.atime = ze.atime;
        this.mtime = ze.mtime;
        this.ctime = ze.ctime;
        this.xdostime = ze.xdostime;
    }

    public Object clone() {
        return new ZipEntry(this);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private static long milliSecondsToDosTime(long ms) {
        int modTime;
        int modDate;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(ms));
        int year = cal.get(1);
        if (year < 1980) {
            modDate = 33;
            modTime = 0;
        } else {
            modDate = cal.get(5);
            modDate = cal.get(2) + 1 << 5 | modDate;
            modDate = cal.get(1) - 1980 << 9 | modDate;
            modTime = cal.get(13) >> 1;
            modTime = cal.get(12) << 5 | modTime;
            modTime = cal.get(11) << 11 | modTime;
        }
        return modDate << 16 | modTime;
    }

    private static long dosTimeToMilliSeconds(long dosTime) {
        int modDate = (int)dosTime >> 16;
        int modTime = (int)dosTime;
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(14, 0);
        cal.set((modDate >> 9 & 0x7F) + 1980, (modDate >> 5 & 0xF) - 1, modDate & 0x1F, modTime >> 11 & 0x1F, modTime >> 5 & 0x3F, (modTime & 0x1F) << 1);
        return cal.getTimeInMillis();
    }

    private static void handleExtraHavingExtendedTimestamp(ZipEntry entry, ZipEntryExtraInfo info) {
        long time;
        int dataOffset = info.getDataOffset();
        byte[] extra = info.extra;
        byte flags = extra[dataOffset];
        int timestampOffset = dataOffset + 1;
        if ((flags & 1) != 0) {
            time = ZipEntryExtraInfo.readInt(extra, timestampOffset);
            timestampOffset += 4;
            entry.mtime = FileTime.from(time, TimeUnit.SECONDS);
        }
        if ((flags & 2) != 0) {
            time = ZipEntryExtraInfo.readInt(extra, timestampOffset);
            entry.atime = FileTime.from(time, TimeUnit.SECONDS);
            timestampOffset += 4;
        }
        if ((flags & 4) != 0) {
            time = ZipEntryExtraInfo.readInt(extra, timestampOffset);
            entry.ctime = FileTime.from(time, TimeUnit.SECONDS);
            timestampOffset += 4;
        }
    }

    private static FileTime ntfsTimeToFileTime(long ntfsTime) {
        return FileTime.from(ntfsTime / 10L + -11644473600000000L, TimeUnit.MICROSECONDS);
    }

    private static void handleExtraHavingNTFSTime(ZipEntry entry, ZipEntryExtraInfo info) {
        int dataOffset = info.getDataOffset();
        byte[] extra = info.extra;
        short tag1 = ZipEntryExtraInfo.readShort(extra, dataOffset += 4);
        if (1 != tag1) {
            return;
        }
        short size1 = ZipEntryExtraInfo.readShort(extra, dataOffset += 2);
        if (24 != size1) {
            return;
        }
        long modifiedTime = ZipEntryExtraInfo.readLong(extra, dataOffset += 2);
        entry.mtime = ZipEntry.ntfsTimeToFileTime(modifiedTime);
        long accessTime = ZipEntryExtraInfo.readLong(extra, dataOffset += 8);
        entry.atime = ZipEntry.ntfsTimeToFileTime(accessTime);
        long creationTime = ZipEntryExtraInfo.readLong(extra, dataOffset += 8);
        entry.ctime = ZipEntry.ntfsTimeToFileTime(creationTime);
    }
}

