/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jit;

import com.ibm.jit.DecimalFormatHelper;
import com.ibm.oti.vm.VM;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public final class JITHelpers {
    private static final JITHelpers helpers;
    private static final Unsafe unsafe;
    private static final DecimalFormatHelper dummyDecFormat;
    private static final int CLASS_IS_INTERFACE_OR_PRIMITIVE;
    private static final int JLCLASS_J9CLASS_OFFSET;
    private static final int POINTER_SIZE;
    private static final boolean IS_32_BIT;
    private static final int DESCRIPTION_WORD_SIZE;
    private static final int DESCRIPTION_WORD_BIT_SIZE;
    private static final int SLOT_SIZE;

    private JITHelpers() {
    }

    @CallerSensitive
    public static JITHelpers getHelpers() {
        if (Reflection.getCallerClass().getClassLoader() != null) {
            throw new SecurityException("JITHelpers");
        }
        return helpers;
    }

    private static JITHelpers jitHelpers() {
        return helpers;
    }

    public native int transformedEncodeUTF16Big(long var1, long var3, int var5);

    public native int transformedEncodeUTF16Little(long var1, long var3, int var5);

    private static native int javaLangClassJ9ClassOffset();

    private static int classIsInterfaceFlag() {
        return 512;
    }

    public Class<?> getSuperclass(Class<?> clazz) {
        if (IS_32_BIT) {
            int j9Class = unsafe.getInt(clazz, JLCLASS_J9CLASS_OFFSET);
            int romClass = unsafe.getInt(j9Class + VM.J9CLASS_ROMCLASS_OFFSET);
            int modifiers = unsafe.getInt(romClass + VM.J9ROMCLASS_MODIFIERS_OFFSET);
            if (0 == (modifiers & CLASS_IS_INTERFACE_OR_PRIMITIVE)) {
                int superclasses = unsafe.getInt(j9Class + VM.J9CLASS_SUPERCLASSES_OFFSET);
                int depthAndFlags = unsafe.getInt(j9Class + VM.J9CLASS_CLASS_DEPTH_AND_FLAGS_OFFSET);
                int depth = depthAndFlags & VM.J9_JAVA_CLASS_DEPTH_MASK;
                if (depth > 0) {
                    int superclass = unsafe.getInt(superclasses + POINTER_SIZE * (depth - 1));
                    return this.getClassFromJ9Class32(superclass);
                }
            }
        } else {
            long j9Class = unsafe.getLong(clazz, JLCLASS_J9CLASS_OFFSET);
            long romClass = unsafe.getLong(j9Class + (long)VM.J9CLASS_ROMCLASS_OFFSET);
            int modifiers = unsafe.getInt(romClass + (long)VM.J9ROMCLASS_MODIFIERS_OFFSET);
            if (0 == (modifiers & CLASS_IS_INTERFACE_OR_PRIMITIVE)) {
                long superclasses = unsafe.getLong(j9Class + (long)VM.J9CLASS_SUPERCLASSES_OFFSET);
                long depthAndFlags = unsafe.getLong(j9Class + (long)VM.J9CLASS_CLASS_DEPTH_AND_FLAGS_OFFSET);
                long depth = depthAndFlags & (long)VM.J9_JAVA_CLASS_DEPTH_MASK;
                if (depth > 0L) {
                    long superclass = unsafe.getLong(superclasses + (long)POINTER_SIZE * (depth - 1L));
                    return this.getClassFromJ9Class64(superclass);
                }
            }
        }
        return null;
    }

    public int getIntFromObject(Object obj, long offset) {
        return unsafe.getInt(obj, offset);
    }

    public int getIntFromObjectVolatile(Object obj, long offset) {
        return unsafe.getIntVolatile(obj, offset);
    }

    public long getLongFromObject(Object obj, long offset) {
        return unsafe.getLong(obj, offset);
    }

    public long getLongFromObjectVolatile(Object obj, long offset) {
        return unsafe.getLongVolatile(obj, offset);
    }

    public Object getObjectFromObject(Object obj, long offset) {
        return unsafe.getObject(obj, offset);
    }

    public Object getObjectFromObjectVolatile(Object obj, long offset) {
        return unsafe.getObjectVolatile(obj, offset);
    }

    public void putIntInObject(Object obj, long offset, int value) {
        unsafe.putInt(obj, offset, value);
    }

    public void putIntInObjectVolatile(Object obj, long offset, int value) {
        unsafe.putIntVolatile(obj, offset, value);
    }

    public void putLongInObject(Object obj, long offset, long value) {
        unsafe.putLong(obj, offset, value);
    }

    public void putLongInObjectVolatile(Object obj, long offset, long value) {
        unsafe.putLongVolatile(obj, offset, value);
    }

    public void putObjectInObject(Object obj, long offset, Object value) {
        unsafe.putObject(obj, offset, value);
    }

    public void putObjectInObjectVolatile(Object obj, long offset, Object value) {
        unsafe.putObjectVolatile(obj, offset, value);
    }

    public boolean compareAndSwapIntInObject(Object obj, long offset, int expected, int value) {
        return unsafe.compareAndSwapInt(obj, offset, expected, value);
    }

    public boolean compareAndSwapLongInObject(Object obj, long offset, long expected, long value) {
        return unsafe.compareAndSwapLong(obj, offset, expected, value);
    }

    public boolean compareAndSwapObjectInObject(Object obj, long offset, Object expected, Object value) {
        return unsafe.compareAndSwapObject(obj, offset, expected, value);
    }

    public int getIntFromArray(Object obj, long offset) {
        return unsafe.getInt(obj, offset);
    }

    public int getIntFromArrayVolatile(Object obj, long offset) {
        return unsafe.getIntVolatile(obj, offset);
    }

    public long getLongFromArray(Object obj, long offset) {
        return unsafe.getLong(obj, offset);
    }

    public long getLongFromArrayVolatile(Object obj, long offset) {
        return unsafe.getLongVolatile(obj, offset);
    }

    public Object getObjectFromArray(Object obj, long offset) {
        return unsafe.getObject(obj, offset);
    }

    public Object getObjectFromArrayVolatile(Object obj, long offset) {
        return unsafe.getObjectVolatile(obj, offset);
    }

    public void putIntInArray(Object obj, long offset, int value) {
        unsafe.putInt(obj, offset, value);
    }

    public void putIntInArrayVolatile(Object obj, long offset, int value) {
        unsafe.putIntVolatile(obj, offset, value);
    }

    public void putLongInArray(Object obj, long offset, long value) {
        unsafe.putLong(obj, offset, value);
    }

    public void putLongInArrayVolatile(Object obj, long offset, long value) {
        unsafe.putLongVolatile(obj, offset, value);
    }

    public void putObjectInArray(Object obj, long offset, Object value) {
        unsafe.putObject(obj, offset, value);
    }

    public void putObjectInArrayVolatile(Object obj, long offset, Object value) {
        unsafe.putObjectVolatile(obj, offset, value);
    }

    public boolean compareAndSwapIntInArray(Object obj, long offset, int expected, int value) {
        return unsafe.compareAndSwapInt(obj, offset, expected, value);
    }

    public boolean compareAndSwapLongInArray(Object obj, long offset, long expected, long value) {
        return unsafe.compareAndSwapLong(obj, offset, expected, value);
    }

    public boolean compareAndSwapObjectInArray(Object obj, long offset, Object expected, Object value) {
        return unsafe.compareAndSwapObject(obj, offset, expected, value);
    }

    private static boolean isDescriptorPointerTagged(int descriptorPtr) {
        return (descriptorPtr & 1) == 1;
    }

    private static boolean isDescriptorPointerTagged(long descriptorPtr) {
        return (descriptorPtr & 1L) == 1L;
    }

    public Object optimizedClone(Object srcObj) throws CloneNotSupportedException {
        Class<? extends Object> clnClass = srcObj.getClass();
        if (clnClass.isArray()) {
            Class<?> eleClass = clnClass.getComponentType();
            int len = Array.getLength(srcObj);
            Object clnObj = Array.newInstance(eleClass, len);
            System.arraycopy(srcObj, 0, clnObj, 0, len);
            return clnObj;
        }
        if (!(srcObj instanceof Cloneable)) {
            throw new CloneNotSupportedException();
        }
        Object clnObj = null;
        try {
            clnObj = unsafe.allocateInstance(clnClass);
        }
        catch (InstantiationException e) {
            // empty catch block
        }
        int bitIndex = 0;
        if (IS_32_BIT) {
            long lockOffset;
            int j9clazz = unsafe.getInt(clnClass, JLCLASS_J9CLASS_OFFSET);
            int instanceSize = unsafe.getInt(j9clazz + VM.J9CLASS_INSTANCESIZE_OFFSET);
            int descriptorPtr = unsafe.getInt(j9clazz + VM.J9CLASS_INSTANCE_DESCRIPTION_OFFSET);
            int numSlotsInObject = instanceSize / SLOT_SIZE;
            int descriptorWord = 0;
            if (JITHelpers.isDescriptorPointerTagged(descriptorPtr)) {
                ++bitIndex;
                descriptorWord = descriptorPtr >>> 1;
            } else {
                descriptorWord = unsafe.getInt(descriptorPtr);
            }
            int countSlots = 0;
            int index = 0;
            while (numSlotsInObject != 0) {
                if (JITHelpers.isDescriptorPointerTagged(descriptorWord)) {
                    Object fieldValue = unsafe.getObject(srcObj, VM.OBJECT_HEADER_SIZE + countSlots * SLOT_SIZE);
                    unsafe.putObject(clnObj, VM.OBJECT_HEADER_SIZE + index * SLOT_SIZE, fieldValue);
                } else {
                    int fieldValue = unsafe.getInt(srcObj, VM.OBJECT_HEADER_SIZE + countSlots * SLOT_SIZE);
                    unsafe.putInt(clnObj, VM.OBJECT_HEADER_SIZE + index * SLOT_SIZE, fieldValue);
                }
                if (++countSlots >= numSlotsInObject) break;
                if (bitIndex == DESCRIPTION_WORD_BIT_SIZE - 1) {
                    bitIndex = 0;
                    descriptorWord = unsafe.getInt(descriptorPtr += DESCRIPTION_WORD_SIZE);
                } else {
                    descriptorWord >>>= 1;
                    ++bitIndex;
                }
                ++index;
            }
            if ((lockOffset = (long)unsafe.getInt(j9clazz + VM.J9CLASS_LOCK_OFFSET_OFFSET)) != 0L) {
                unsafe.putInt(clnObj, lockOffset, 0);
            }
        } else {
            long lockOffset;
            long j9clazz = unsafe.getLong(clnClass, JLCLASS_J9CLASS_OFFSET);
            long instanceSize = unsafe.getLong(j9clazz + (long)VM.J9CLASS_INSTANCESIZE_OFFSET);
            long descriptorPtr = unsafe.getLong(j9clazz + (long)VM.J9CLASS_INSTANCE_DESCRIPTION_OFFSET);
            int numSlotsInObject = (int)(instanceSize / (long)SLOT_SIZE);
            long descriptorWord = 0L;
            if (JITHelpers.isDescriptorPointerTagged(descriptorPtr)) {
                ++bitIndex;
                descriptorWord = descriptorPtr >>> 1;
            } else {
                descriptorWord = unsafe.getLong(descriptorPtr);
            }
            int countSlots = 0;
            int index = 0;
            while (numSlotsInObject != 0) {
                if (JITHelpers.isDescriptorPointerTagged(descriptorWord)) {
                    Object fieldValue = unsafe.getObject(srcObj, VM.OBJECT_HEADER_SIZE + countSlots * SLOT_SIZE);
                    unsafe.putObject(clnObj, VM.OBJECT_HEADER_SIZE + index * SLOT_SIZE, fieldValue);
                } else {
                    long fieldValue = unsafe.getLong(srcObj, VM.OBJECT_HEADER_SIZE + countSlots * SLOT_SIZE);
                    unsafe.putLong(clnObj, VM.OBJECT_HEADER_SIZE + index * SLOT_SIZE, fieldValue);
                }
                if (++countSlots >= numSlotsInObject) break;
                if (bitIndex == DESCRIPTION_WORD_BIT_SIZE - 1) {
                    bitIndex = 0;
                    descriptorWord = unsafe.getLong(descriptorPtr += (long)DESCRIPTION_WORD_SIZE);
                } else {
                    descriptorWord >>>= 1;
                    ++bitIndex;
                }
                ++index;
            }
            if ((lockOffset = unsafe.getLong(j9clazz + (long)VM.J9CLASS_LOCK_OFFSET_OFFSET)) != 0L) {
                if (SLOT_SIZE == 4) {
                    unsafe.putInt(clnObj, lockOffset, 0);
                } else {
                    unsafe.putLong(clnObj, lockOffset, 0L);
                }
            }
        }
        unsafe.storeFence();
        return clnObj;
    }

    public final boolean isPackedObject32(int j9clazz) {
        return (this.getClassDepthAndFlagsFromJ9Class32(j9clazz) >> VM.J9_JAVA_CLASS_RAM_SHAPE_SHIFT & VM.OBJECT_HEADER_SHAPE_MASK) == VM.OBJECT_HEADER_SHAPE_PACKED;
    }

    public final boolean isPackedObject64(long j9clazz) {
        return (this.getClassDepthAndFlagsFromJ9Class64(j9clazz) >> VM.J9_JAVA_CLASS_RAM_SHAPE_SHIFT & (long)VM.OBJECT_HEADER_SHAPE_MASK) == (long)VM.OBJECT_HEADER_SHAPE_PACKED;
    }

    public final native void GPUHelper();

    public native boolean is32Bit();

    public native int getNumBitsInReferenceField();

    public native int getNumBytesInReferenceField();

    public native int getNumBitsInDescriptionWord();

    public native int getNumBytesInDescriptionWord();

    public native int getNumBytesInJ9ObjectHeader();

    public native int getJ9ClassFromClass32(Class var1);

    public native Class getClassFromJ9Class32(int var1);

    public native int getTotalInstanceSizeFromJ9Class32(int var1);

    public native int getInstanceDescriptionFromJ9Class32(int var1);

    public native int getDescriptionWordFromPtr32(int var1);

    public native long getJ9ClassFromClass64(Class var1);

    public native Class getClassFromJ9Class64(long var1);

    public native long getTotalInstanceSizeFromJ9Class64(long var1);

    public native long getInstanceDescriptionFromJ9Class64(long var1);

    public native long getDescriptionWordFromPtr64(long var1);

    public native int getNumSlotsInObject(Class var1);

    public native int getSlotIndex(Field var1);

    public native boolean isDescriptorPointerTagged(int var1, long var2);

    public native int getRomClassFromJ9Class32(int var1);

    public native int getSuperClassesFromJ9Class32(int var1);

    public native int getClassDepthAndFlagsFromJ9Class32(int var1);

    public native int getBackfillOffsetFromJ9Class32(int var1);

    public native int getArrayShapeFromRomClass32(int var1);

    public native int getModifiersFromRomClass32(int var1);

    public native long getRomClassFromJ9Class64(long var1);

    public native long getSuperClassesFromJ9Class64(long var1);

    public native long getClassDepthAndFlagsFromJ9Class64(long var1);

    public native long getBackfillOffsetFromJ9Class64(long var1);

    public native int getArrayShapeFromRomClass64(long var1);

    public native int getModifiersFromRomClass64(long var1);

    public native int getClassFlagsFromJ9Class32(int var1);

    public native int getClassFlagsFromJ9Class64(long var1);

    static {
        dummyDecFormat = new DecimalFormatHelper();
        CLASS_IS_INTERFACE_OR_PRIMITIVE = JITHelpers.classIsInterfaceFlag() | VM.J9_ACC_CLASS_INTERNAL_PRIMITIVE_TYPE;
        JLCLASS_J9CLASS_OFFSET = JITHelpers.javaLangClassJ9ClassOffset();
        POINTER_SIZE = VM.ADDRESS_SIZE;
        IS_32_BIT = POINTER_SIZE == 4;
        helpers = new JITHelpers();
        unsafe = Unsafe.getUnsafe();
        DESCRIPTION_WORD_SIZE = VM.ADDRESS_SIZE;
        DESCRIPTION_WORD_BIT_SIZE = DESCRIPTION_WORD_SIZE * 8;
        SLOT_SIZE = VM.FJ9OBJECT_SIZE;
    }
}

